<%@page language="java" pageEncoding="UTF-8" %>
<%@include file="/common/header.jsp" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Activiti办理中任务</title>
    <%@include file="/common/jsLib.jsp" %>
    <style>
        .form-text {
            border: 1px solid #6fc6df;
            border-radius: 3px;
            width: 90%;
            margin-top: 2px;
            height: 24px;
            line-height: 26px;
        }

        tr, th, td {
            border: 1px solid #d5d5d5;
        }

        th {
            height: 30px;
            line-height: 30px;
            font-style: inherit;
        }
    </style>
    <script type="text/javascript">
        var allowedBack = false;
        var freeFlowData = null;
        var ActivityId = null;

        $(function () {
            $('#deptTree').tree({
                url: 'findChildDept.action',
                onBeforeExpand: function (node) {
                    $('#deptTree').tree('options').url = "findChildDept.action?selDept=" + node.id;
                },
                onClick: function (node) {
                    if (node.attributes == "last") { //判断是否为叶节点
                        $('#inputStr').val(node.text);
                        $('#inputUserId').val(node.id);
                        $('#inputPhoneNum').val(node.phoneNum);
                    }
                    else {
                        $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                    }
                },
                onDblClick: function (node) {
                    $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                }

            });
        });

        function handleTask(taskId) {
            createSimpleWindow("win_handleTask", "处理任务", "${ctx}/jsp/leaveDemo/handleTask.action?taskId=" + taskId, 1000, 500);
        }

        function show_diagram(taskId) {
            createSimpleWindow("diagram", "流程图", "${ctx}/jsp/activiti/showDiagram.action?taskId=" + taskId, 1000, 500);
        }
        
        function view(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_xmxxb","查看项目信息表","${ctx}/jsp/xmxxb/xmxxbView.action?xmxxb.id="+row_Id+"&dt="+dt.getTime(),800,500);
        	
        }

        function reloadDate() {
            doQuery();
        }
        function close_win() {
            $("#newWindow").window("close");
        }
        function doQuery() {
			var queryParams = {
					"processDefName" : $("#processDefName").val()
			};
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }
        function doTerminate(id) {
            $.messager.confirm('终止流程', '确定要终止流程？', function (result) {
                if (result) {
                    $.ajax({
                        url: "terminateProcessInstance.action",
                        type: 'post',
                        dataType: 'json',
                        async: false,
                        data: {
                            "processInstanceId": id
                        },
                        error: function () {
                            $.messager.alert('错误', '终止流程出错！');
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert('提示', '已终止！', 'info', function () {
                                    doQuery();
                                });
                            } else {
                                $.messager.alert('错误', '终止流程时出错！');
                            }
                        }
                    });
                }
            });
        }
        
        function claimBat(){
        	var rows = $('#pagination').datagrid('getSelections');
			if(rows.length<1){
			    $.messager.alert('提示','至少选择一项！');
			    return false;
			}
			var taskIds = "";
			for(var i=0;i<rows.length;i++){
				taskIds += rows[i].id + "|";
			}
			$.ajax({
                url: "claimTaskBat.action",
                type: 'post',
                dataType: 'json',
                async: false,
                data: {
                    "taskIds": taskIds
                },
                error: function () {
                    $.messager.alert('错1误', '签收任务时出错！');
                },
                success: function (data) {
                    if (data.result) {
                        $.messager.alert('提示', '签收任务成功！', 'info', function () {
                            doQuery();
                        });
                    } else {
                        $.messager.alert('错误', '签收任务时出错！');
                    }
                }
            });
        }
        
        function doClaimTask(taskId) {
            $.messager.confirm('签收任务', '确定要签收该任务？', function (result) {
                if (result) {
                    $.ajax({
                        url: "claimTask.action",
                        type: 'post',
                        dataType: 'json',
                        async: false,
                        data: {
                            "taskId": taskId
                        },
                        error: function () {
                            $.messager.alert('错误', '签收任务时出错！');
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert('提示', '签收任务成功！', 'info', function () {
                                    doQuery();
                                });
                            } else {
                                $.messager.alert('错误', '签收任务时出错！');
                            }
                        }
                    });
                }
            });
        }

        $(function () {
            $('#pagination').datagrid($.extend(dg_cm_pp, {
                title: '办理中任务',
                url: 'findClaimedTaskList.action',
        		queryParams:{
        			"processDefName" : $("#processDefName").val()
				},
                frozenColumns:[[
                 	{field:'id',checkbox:true}
                ]],
                columns: [[
					{field: 'processInstanceId', title: '编号', width: fixWidth(0.1)},       
                    //{field: 'id', title: '任务编号', width: fixWidth(0.1)},
                    {field: 'name', title: '任务名称', width: fixWidth(0.1)},
                    {field: 'procDefName', title: '流程名称', width: fixWidth(0.1)},
                    {field: 'projectName', title: '项目名称', width: fixWidth(0.20)},
                    {field: 'slbh', title: '受理编号', width: fixWidth(0.15), formatter: function (value, rec){
                    	return "<a href='#' onclick=\"view('" + rec.businessKey + "')\"><font style='color:blue'>"+value+"</font></a>";
                    }},
                    {
                        field: 'createTime', title: '创建时间', width: fixWidth(0.15)
                    },
                    /* {field: 'description', title: '描述', width: fixWidth(0.1)}, */
                    {
                        field: 'claimTime', title: '签收时间', width: fixWidth(0.15)
                    },
                    {
                        field: 'dueDate', title: '过期时间', width: fixWidth(0.11), formatter: function (value, rec) {
                        if (rec.dueDate == null) return;
                        var date = new Date(rec.dueDate.time);
                        var retStr = date.format("yyyy-MM-dd hh:mm:ss");
                        return retStr;
                    }
                    },
                    {
                        field: 'op', title: '操作', width: fixWidth(0.20), formatter: function (value, rec) {
                        if (null != rec.assignee){
                        	//正在作废挂起申请中的禁止操作
                        	if("0"==rec.returnStatus || "1"==rec.returnStatus){
                        		return "<a href='#' class='btn_01_mini' onclick=\"show_diagram('" + rec.id + "')\">流程图<b></b></a>";
                        	}else{
                               	return "<a href='#' class='btn_01_mini' onclick=\"getTask('" + rec.id + "')\">办理<b></b></a>&nbsp;" +
	                               "<a href='#' class='btn_01_mini' onclick=\"show_diagram('" + rec.id + "')\">流程图<b></b></a>";
                        	}
                         }
                        else
                            return "<a href='#' class='btn_01_mini' onclick=\"doClaimTask('" + rec.id + "')\">签收<b></b></a>&nbsp;" +
                                    "<a href='#' class='btn_01_mini' onclick=\"show_diagram('" + rec.id + "')\">流程图<b></b></a>";
                    }
                    }
                ]],
                toolbar:[{
					id:'btnadd',
					text:'批量签收',
					iconCls:'icon-add',
					handler:function(){
						claimBat();
					}
				}],
				onLoadSuccess: function(data){//加载完毕后获取所有的checkbox遍历
			        if (data.rows.length > 0) {
			            //循环判断操作为新增的不能选择
			            for (var i = 0; i < data.rows.length; i++) {
			                //根据isFinanceExamine让某些行不可选
			                if (data.rows[i].returnStatus == 0 || data.rows[i].returnStatus == 1 || null != data.rows[i].assignee) {
			                    $("input[type='checkbox']")[i + 1].disabled = true;
			                }
			            }
			        }
			    },
			    onClickRow: function(rowIndex, rowData){
			        //加载完毕后获取所有的checkbox遍历
			        $("input[type='checkbox']").each(function(index, el){
			            //如果当前的复选框不可选，则不让其选中
			            if (el.disabled == true) {
			                $('#pagination').datagrid('unselectRow', index - 1);
			            }
			        })
			    }
            }));
        });
        function chooseAgent(taskId, assignee) {
            window.currTaskId = taskId;
            window.assignee = assignee;

            $("#delegateWindow").window("open");
            document.getElementById("inputStr").value = "";
            document.getElementById("inputUserId").value = "";
            document.getElementById("inputPhoneNum").value = "";
        }
        function getTask(taskId) {
            window.currTaskId = taskId;
            $.ajax({
                url: "${ctx}/jsp/activiti/claimTask.action",
                data: {
                    taskId: taskId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        //获取是否可回退属性 @yangshunqing
                        allowedBack = data.allowedBack;
                        if (allowedBack)
                            $("#allowback").show();
                        else
                            $("#allowback").hide();

                        if (data.taskHandlerUrl) {
                            if (data.taskHandlerUrl.indexOf("?") != -1) {
                                data.taskHandlerUrl = data.taskHandlerUrl + "&taskId=" + data.taskId + "&processInstanceId=" + data.processInstanceId + "&businessKey=" + data.businessKey;
                            } else {
                                data.taskHandlerUrl = data.taskHandlerUrl + "?taskId=" + data.taskId + "&processInstanceId=" + data.processInstanceId + "&businessKey=" + data.businessKey;
                            }

                            parent.addTab("doTask", data.taskName, data.taskHandlerUrl);
                        } else if (data.tfd) {
                            showForm(data.taskName, data.tfd, data.nextSteps);
                        } else {
                            $.messager.alert("错误", "未配置办理业务");
                        }
                    } else {
                        $.messager.alert("错误", "办理出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "办理出错");
                }
            });
        }
        function showForm(taskName, form, nextSteps) {
            $("#form").empty();

            // 构造Task表单
            var length = form.length;
            for (var i = 0; i < length; i++) {
                var prop = form[i];
                var id = prop.id;
                var name = prop.name;
                var readable = prop.readable;
                var required = prop.required;
                var writable = prop.writable;
                var type = prop.type.name;
                var value = prop.value;
                if (!readable)
                    continue;
                if (i == 0)
                    var row = $("<div style='width: 98%;height: 30px;border: 1px solid #d5d5d5;margin: 0px;'></div>");
                else
                    var row = $("<div style='width: 98%;height: 30px;border-right: 1px solid #d5d5d5;border-left: 1px solid #d5d5d5;border-bottom: 1px solid #d5d5d5;margin: 0px;'></div>");
                var labelDiv = $("<div style='width: 20%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'><strong>" + name + "</strong></div>");
                var fieldDiv = $("<div style='width: 80%;float: right;height:30px;text-align: center;'></div>");

                if (type == "date") {
                    if (writable) {
                        fieldDiv.html("<input   class='Wdate formfield' id='" + id + "' data-options='formatter:formatDate,parser:parseDate' value='" + value + "'>");
                    } else {
                        fieldDiv.html(value);
                    }
                } else if (type == "enum") {
                    if (writable) {
                        var select = $("<select  class='easyui-combobox form-text formfield' id='" + id + "' ></select>");
                        var values = prop.values;
                        if (values) {
                            for (var key in values) {
                                var option = new Option(values[key], key);
                                select.append(option);
                            }
                        }
                        fieldDiv.html(select);
                    } else {
                        fieldDiv.html(value);
                    }
                } else {
                    if (writable) {
                        fieldDiv.html("<input class='form-text formfield' id='" + id + "' value='" + value + "'>");
                    } else {
                        fieldDiv.html(value);
                    }
                }
                row.append(labelDiv);
                row.append(fieldDiv);
                $("#form").append(row);
                $(".Wdate").bind("click", function () {
                    WdatePicker({
                        dateFmt: 'yyyy-MM-dd HH:mm:ss'
                    });
                });
                $(".Wdate").addClass("form-text");
            }
            var length = 0;
            if (nextSteps)
                length = nextSteps.length;
            if (length > 0) {
                var height = 30 * length + 20;

                var row = $("<div style='width: 98%;height: " + height + "px;border-right: 1px solid #d5d5d5;border-left: 1px solid #d5d5d5;border-bottom: 1px solid #d5d5d5;margin: 0px;'></div>");
                var labelDiv = $("<div id='leftLabel' style='width: 20%;height:" + height + "px;float: left;background: #BEE9F0;text-align: center;'><strong>设置参与者</strong></div>");
                var fieldDiv = $("<div style='width: 80%;float: right;height:" + height + "px;text-align: center;' ><table style='width:100%;border: 1px solid #d5d5d5; padding: 2px;'><thead><tr><th width='240px'>任务名称</th><th width='150px'>处理人</th><th width='150px'>备选人</th><th width='150px'>备选角色</th></tr></thead><tbody id='participants'></tbody></table></div>");
                row.append(labelDiv);
                row.append(fieldDiv);
                $("#form").append(row);
            }

            for (var i = 0; i < length; i++) {
                var nextStep = nextSteps[i];

                var changeAsign = nextStep.changeAsign;
                if (!changeAsign)
                    continue;

                var asignee = nextStep.assignee;
                if (!asignee)
                    asignee = "";
                var candidateUsers = nextStep.candidateUsers;
                var candidateGroups = nextStep.candidateGroups;
                var name = nextStep.name;
                var taskId = nextStep.id;

                var row = $("<tr><td>" + name + "</td><td><input id='asignee_" + taskId + "' class='form-text assignee' value='" + asignee + "'></td><td><input class='form-text searchCandidateUsers' value=''><br><select multiple='multiple' size=5 style='width: 90%;' class='candidate candidateUsers' id='candidateUsers_" + taskId + "'></select></td><td><select multiple='multiple' style='width: 90%;' size=5 class='candidate candidateGroups' id='candidateGroups_" + taskId + "'></select><br><a class='addBtn' href='javascript:void(0)' onclick='searchCandidateGroup(\"" + taskId + "\")' style='width:60px'>添加</a><a class='removeBtn' href='javascript:void(0)' onclick='removeCandidateGroup()' style='width:60px'>删除</a></td></tr>")
                $("#participants").append(row);
                var len = candidateUsers.length;
                for (var j = 0; j < len; j++) {
                    $("#candidateUsers_" + taskId).append(new Option(candidateUsers[j]));
                }

                len = candidateGroups.length;
                for (var j = 0; j < len; j++) {
                    $("#candidateGroups_" + taskId).append(new Option(candidateGroups[j], candidateGroups[j]));
                }
            }

            $(".candidate").bind("dblclick", function () {
                $(this).find("option:selected").remove();
            });
            $("#taskWindow").window("open");
            $("#leftLabel").height($("#participants").parent().height());
            $("#leftLabel").attr("style", $("#leftLabel").attr("style") + "line-height:" + $("#leftLabel").height() + "px;");
            $("#leftLabel").parent().height($("#participants").parent().height() + 4);
            $("#participants").parent().height($("#participants").height() + 4);
            $("#form").height($("#participants").height() + 80 + form.length * 30)
            $("#taskWindow").window({
                "title": taskName,
                "height": $("#form").height() + 40,
                top: 0
            });
            $(".addBtn").linkbutton({
                iconCls: 'icon-add'
            });
            $(".removeBtn").linkbutton({
                iconCls: 'icon-remove'
            });
            $("#taskWindow").window("open");

            $(".assignee").autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: "${ctx}/jsp/admin/user/queryUser.action",
                        dataType: "json",
                        data: {
                            "inputStr": request.term
                        },
                        success: function (data) {
                            response($.map(data, function (item) {
                                $(".ui-autocomplete").show();
                                $(".ui-autocomplete").attr("style", $(".ui-autocomplete").attr("style") + "z-index:9999999;");
                                return {
                                    label: item.displayName + "|" + item.dept.deptName, // 下拉项显示内容
                                    value: item.loginId
                                }
                            }));
                        }
                    });
                },
                minLength: 2
            });

            $(".searchCandidateUsers").autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: "${ctx}/jsp/admin/user/queryUser.action",
                        dataType: "json",
                        data: {
                            "inputStr": request.term
                        },
                        success: function (data) {
                            response($.map(data, function (item) {
                                $(".ui-autocomplete").show();
                                $(".ui-autocomplete").attr("style", $(".ui-autocomplete").attr("style") + "z-index:9999999;");
                                return {
                                    label: item.displayName + "|" + item.dept.deptName, // 下拉项显示内容
                                    value: item.loginId
                                }
                            }));
                        }
                    });
                }, select: function (event, ui) {
                    var select = $(this).parent().find("select");
                    var length = select.find("option[value='" + ui.item.value + "']").length;
                    if (length == 0) {
                        var option = new Option(ui.item.value, ui.item.value);
                        select.append(option);
                    } else {
                        $.messager.alert("提示", "已经添加过该用户");
                    }
                    ui.item.value = "";
                    this.value = "";
                },
                minLength: 2
            });
        }
        function removeCandidateGroup() {
            $(".candidate").find("option:selected").remove();
        }
        $(document).ready(function () {
            $("#inputStr").autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: "${ctx}/jsp/admin/user/queryUser.action",
                        dataType: "json",
                        data: {
                            "inputStr": request.term
                        },
                        success: function (data) {
                            response($.map(data, function (item) {
                                $(".ui-autocomplete").show();
                                $(".ui-autocomplete").attr("style", $(".ui-autocomplete").attr("style") + "z-index:9999999;");
                                return {
                                    label: item.displayName + "|" + item.dept.deptName, // 下拉项显示内容
                                    value: item.loginId
                                }
                            }));
                        }
                    });
                },
                minLength: 2
            });
        });

        function delegateTask() {
            var loginId = $("#inputUserId").val();
            if (loginId == "") {
                $.messager.alert("提示", "请选择代办人");
                return false;
            }

            if (loginId == window.assignee) {
                $.messager.alert("提示", "代办人不能是自己");
                return false;
            }

            $.ajax({
                url: "${ctx}/jsp/activiti/delegateTask.action",
                data: {
                    taskId: window.currTaskId,
                    userId: loginId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        $.messager.alert("成功", "委托成功");
                        document.getElementById("inputStr").value = "";
                        document.getElementById("inputUserId").value = "";
                        document.getElementById("inputPhoneNum").value = "";
                        $("#delegateWindow").window("close");
                        doQuery();
                    }
                    else {
                        $.messager.alert("错误", "委托出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "委托出错");
                }
            });
        }
        function doTask(isSaved) {
            var form = {};
            var formfields = $(".formfield");
            var length = formfields.length;
            for (var i = 0; i < length; i++) {
                var formfield = formfields[i];
                form["'" + formfield.id + "'"] = formfield.value;
            }
            var asignee = {};
            var assignees = $(".assignee");
            var candidateUsers = $(".candidateUsers");
            var candidateGroups = $(".candidateGroups");
            var length = assignees.length;
            for (var i = 0; i < length; i++) {
                var taskId = assignees[i].id.split("_")[1];
                asignee["'" + taskId + "'"] = {};
                asignee["'" + taskId + "'"]['asign'] = [];
                asignee["'" + taskId + "'"]['asign'].push(assignees[i].value);
                asignee["'" + taskId + "'"]['candidateUsers'] = [];
                var options = $(candidateUsers[i]).find("option");
                var len = options.length;
                for (var j = 0; j < len; j++) {
                    asignee["'" + taskId + "'"]['candidateUsers'].push(options[j].value);
                }
                asignee["'" + taskId + "'"]['candidateGroups'] = [];
                options = $(candidateGroups[i]).find("option");
                var len = options.length;
                for (var j = 0; j < len; j++) {
                    asignee["'" + taskId + "'"]['candidateGroups'].push(options[j].value);
                }
            }
            asignee = JSON.stringify(asignee);

            $.ajax({
                url: "${ctx}/jsp/activiti/doTask.action",
                data: {
                    taskId: window.currTaskId,
                    formMap: form,
                    asignee: asignee,
                    isSaved: isSaved
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        window.currTaskId = null;
                        $.messager.alert("成功", "成功办理");
                        $("#taskWindow").window("close");
                        doQuery();
                    } else {
                        $.messager.alert("错误", "办理出错");
                    }
                },
                error: function () {
                    window.currTaskId = null;
                    $.messager.alert("错误", "办理出错");
                }
            });
        }
        function searchCandidateGroup(taskId) {
            window.currTaskName = taskId;
            window.candidateGroups = "";
            var groupOptions = $("#candidateGroups_" + window.currTaskName).find("option");
            var len = groupOptions.length;
            for (var i = 0; i < len; i++) {
                window.candidateGroups += groupOptions[i].value + "|";
            }

            $('#deptTree001').tree({
                checkbox: true,
                cascadeCheck: true,
                url: '${ctx}/jsp/admin/dept/findChildDeptByCurrUser.action',
                onBeforeExpand: function (node, param) {
                    $('#deptTree001').tree('options').url = "${ctx}/jsp/admin/dept/findChildDeptByCurrUser.action?selDept=" + node.id;
                }
            });
            $('#roleTree').tree({
                checkbox: true,
                cascadeCheck: true,
                url: '${ctx}/jsp/admin/role/findChildNode.action?userRole.roleType=ALL',
                onBeforeExpand: function (node, param) {
                    $('#roleTree').tree('options').url = "${ctx}/jsp/admin/role/findChildNode.action?userRole.roleType=All&selNode=" + node.id;
                }
            });
            $("#groupWindow").window('open');
        }
        function setGroup() {

            var roles = $("#roleTree").tree("getChecked");
            var depts = $("#deptTree001").tree("getChecked");
            var roleLen = roles.length;
            if (roleLen == 0) {
                $.messager.alert("提示", "请选择角色");
                return false;
            }
            var deptLen = depts.length;
            var groups = [];
            for (var i = 0; i < roleLen; i++) {
                if (roles[i].text === "角色")
                    continue;
                if (deptLen > 0) {
                    for (var j = 0; j < deptLen; j++) {
                        if (depts[j].id)
                            groups.push(depts[j].id + "|" + roles[i].text);
                    }
                } else {
                    groups.push(roles[i].text);
                }
            }
            var len = groups.length;
            for (var i = 0; i < len; i++) {
                var select = $("#candidateGroups_" + window.currTaskName);
                var length = select.find("option[value='" + groups[i] + "']").length;
                if (length == 0) {
                    var option = new Option(groups[i], groups[i]);
                    select.append(option);
                }
            }
            window.currTaskName = null;
            $("#groupWindow").window('close');
        }
        //***********@yangshunqing************//
        function drawbackTask() {
            if (allowedBack) {//可以回退，则执行回退
                $.ajax({
                    url: "${ctx}/jsp/activiti/drawbackTask.action",
                    data: {
                        taskId: window.currTaskId
                    },
                    dataType: "json",
                    type: "post",
                    success: function (data) {
                        if (data.result) {
                            $.messager.alert("成功", "成功驳回");
                            $("#taskWindow").window("close");
                            doQuery();
                        } else {

                            if (data.notAllowback) {
                                $.messager.alert("提示", "其他分支任务已处理，不可回退！");
                            } else {
                                $.messager.alert("错误", "处理出错");
                                $("#taskWindow").window("close");
                                doQuery();
                            }

                        }
                    },
                    error: function () {
                        $.messager.alert("错误", "驳回失败");
                        $("#taskWindow").window("close");
                        doQuery();
                    }
                });
            } else {
                $.messager.alert("提示", "不可驳回");
            }
        }

        function movetoTask(currTaskId) {
            var ActivityId = $("#inputTaskNode").val();
            if (ActivityId == "") {
                $.messager.alert("提示", "请输入要跳转的节点");
                return false;
            }

            $.ajax({
                url: "${ctx}/jsp/activiti/movetoTask.action",
                data: {
                    taskId: currTaskId,
                    MovetoActivityId: ActivityId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        $.messager.alert("成功", "跳转成功");
                        $("#chooseTaskWindow").window("close");
                        $("#taskWindow").window("close");
                        doQuery();
                    }
                    else {
                        $.messager.alert("错误", "跳转出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "跳转出错");
                }
            });
        }

        function getProcessMap() {
            var currTaskId = window.currTaskId;

            $.ajax({
                url: "${ctx}/jsp/activiti/getProcessMap.action",
                data: {
                    taskId: currTaskId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        freeFlowData = data;
                        var tableDom = $('#showTask');
                        var html = '';
                        html += '<img id="graph" src="showDiagram.action?processDefinitionId=' + data.procDefId + '" style="position:absolute; left:0px; top:0px;">';
                        for (var i = 0; i < data.total; i++) {
                            if (data.rows[i].id == data.curTaskdefId) {//当前处理人的任务
                                html += '<div style="position:absolute; border:2.5px solid red; border-radius:8px; left:' + (data.rows[i].x - 1) + 'px;top:' + (data.rows[i].y - 1) + 'px;width:' + data.rows[i].width + 'px;height:' + data.rows[i].height + 'px;"></div>';
                            } else if (data.rows[i].isCurTask == "Y") { //当前流程节点
                                html += '<div style="position:absolute; border:2.5px solid #FF7744; border-radius:8px; left:' + (data.rows[i].x - 1) + 'px;top:' + (data.rows[i].y - 1) + 'px;width:' + data.rows[i].width + 'px;height:' + data.rows[i].height + 'px;"></div>';
                            } else {
                                html += '<div style="position:absolute; border:2px solid #33CCFF; border-radius:8px; left:' + (data.rows[i].x - 1) + 'px;top:' + (data.rows[i].y - 1) + 'px;width:' + data.rows[i].width + 'px;height:' + data.rows[i].height + 'px;"></div>';
                            }
                        }
                        html += '<div id="getTask"></div>';
                        tableDom.html(html);
                        $("#movetoWindow").window("open");

                    }
                    else {
                        $.messager.alert("错误", "获取出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "获取出错");
                }
            });

        }

        function getCoordinate(ev) {

            var imgX = $('#graph').offset().left;//图片相对窗口的X轴偏移
            var imgY = $('#graph').offset().top; //图片相对窗口的Y轴偏移

            var oEvent = ev || event;
            var oLeft = oEvent.clientX - imgX;//鼠标单击位置相对图片的X轴偏移
            var oTop = oEvent.clientY - imgY;

            if (freeFlowData != null) {
                var TaskDom = $('#getTask');
                for (var i = 0; i <= freeFlowData.total; i++) {
                    var html = '';
                    var id = freeFlowData.rows[i].id;
                    var x = freeFlowData.rows[i].x;
                    var y = freeFlowData.rows[i].y;
                    var width = freeFlowData.rows[i].width;
                    var height = freeFlowData.rows[i].height;

                    if (oLeft > x && oTop > y && oLeft < (x + width) && oTop < (y + height) && ("Y" != freeFlowData.rows[i].isCurTask)) {
                        html += '<div style="position:absolute; border:2.5px solid blue; border-radius:8px; left:' + (x - 1) + 'px;top:' + (y - 1) + 'px;width:' + width + 'px;height:' + height + 'px;"></div>';
                        TaskDom.html(html);
                        ActivityId = freeFlowData.rows[i].id;
                        break;
                    }
                }

            }
        }

        function movetoTask(currTaskId) {
            if (ActivityId === "") {
                $.messager.alert("提示", "请选择要跳转的节点");
                return false;
            }

            $.ajax({
                url: "${ctx}/jsp/activiti/movetoTask.action",
                data: {
                    taskId: currTaskId,
                    MovetoActivityId: ActivityId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        $.messager.alert("成功", "跳转成功");
                        $("#movetoWindow").window("close");
                        $("#taskWindow").window("close");
                        doQuery();
                    }
                    else {
                        $.messager.alert("错误", "跳转出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "跳转出错");
                }
            });
        }

    </script>
</head>

<body>
<input type="hidden" value="" id="allowedback"></input>
<div class="page_content">
    <div class="box_01 submitdata">
        <div class="inner12px">
            <form name="myform" method="post">
				<div class="cell boxBmargin12">
					<table>
						<tr style="display: none;">
							<th width="15%">流程名称</th>
							<td width="35%"><input type="text" id="processDefName" name="processDefName" value="征收流程"></td>
							<td width="50%">
							<div class="btn_area_setc">
									<a href="###" class="btn_01" onclick="doQuery()">查询<b></b></a>
									<a href="###" class="btn_01" onclick="clear_form(document.myform);">清空<b></b></a>
								</div>
							</td>
						</tr>
					</table>
				</div>
				<div id="pagination"></div>
			</form>
        </div>
    </div>
</div>
<div id="taskWindow" class="easyui-window" title="" data-options="modal:true,closed:true"
     style="width:800px;height:200px;padding:5px;">
    <div class="easyui-layout" data-options="fit:true">
        <div id="form" style="overflow: auto;"></div>
        <div data-options="region:'south',border:false" style="text-align:right;padding:5px 0 0;">
            <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
               onclick='getProcessMap()' style="width:80px">跳转</a>
            <a id="allowback" class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
               onclick="drawbackTask()" style="width:80px">驳回</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
               onclick="doTask(false)" style="width:80px">办理</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-save'" href="javascript:void(0)"
               onclick="doTask(true)" style="width:80px">暂存</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)"
               onclick='$("#taskWindow").window("close");' style="width:80px">关闭</a>
        </div>
    </div>
</div>

<div id="delegateWindow" class="easyui-window" title="选择代办人" data-options="closed:true"
     style="width:300px;height:400px;padding:5px;">
    <div class="easyui-layout" data-options="fit:true">
        <div style='width: 98%;height: 200px;border: 1px solid #d5d5d5; overflow:auto;margin: 0px;'>
            <ul id="deptTree"></ul>
        </div>
        <div style='width: 98%;height: 90px;border: 1px solid #d5d5d5;margin: 5px 0px;'>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>用户名:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;'><input id='inputStr' class='form-text'
                                                                                        style='padding-left:5px;'
                                                                                        readonly></div>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>用户ID:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;'><input id='inputUserId'
                                                                                        class='form-text'
                                                                                        style='padding-left:5px;'
                                                                                        readonly></div>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>手机号:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;'><input id='inputPhoneNum'
                                                                                        class='form-text'
                                                                                        style='padding-left:5px;'
                                                                                        readonly></div>
        </div>
        <div data-options="region:'south',border:false" style="text-align:right;padding:0px 0 0;">
            <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
               onclick="delegateTask()" style="width:80px">委托</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)"
               onclick='$("#delegateWindow").window("close");' style="width:80px">关闭</a>
        </div>
    </div>
</div>

<div id="groupWindow" class="easyui-window" title="选择角色" data-options="closed:true"
     style="width:650px;height:400px;padding:5px;">
    <div class="easyui-layout" data-options="fit:true">
        <div style="width: 100%; height:100%;overflow-y: auto;">
            <div class="popwin_layer_01" style="height: 100%;">
                <div class="popwin_layer_01_left">
                    <div class="box_01">
                        <div class="caption_01">待选择角色</div>
                        <div class="inner6px">
                            <ul id="roleTree"></ul>
                        </div>
                    </div>
                </div>
                <div class="popwin_layer_01_right">
                    <div class="box_01">
                        <div class="caption_01">待选择部门</div>
                        <div class="inner6px">
                            <ul id="deptTree001"></ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div data-options="region:'south',border:false" style="text-align:right;padding:5px 0 0;">
            <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)" onclick="setGroup()"
               style="width:80px">确认</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)"
               onclick='window.currTaskId = null;$("#groupWindow").window("close");' style="width:80px">关闭</a>
        </div>
    </div>
</div>

<div id="movetoWindow" class="easyui-window" title="选择跳转的任务节点" data-options="closed:true"
     style="width:1000px;height:400px;position:relative" ;padding:5px;
">
<div class="easyui-layout" data-options="fit:true" style="position:absolute;overflow:auto;">
    <div style="position:absolute; border:2.5px solid red; border-radius:3px; left:5px;top:5px;width:10px;height:8px;"></div>
    <p style="position:absolute;left:22px;top:3px;">:当前任务节点</p>
    <div style="position:absolute; border:2.5px solid #33CCFF; border-radius:3px; left:5px;top:23px;width:10px;height:8px;"></div>
    <p style="position:absolute;left:22px;top:20px;">:可跳转的任务节点(点选)</p>
    <div id="showTask" onclick="getCoordinate(event)"></div>
</div>
<div data-options="region:'south',border:false" style="text-align:right;position:absolute;right:5px;bottom:5px">
    <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
       onclick="movetoTask(window.currTaskId)" style="width:80px">跳转</a>
    <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)"
       onclick='$("#movetoWindow").window("close");' style="width:80px">关闭</a>
</div>
</div>

</body>
</html>