/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.web;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleGetTaskRecordsAction
extends ActionNoSessionCMD {
    private List<ScheduleTask> scheduleTaskList = Collections.synchronizedList(new ArrayList());

    public String getCMD() {
        return "get_task_log";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 16L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"start");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"count");
        String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"taskname");
        String string4 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startdate");
        String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"enddate");
        boolean bl = "true".equals(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"issapsyn"));
        int n = 0;
        int n2 = 0;
        if (StringUtils.isNotEmpty((String)string)) {
            n = Integer.valueOf(string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            n2 = Integer.valueOf(string2);
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = this.getRecords(string3, string4, string5, bl);
        JSONArray jSONArray2 = new JSONArray();
        int n3 = Math.min(n + n2, jSONArray.length());
        if (n >= 0) {
            for (int i = n; i < n3; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                jSONArray2.put((Object)jSONObject2);
            }
        }
        jSONObject.put("total", jSONArray.length());
        jSONObject.put("records", (Object)jSONArray2);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private JSONArray getRecords(String string, String string2, String string3, boolean bl) throws Exception {
        Object object;
        Calendar calendar;
        String[] stringArray = StringUtils.isNotBlank((String)string) ? string.split(",") : null;
        if (StringUtils.isNotBlank((String)string3)) {
            calendar = Calendar.getInstance();
            calendar.setTime(DateUtils.string2Date((String)string3, (boolean)false));
            calendar.set(5, calendar.get(5) + 1);
            object = new SimpleDateFormat("yyyy-MM-dd");
            string3 = ((DateFormat)object).format(calendar.getTime());
        }
        calendar = JSONArray.create();
        object = this.getFilterResult(stringArray, string2, string3, bl);
        Iterator<ScheduleTask> iterator = object.iterator();
        while (iterator.hasNext()) {
            ScheduleTask scheduleTask = iterator.next();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string4 = simpleDateFormat.format(scheduleTask.getLogtime());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("taskname", (Object)scheduleTask.getTaskname());
            jSONObject.put("type", scheduleTask.getType());
            jSONObject.put("msg", (Object)scheduleTask.getMsg());
            jSONObject.put("detailmsg", (Object)scheduleTask.getDetailmsg());
            jSONObject.put("trace", (Object)scheduleTask.getTrace());
            jSONObject.put("logtime", (Object)string4);
            calendar.put(jSONObject);
        }
        return calendar;
    }

    private List<ScheduleTask> getFilterResult(String[] stringArray, String string, String string2, boolean bl) throws Exception {
        ArrayList<ScheduleTask> arrayList = new ArrayList<ScheduleTask>();
        ArrayList<ScheduleTask> arrayList2 = new ArrayList<ScheduleTask>();
        this.getScheduleTaskRecords(string, string2);
        int[] nArray = this.getType(bl);
        for (ScheduleTask scheduleTask : this.scheduleTaskList) {
            if (scheduleTask.getType() != nArray[0] && scheduleTask.getType() != nArray[1]) continue;
            arrayList.add(scheduleTask);
            if (stringArray == null) {
                arrayList2 = arrayList;
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!scheduleTask.getTaskname().equals(stringArray[i])) continue;
                arrayList2.add(scheduleTask);
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getScheduleTaskRecords(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (StringUtils.isBlank((String)string)) {
            string = "1970-01-01 00:00:00";
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = simpleDateFormat.format(new Date());
        }
        Date date = simpleDateFormat.parse(string);
        Date date2 = simpleDateFormat.parse(string2);
        Connection connection = DBRecordManager.getDB().createConnection();
        Select select = this.getSelectSQL(date, date2, connection);
        try {
            preparedStatement = select.createPreparedStatement(connection);
            resultSet = preparedStatement.executeQuery();
            this.scheduleTaskList = new ArrayList<ScheduleTask>();
            while (resultSet.next()) {
                this.scheduleTaskList.add(new ScheduleTask(resultSet.getString("trace"), resultSet.getString("tname"), resultSet.getInt("type"), resultSet.getString("msg"), resultSet.getString("detailmsg"), resultSet.getTimestamp("logtime")));
            }
        }
        catch (SQLException sQLException) {
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement((Statement)preparedStatement);
                connection.close();
                throw throwable;
            }
            DBUtils.closeResultSet((ResultSet)resultSet);
            DBUtils.closeStatement((Statement)preparedStatement);
            connection.close();
        }
        DBUtils.closeResultSet((ResultSet)resultSet);
        DBUtils.closeStatement((Statement)preparedStatement);
        connection.close();
    }

    private Select getSelectSQL(Date date, Date date2, Connection connection) throws Exception {
        try {
            Where where = new Where();
            where.addColumn("logtime", 93, 3, (Object)date);
            where.addColumn("logtime", 93, 5, (Object)date2);
            Select select = new Select(new Table("fr_schedulerecord"), where, DialectFactory.generateDialect((Connection)connection));
            select.addOrderBy("logtime", false);
            return select;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private int[] getType(boolean bl) {
        int[] nArray = bl ? new int[]{9, 10} : new int[]{7, 8};
        return nArray;
    }

    private class ScheduleTask {
        private String taskname;
        private int type;
        private String msg;
        private String detailmsg;
        private String trace;
        private Date logtime;

        public ScheduleTask(String string, String string2, int n, String string3, String string4, Date date) {
            this.taskname = string2;
            this.type = n;
            this.msg = string3;
            this.detailmsg = string4;
            this.trace = string;
            this.logtime = date;
        }

        public String getTaskname() {
            return this.taskname;
        }

        public int getType() {
            return this.type;
        }

        public String getDetailmsg() {
            return this.detailmsg;
        }

        public Date getLogtime() {
            return this.logtime;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getTrace() {
            return this.trace;
        }
    }
}

