/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.output.ClassOutputFileAction;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FTPTransmission;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.PrintRWorkbookAction;
import com.fr.schedule.output.PushOutputFileAction;
import java.util.ArrayList;
import java.util.Iterator;

public class FileActionList
extends ArrayList {
    public static final String TABLE_NAME = "fr_schedule_actionlist";
    public static final String EXTRA_OUTPUT_FILE_ACTION_COLUMN_NAME = "extraOutputFileActions";
    public static final int EXTRA_OUT_COLUMN_TYPE = 12;
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(FileActionList.class, new Table("fr_schedule_actionlist"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CompatiableIDFCMapper(EmailNotification.class, "emailNotification", -5, "emailId", new ColumnSize(255), true), new CompatiableIDFCMapper(FTPTransmission.class, "ftpTransmission", -5, "ftpId", new ColumnSize(255), true), new CompatiableIDFCMapper(PrintRWorkbookAction.class, "printRWorkbookAction", -5, "printId", new ColumnSize(255), true), new CompatiableIDFCMapper(ClassOutputFileAction.class, "classOutputFileAction", -5, "classId", new ColumnSize(255), true), new CompatiableIDFCMapper(PushOutputFileAction.class, "pushOutputFileAction", -5, "pushId", new ColumnSize(255), true), new CommonFieldColumnMapper("extraOutputFileActions", 12, "extraOutputFileActions", new ColumnSize(255), false, new FCValueMapper(){

        public Object field2Value(Object object) {
            try {
                JSONObject jSONObject = new JSONObject();
                if (object != null) {
                    jSONObject = new JSONObject(object.toString());
                }
                JSONObject jSONObject2 = new JSONObject();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    OutputFileAction outputFileAction = (OutputFileAction)Class.forName(string).newInstance();
                    outputFileAction = outputFileAction.analyzeJSON(jSONObject.getJSONObject(string));
                    ScheduleContext.createDAOSession().saveOrUpdate((Object)outputFileAction);
                    jSONObject2.put(string, outputFileAction.getId());
                }
                return jSONObject2.toString();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                return null;
            }
        }

        public Object value2Field(Object object) {
            try {
                JSONObject jSONObject = new JSONObject();
                if (object != null) {
                    jSONObject = new JSONObject(object.toString());
                }
                JSONObject jSONObject2 = new JSONObject();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    long l = jSONObject.getLong(string);
                    OutputFileAction outputFileAction = (OutputFileAction)ScheduleContext.createDAOSession().load(Class.forName(string), l);
                    jSONObject2.put(string, (Object)outputFileAction.createJSONConfig());
                }
                return jSONObject2.toString();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                return null;
            }
        }
    })});
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private EmailNotification emailNotification = null;
    private FTPTransmission ftpTransmission = null;
    private PrintRWorkbookAction printRWorkbookAction = null;
    private ClassOutputFileAction classOutputFileAction = null;
    private PushOutputFileAction pushOutputFileAction = null;
    private String extraOutputFileActions = null;

    public boolean addFileAction(OutputFileAction outputFileAction) {
        boolean bl = super.add(outputFileAction);
        if (outputFileAction instanceof EmailNotification) {
            this.emailNotification = (EmailNotification)outputFileAction;
        } else if (outputFileAction instanceof FTPTransmission) {
            this.ftpTransmission = (FTPTransmission)outputFileAction;
        } else if (outputFileAction instanceof PrintRWorkbookAction) {
            this.printRWorkbookAction = (PrintRWorkbookAction)outputFileAction;
        } else if (outputFileAction instanceof ClassOutputFileAction) {
            this.classOutputFileAction = (ClassOutputFileAction)outputFileAction;
        } else if (outputFileAction instanceof PushOutputFileAction) {
            this.pushOutputFileAction = (PushOutputFileAction)outputFileAction;
        } else {
            try {
                JSONObject jSONObject = this.extraOutputFileActions == null ? new JSONObject() : new JSONObject(this.extraOutputFileActions);
                jSONObject.put(outputFileAction.getClass().getName(), (Object)outputFileAction.createJSONConfig());
                this.extraOutputFileActions = jSONObject.toString();
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        if (!this.contains(outputFileAction)) {
            this.add(outputFileAction);
        }
        return bl;
    }

    public void synFileActionList() {
        if (this.emailNotification != null) {
            this.add(this.emailNotification);
        }
        if (this.ftpTransmission != null) {
            this.add(this.ftpTransmission);
        }
        if (this.classOutputFileAction != null) {
            this.add(this.classOutputFileAction);
        }
        if (this.printRWorkbookAction != null) {
            this.add(this.printRWorkbookAction);
        }
        if (this.pushOutputFileAction != null) {
            this.add(this.pushOutputFileAction);
        }
        this.transformExtraOutFileAction();
    }

    private void transformExtraOutFileAction() {
        try {
            if (this.extraOutputFileActions == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject(this.extraOutputFileActions);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                JSONObject jSONObject2 = jSONObject.getJSONObject(string);
                OutputFileAction outputFileAction = (OutputFileAction)Class.forName(string).newInstance();
                if (this.contains(outputFileAction = outputFileAction.analyzeJSON(jSONObject2))) continue;
                this.add(outputFileAction);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public EmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(EmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    public FTPTransmission getFtpTransmission() {
        return this.ftpTransmission;
    }

    public void setFtpTransmission(FTPTransmission fTPTransmission) {
        this.ftpTransmission = fTPTransmission;
    }

    public PrintRWorkbookAction getPrintRWorkbookAction() {
        return this.printRWorkbookAction;
    }

    public void setPrintRWorkbookAction(PrintRWorkbookAction printRWorkbookAction) {
        this.printRWorkbookAction = printRWorkbookAction;
    }

    public ClassOutputFileAction getClassOutputFileAction() {
        return this.classOutputFileAction;
    }

    public void setClassOutputFileAction(ClassOutputFileAction classOutputFileAction) {
        this.classOutputFileAction = classOutputFileAction;
    }

    public PushOutputFileAction getPushOutputFileAction() {
        return this.pushOutputFileAction;
    }

    public void setPushOutputFileAction(PushOutputFileAction pushOutputFileAction) {
        this.pushOutputFileAction = pushOutputFileAction;
    }

    public String getExtraOutputFileActions() {
        return this.extraOutputFileActions;
    }

    public void setExtraOutputFileActions(String string) {
        this.extraOutputFileActions = string;
        this.transformExtraOutFileAction();
    }

    public void resetPushOutputFileAction() {
        this.pushOutputFileAction = null;
    }
}

