/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile;

import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.cluster.rpc.RPC;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.mobile.FMobileConfigProvider;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;

public class FMobileConfig
extends XMLFileManager
implements FMobileConfigProvider {
    private static final String XML_TAG = "fmobileconfig";
    private static FMobileConfigProvider MC = null;
    private String qrcodeImageID4FS;
    private String qrcodeServerName;
    private String qrcodeServerUrl;
    private String phoneLaunchImageID;
    private String padLaunchImageID;
    private static HashMap<String, String> usersCIDMaps = new HashMap();

    public static FMobileConfig getInstance() {
        return (FMobileConfig)FMobileConfig.getProviderInstance();
    }

    public static FMobileConfigProvider getProviderInstance() {
        if (MC != null) {
            return MC;
        }
        FMobileConfig.refreshFMobileConfig();
        return MC;
    }

    public String fileName() {
        return "fmobileconfig.xml";
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writeQRCodeImageXML(xMLPrintWriter);
        this.writePhoneLaunchImageXML(xMLPrintWriter);
        this.writePadLaunchImageXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.readAttr(xMLableReader);
        }
        if (xMLableReader.isChildNode()) {
            this.readChild(xMLableReader);
        }
    }

    public String getQrcodeImageID4FS() {
        return this.qrcodeImageID4FS;
    }

    public void setQrcodeImageID4FS(String string) {
        this.qrcodeImageID4FS = string;
    }

    public String getQrcodeServerName() {
        return this.qrcodeServerName;
    }

    public void setQrcodeServerName(String string) {
        this.qrcodeServerName = string;
    }

    public String getQrcodeServerUrl() {
        return this.qrcodeServerUrl;
    }

    public void setQrcodeServerUrl(String string) {
        this.qrcodeServerUrl = string;
    }

    public String getPhoneLaunchImageID() {
        return this.phoneLaunchImageID;
    }

    public void setPhoneLaunchImageID(String string) {
        this.phoneLaunchImageID = string;
    }

    public String getPadLaunchImageID() {
        return this.padLaunchImageID;
    }

    public void setPadLaunchImageID(String string) {
        this.padLaunchImageID = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFMobileConfig() {
        Class<FMobileConfig> clazz = FMobileConfig.class;
        synchronized (FMobileConfig.class) {
            switch (BaseClusterHelper.getClusterState()) {
                case LEADER: {
                    MC = new FMobileConfig();
                    RPC.registerSkeleton((Object)MC);
                    break;
                }
                case MEMBER: {
                    String string = BaseClusterHelper.getMainServiceIP();
                    MC = (FMobileConfigProvider)RPC.getProxy(FMobileConfig.class, (String)string);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                default: {
                    MC = new FMobileConfig();
                }
            }
            MC.readXMLFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void readAttr(XMLableReader xMLableReader) {
    }

    private void readChild(XMLableReader xMLableReader) {
        String string;
        String string2 = xMLableReader.getTagName();
        if (ComparatorUtils.equals((String)"qrcodeImage", (String)string2)) {
            String string3 = xMLableReader.getAttrAsString("id", null);
            String string4 = xMLableReader.getAttrAsString("name", null);
            String string5 = xMLableReader.getAttrAsString("url", null);
            if (StringUtils.isNotBlank((String)string3)) {
                this.setQrcodeServerName(string4);
                this.setQrcodeServerUrl(string5);
                string3 = this.readImageXML(xMLableReader);
                this.setQrcodeImageID4FS(string3);
            }
        } else if (ComparatorUtils.equals((String)"phoneLaunchImage", (String)string2)) {
            String string6 = xMLableReader.getAttrAsString("id", null);
            if (StringUtils.isNotBlank((String)string6)) {
                string6 = this.readImageXML(xMLableReader);
                this.setPhoneLaunchImageID(string6);
            }
        } else if (ComparatorUtils.equals((String)"padLaunchImage", (String)string2) && StringUtils.isNotBlank((String)(string = xMLableReader.getAttrAsString("id", null)))) {
            string = this.readImageXML(xMLableReader);
            this.setPadLaunchImageID(string);
        }
    }

    private String readImageXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("id", null);
        byte[] byArray = GeneralXMLTools.readByteArray((XMLableReader)xMLableReader);
        if (StringUtils.isNotBlank((String)string) && byArray != null) {
            AttachmentSource.putAttachment((String)string, (Attachment)new Attachment(string, "image", string, byArray));
        }
        return string;
    }

    private void writeQRCodeImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank((String)this.getQrcodeImageID4FS())) {
            xMLPrintWriter.startTAG("qrcodeImage");
            xMLPrintWriter.attr("id", this.getQrcodeImageID4FS()).attr("name", this.getQrcodeServerName()).attr("url", this.getQrcodeServerUrl());
            GeneralXMLTools.writeByteArray((XMLPrintWriter)xMLPrintWriter, (byte[])AttachmentSource.getAttachment((String)this.getQrcodeImageID4FS()).getBytes());
            xMLPrintWriter.end();
        }
    }

    private void writePhoneLaunchImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank((String)this.getPhoneLaunchImageID())) {
            xMLPrintWriter.startTAG("phoneLaunchImage");
            xMLPrintWriter.attr("id", this.getPhoneLaunchImageID());
            Attachment attachment = AttachmentCacheManager.getAttachment((String)this.getPhoneLaunchImageID());
            if (attachment != null) {
                GeneralXMLTools.writeByteArray((XMLPrintWriter)xMLPrintWriter, (byte[])attachment.getBytes());
            }
            xMLPrintWriter.end();
        }
    }

    private void writePadLaunchImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank((String)this.getPadLaunchImageID())) {
            xMLPrintWriter.startTAG("padLaunchImage");
            xMLPrintWriter.attr("id", this.getPadLaunchImageID());
            Attachment attachment = AttachmentCacheManager.getAttachment((String)this.getPadLaunchImageID());
            if (attachment != null) {
                GeneralXMLTools.writeByteArray((XMLPrintWriter)xMLPrintWriter, (byte[])attachment.getBytes());
            }
            xMLPrintWriter.end();
        }
    }

    public static void addUsersCID(String string, String string2) {
        if (usersCIDMaps == null) {
            usersCIDMaps = new HashMap();
        }
        usersCIDMaps.put(string, string2);
    }

    public static String getUserCID(String string) {
        return usersCIDMaps == null ? "" : usersCIDMaps.get(string);
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FMobileConfig.getProviderInstance());
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                MC = null;
            }
        });
    }
}

