/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.control.UserControl;
import com.fr.fs.process.FSBackupFolderType;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServerConfigBackupFileFilter;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigManualBackupAction
extends ActionNoSessionCMD {
    private static final String FRCONFIG_BAK = "frbak";
    private static final String MANUAL_BACKUP = "manualbackup";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        String string = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), FRCONFIG_BAK});
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"optype");
        if (ComparatorUtils.equals((String)string2, (String)"back_up")) {
            String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"entryName");
            String string4 = StableUtils.pathJoin((String[])new String[]{string, MANUAL_BACKUP, string3});
            if (!FSBackupFolderType.backupServerProjectFiles(string4)) {
                FRLogger.getLogger().error("manual back up failed.");
            }
        } else if (ComparatorUtils.equals((String)string2, (String)"edit_backup")) {
            String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"oldname");
            String string6 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"newname");
            File file = new File(StableUtils.pathJoin((String[])new String[]{string, MANUAL_BACKUP, string5}));
            File file2 = new File(StableUtils.pathJoin((String[])new String[]{string, MANUAL_BACKUP, string6}));
            if (!file.renameTo(file2)) {
                FRLogger.getLogger().error("rename backup error.");
            }
        } else if (ComparatorUtils.equals((String)string2, (String)"list_backup")) {
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            String[] stringArray = ServerConfigBackupFileFilter.listFilteredFiles(string, MANUAL_BACKUP);
            JSONArray jSONArray = new JSONArray();
            for (String string7 : stringArray) {
                jSONArray.put((Object)this.createJSONConfig(string7));
            }
            printWriter.print(jSONArray.toString());
            printWriter.flush();
            printWriter.close();
        } else {
            FRLogger.getLogger().error("error manual_backup operation type!");
        }
    }

    private boolean backupServerConfigFiles(String string, String string2, String string3, String string4, String[] stringArray) {
        String string5 = StableUtils.pathJoin((String[])new String[]{string4, MANUAL_BACKUP, string});
        try {
            for (String string6 : stringArray) {
                IOUtils.copy((File)new File(StableUtils.pathJoin((String[])new String[]{string2, string6})), (File)new File(StableUtils.pathJoin((String[])new String[]{string5, "finedb"})));
            }
            this.copy(new File(string3), new File(string5));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
            return false;
        }
        Object[] objectArray = new File(string5).listFiles();
        return ArrayUtils.getLength((Object)objectArray) > 0;
    }

    private File[] getFileFilter(File file) {
        return file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
    }

    private void copy(File file, File file2) throws IOException {
        File file3;
        if (file.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(file), (String)file.getName(), (File)file2);
        } else if (file.isDirectory() && file.getName().endsWith("resources") && StableUtils.mkdirs((File)(file3 = new File(file2, file.getName())))) {
            File[] fileArray = this.getFileFilter(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.copy(fileArray[i], file3);
            }
        }
    }

    private JSONObject createJSONConfig(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("manualbackupname", (Object)string);
        return jSONObject;
    }

    public String getCMD() {
        return "manual_backup";
    }
}

