/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.basic.AutoBackupTimerAttr;
import com.fr.fs.control.UserControl;
import com.fr.fs.process.FSConfigBackupRestoreProcessPlate;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServerConfigBackupFileFilter;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigAutoBackupAction
extends ActionNoSessionCMD {
    private static final String FRCONFIG_BAK = "frbak";
    private static final String AUTO_BACKUP = "autobackup";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        String string = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "finedb"});
        String string2 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "resources"});
        String string3 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), FRCONFIG_BAK});
        AutoBackupTimerAttr autoBackupTimerAttr = FSConfig.getProviderInstance().getAutoBackupTimerAttr();
        String string4 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"optype");
        if (ComparatorUtils.equals((String)string4, (String)"getinfo_backup")) {
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            JSONObject jSONObject = this.createJSONConfigInfo(autoBackupTimerAttr.isAutoBackupStart(), autoBackupTimerAttr.getAutoBackupFrequency(), autoBackupTimerAttr.getAutoBackupTaskName());
            printWriter.print(jSONObject);
            printWriter.flush();
            printWriter.close();
        } else if (ComparatorUtils.equals((String)string4, (String)"update_backup")) {
            String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"isStart");
            String string6 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"backup_frequency");
            FSConfigBackupRestoreProcessPlate.updateTimer(Boolean.parseBoolean(string5), Long.parseLong(string6));
        } else if (ComparatorUtils.equals((String)string4, (String)"list_backup")) {
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            String[] stringArray = ServerConfigBackupFileFilter.listFilteredFiles(string3, AUTO_BACKUP);
            JSONArray jSONArray = new JSONArray();
            for (String string7 : stringArray) {
                jSONArray.put((Object)this.createJSONConfig(string7));
            }
            printWriter.print(jSONArray.toString());
            printWriter.flush();
            printWriter.close();
        } else {
            FRLogger.getLogger().error("error auto_backup operation type.");
        }
    }

    private JSONObject createJSONConfig(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("autobackupname", (Object)string);
        return jSONObject;
    }

    private JSONObject createJSONConfigInfo(boolean bl, long l, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isStart", bl);
        jSONObject.put("backup_frequency", l);
        jSONObject.put("timerName", (Object)string);
        return jSONObject;
    }

    public String getCMD() {
        return "auto_backup";
    }
}

