/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.fun.PlatformDBCacheProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetSpecialDepartAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "auth_getspecialdepart";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L)) {
            throw new NoPrivilegeException();
        }
        this.extraReInit();
        JSONArray jSONArray = !FSConfig.getProviderInstance().getAuthorizeAttr().isGradeAuthority() ? DepartmentControl.getInstance().getAllDepartmentInfo(false) : DepartmentControl.getInstance().getDepartmentInfoPrivilege(l, false);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"searchKeyword");
        if (StringUtils.isNotEmpty((String)string)) {
            int n = Math.max(string.lastIndexOf(","), string.lastIndexOf("\uff0c"));
            string = string.substring(n + 1);
            this.filterEntryNode(jSONArray, string);
        }
        printWriter.print(jSONArray.toString());
        printWriter.flush();
        printWriter.close();
    }

    private void extraReInit() {
        PlatformDBCacheProcessor platformDBCacheProcessor = (PlatformDBCacheProcessor)ExtraPlatformClassManager.getInstance().getSingle("PlatformDBCacheProcessor");
        if (platformDBCacheProcessor != null) {
            platformDBCacheProcessor.reinitDepartmentCache();
        }
    }

    private void filterEntryNode(JSONArray jSONArray, String string) throws Exception {
        int n = 0;
        while (n < jSONArray.length()) {
            JSONObject jSONObject = jSONArray.getJSONObject(n);
            boolean bl = false;
            boolean bl2 = false;
            if (null != jSONObject.optJSONArray("ChildNodes")) {
                bl2 = true;
            }
            jSONObject.put("isexpand", true);
            if (this.isKeywordInEntryInfo(jSONObject.optString("text"), string)) {
                bl = true;
                ++n;
            }
            if (!bl2 && !bl) {
                jSONArray.remove(n);
                continue;
            }
            if (!bl2 || bl) continue;
            this.filterEntryNode(jSONObject.getJSONArray("ChildNodes"), string);
            if (jSONObject.getJSONArray("ChildNodes").length() == 0) {
                jSONArray.remove(n);
                continue;
            }
            ++n;
        }
    }

    private boolean isKeywordInEntryInfo(String string, String string2) {
        return string.toUpperCase().contains(string2.toUpperCase());
    }
}

