/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleBean;
import com.fr.fs.cache.DepartmentCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetAllCompanyRoleAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        JSONArray jSONArray;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        ArrayList<CompanyRole> arrayList = new ArrayList();
        if (FSConfig.getProviderInstance().getAuthorizeAttr().isGradeAuthority()) {
            jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l);
            n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                if (!jSONObject.has("departmentid")) continue;
                long l2 = jSONObject.getLong("id");
                CompanyRole companyRole = CompanyRoleControl.getInstance().getJRole(l2);
                arrayList.add(companyRole);
            }
        } else {
            arrayList = CompanyRoleControl.getInstance().getAllCompanyRole();
        }
        Collections.sort(arrayList, RoleBean.RoleSORTComparator.getInstance());
        jSONArray = new JSONArray();
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"searchKeyword");
        if (StringUtils.isEmpty((String)string)) {
            this.getAllCompanyRole(arrayList, jSONArray);
        } else {
            n = Math.max(string.lastIndexOf(","), string.lastIndexOf("\uff0c"));
            string = string.substring(n + 1);
            this.getAllFilterCompanyRole(arrayList, jSONArray, string);
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getcompanyrole";
    }

    public void getAllCompanyRole(List<CompanyRole> list, JSONArray jSONArray) throws Exception {
        for (CompanyRole companyRole : list) {
            Department department = DepartmentCacheImpl.getInstance().getDepartment(companyRole.getDepartmentId());
            Post post = PostControl.getInstance().getPost(companyRole.getPostId());
            if (department == null || post == null || post.getId() == CompanyRoleControl.getInstance().getPostAllID() || department.getId() == CompanyRoleControl.getInstance().getDepartmentAllID()) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentName", (Object)department.getName());
            jSONObject.put("postName", (Object)post.getPostname());
            jSONObject.put("departmentId", (Object)(department.getId() + ""));
            jSONObject.put("departmentPId", (Object)(department.getPid() + ""));
            jSONObject.put("postId", (Object)(post.getId() + ""));
            jSONArray.put((Object)jSONObject);
            while (department.getPid() > 0L && (department = DepartmentCacheImpl.getInstance().getDepartment(department.getPid())) != null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("departmentName", (Object)department.getName());
                jSONObject2.put("departmentId", (Object)(department.getId() + ""));
                jSONObject2.put("departmentPId", (Object)(department.getPid() + ""));
                jSONArray.put((Object)jSONObject2);
            }
        }
    }

    private void getAllFilterCompanyRole(List<CompanyRole> list, JSONArray jSONArray, String string) throws Exception {
        for (CompanyRole companyRole : list) {
            Department department = DepartmentCacheImpl.getInstance().getDepartment(companyRole.getDepartmentId());
            Post post = PostControl.getInstance().getPost(companyRole.getPostId());
            if (department == null || post == null || post.getId() == CompanyRoleControl.getInstance().getPostAllID() || department.getId() == CompanyRoleControl.getInstance().getDepartmentAllID() || !this.isKeywordInParentNode(department, string) && !this.isKeywordInCompanyRoleInfo(department.getName(), post.getPostname(), string)) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentName", (Object)department.getName());
            jSONObject.put("postName", (Object)post.getPostname());
            jSONObject.put("departmentId", (Object)(department.getId() + ""));
            jSONObject.put("departmentPId", (Object)(department.getPid() + ""));
            jSONObject.put("postId", (Object)(post.getId() + ""));
            jSONArray.put((Object)jSONObject);
            while (department.getPid() > 0L && (department = DepartmentCacheImpl.getInstance().getDepartment(department.getPid())) != null) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("departmentName", (Object)department.getName());
                jSONObject2.put("departmentId", (Object)(department.getId() + ""));
                jSONObject2.put("departmentPId", (Object)(department.getPid() + ""));
                jSONArray.put((Object)jSONObject2);
            }
        }
    }

    private boolean isKeywordInCompanyRoleInfo(String string, String string2, String string3) {
        return string.toUpperCase().contains(string3.toUpperCase()) || string2.toUpperCase().contains(string3.toUpperCase());
    }

    private boolean isKeywordInParentNode(Department department, String string) {
        while (department.getPid() > 0L && (department = DepartmentCacheImpl.getInstance().getDepartment(department.getPid())) != null) {
            if (!this.isKeywordInCompanyRoleInfo(department.getName(), "", string)) continue;
            return true;
        }
        return false;
    }
}

