/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSManagerBlurImageAction
extends ActionNoSessionCMD {
    private static int STARTY = 60;
    private static int radius = 77;
    private static int RGBOFFSET_24 = 24;
    private static int RGBOFFSET_16 = 16;
    private static int RGBOFFSET_8 = 8;
    private static int RGBBYTE = 255;
    private static double INTIN = 0.5;

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 14L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"attachId");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"type");
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        Attachment attachment = AttachmentCacheManager.getAttachment((String)string);
        if (attachment != null) {
            object = attachment.getBytes();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                BufferedImage bufferedImage2 = this.doGaussianBlur(bufferedImage);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage2, string2, byteArrayOutputStream);
                Attachment attachment2 = new Attachment(string, string2, attachment.getFilename(), byteArrayOutputStream.toByteArray(), attachment.getWidth(), attachment.getHeight());
                AttachmentSource.putAttachment((String)string, (Attachment)attachment2);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Fail to blur background image!");
            }
        }
        object = new JSONObject();
        object.put("complete", true);
        printWriter.print(object);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "blur_image";
    }

    private BufferedImage doGaussianBlur(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        Kernel kernel = this.makeKernel(radius);
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        this.convolveAndTranspose(kernel, nArray, nArray2, n, n2, false);
        this.convolveAndTranspose(kernel, nArray2, nArray, n2, n, true);
        bufferedImage2.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage2;
    }

    private Kernel makeKernel(float f) {
        int n;
        int n2 = (int)Math.ceil(f);
        int n3 = n2 * 2 + 1;
        float[] fArray = new float[n3];
        float f2 = f / 3.0f;
        float f3 = 2.0f * f2 * f2;
        float f4 = (float)(Math.PI * 2 * (double)f2);
        float f5 = (float)Math.sqrt(f4);
        float f6 = f * f;
        float f7 = 0.0f;
        int n4 = 0;
        for (n = -n2; n <= n2; ++n) {
            float f8 = n * n;
            fArray[n4] = f8 > f6 ? 0.0f : (float)Math.exp(-f8 / f3) / f5;
            f7 += fArray[n4];
            ++n4;
        }
        n = 0;
        while (n < n3) {
            int n5 = n++;
            fArray[n5] = fArray[n5] / f7;
        }
        return new Kernel(n3, 1, fArray);
    }

    private void convolveAndTranspose(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2, boolean bl) {
        float[] fArray = kernel.getKernelData(null);
        int n3 = kernel.getWidth();
        int n4 = n3 / 2;
        int n5 = 0;
        if (bl) {
            n5 = STARTY;
        }
        for (int i = 0; i < n2; ++i) {
            int n6 = i;
            int n7 = i * n;
            for (int j = 0; j < n; ++j) {
                int n8;
                int n9;
                int n10;
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int n11 = n4;
                for (n10 = -n4; n10 <= n4; ++n10) {
                    float f5 = fArray[n11 + n10];
                    if (f5 == 0.0f) continue;
                    n9 = j + n10;
                    if (n9 < 0) {
                        n9 = 0;
                    } else if (n9 >= n) {
                        n9 = n - 1;
                    }
                    n8 = nArray[n7 + n9];
                    f4 += f5 * (float)(n8 >> RGBOFFSET_24 & RGBBYTE);
                    f += f5 * (float)(n8 >> RGBOFFSET_16 & RGBBYTE);
                    f2 += f5 * (float)(n8 >> RGBOFFSET_8 & RGBBYTE);
                    f3 += f5 * (float)(n8 & RGBBYTE);
                }
                n10 = this.clamp((int)((double)f4 + INTIN));
                int n12 = this.clamp((int)((double)f + INTIN));
                n9 = this.clamp((int)((double)f2 + INTIN));
                n8 = this.clamp((int)((double)f3 + INTIN));
                if (j > n5) {
                    nArray2[n6] = n10 << RGBOFFSET_24 | n12 << RGBOFFSET_16 | n9 << RGBOFFSET_8 | n8;
                }
                n6 += n2;
            }
        }
    }

    private int clamp(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }
}

