/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.systemmonitor.service;

import com.fr.base.ParameterMapNameSpace;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.fs.control.UserControl;
import com.fr.fs.systemmonitor.data.FunctionProcessDBTableData;
import com.fr.fs.systemmonitor.data.FunctionRecordLocaleKeyTableData;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.data.DataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.record.DialectType;
import com.fr.script.Calculator;
import com.fr.stable.script.NameSpace;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSManagerModuleGetFuncProcessAction
extends ActionNoSessionCMD {
    private JSONArray jaUsing;
    private JSONArray jaUnused;

    public String getCMD() {
        return "get_functions_process";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 9L)) {
            throw new NoPrivilegeException();
        }
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            Dialect dialect = DialectFactory.generateDialect((Connection)connection);
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            DialectType dialectType = DialectType.parseTypeByDialect((Dialect)dialect);
            FunctionProcessDBTableData functionProcessDBTableData = new FunctionProcessDBTableData(dialectType);
            HashMap hashMap = new HashMap();
            ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace((NameSpace)parameterMapNameSpace);
            DataModel dataModel = functionProcessDBTableData.createDataModel(calculator);
            JSONObject jSONObject = new JSONObject();
            this.jaUsing = new JSONArray();
            this.jaUnused = new JSONArray();
            this.getInfos(dataModel);
            jSONObject.put("usingFuncs", (Object)this.jaUsing);
            jSONObject.put("unusedFuncs", (Object)this.jaUnused);
            printWriter.print(jSONObject.toString());
            printWriter.flush();
            printWriter.close();
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    private void getInfos(DataModel dataModel) throws Exception {
        String string;
        int n;
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        FunctionRecordLocaleKeyTableData functionRecordLocaleKeyTableData = new FunctionRecordLocaleKeyTableData();
        int n2 = dataModel.getRowCount();
        for (n = 0; n < n2; ++n) {
            string = String.valueOf(dataModel.getValueAt(n, 0));
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                arrayList.add(String.valueOf(iterator.next()));
            }
        }
        for (n = 0; n < functionRecordLocaleKeyTableData.getRowCount(); ++n) {
            String string2 = String.valueOf(functionRecordLocaleKeyTableData.getValueAt(n, 0));
            string = new JSONObject();
            string.put("funcName", (Object)String.valueOf(functionRecordLocaleKeyTableData.getValueAt(n, 1)));
            if (arrayList.contains(string2)) {
                this.jaUsing.put((Object)string);
                continue;
            }
            this.jaUnused.put((Object)string);
        }
    }
}

