/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.third.org.quartz.SimpleTrigger;
import com.fr.third.org.quartz.Trigger;
import java.text.ParseException;
import java.util.Date;

public class SimpleITrigger
extends ITrigger {
    public static final String TABLE_NAME = "fr_simple_itrigger";
    public static final int TYPE = 2;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    public static final int WEEKS = 4;
    public static final String NAME = "simple";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(SimpleITrigger.class, new Table("fr_simple_itrigger"), (FieldColumnMapper[])ArrayUtils.addAll((Object[])ITrigger.ITRIGGER_FIELDMAPPER, (Object[])new FieldColumnMapper[]{new CommonFieldColumnMapper("repeatCount", 4, "repeat_count", new ColumnSize(5), true), ITrigger.EndTimeFieldMapper, new CommonFieldColumnMapper("recurrenceInterval", 4, "recurrence_interval", new ColumnSize(10), true), new CommonFieldColumnMapper("recurrenceIntervalUnit", 4, "recurrence_interval_unit", new ColumnSize(10), true)}));
    private static final long serialVersionUID = 1L;
    private long repeatCount = -1L;
    private long recurrenceInterval = 1L;
    private long recurrenceIntervalUnit = 3L;
    private int timesteps = 60;
    private int hoursteps = 24;
    private int weeksteps = 7;
    private int thousand = 1000;

    public ITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            Date date;
            SimpleITrigger simpleITrigger = new SimpleITrigger();
            long l = jSONObject.getLong("startType");
            simpleITrigger.setStartType(l);
            if (l == 2L) {
                String string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    simpleITrigger.setStartTime(date);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
                }
            }
            if (jSONObject.has("repeatCount")) {
                long l2 = jSONObject.getLong("repeatCount");
                simpleITrigger.setRepeatCount(l2);
            }
            if (jSONObject.has("endTime")) {
                String string = jSONObject.getString("endTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    simpleITrigger.setEndTime(date);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
                }
            }
            long l3 = jSONObject.getLong("recurrenceInterval");
            simpleITrigger.setRecurrenceInterval(l3);
            long l4 = jSONObject.getLong("recurrenceIntervalUnit");
            simpleITrigger.setRecurrenceIntervalUnit(l4);
            if (jSONObject.has("id")) {
                simpleITrigger.setId(jSONObject.optLong("id"));
            }
            return simpleITrigger;
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            return null;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("recurrenceType", (Object)NAME);
        if (this.getEndTime() == null) {
            jSONObject.put("repeatCount", this.getRepeatCount());
        } else {
            Date date = this.getEndTime();
            String string = DateUtils.DATETIMEFORMAT2.format(date);
            jSONObject.put("endTime", (Object)string);
        }
        jSONObject.put("recurrenceInterval", this.getRecurrenceInterval());
        jSONObject.put("recurrenceIntervalUnit", this.getRecurrenceIntervalUnit());
        return jSONObject;
    }

    public Trigger createTrigger() {
        SimpleTrigger simpleTrigger = new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                simpleTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("The statemenet is illegal.");
            }
        }
        if (this.getRepeatCount() > -2L) {
            simpleTrigger.setRepeatCount((int)this.getRepeatCount());
        }
        if (this.getEndTime() != null) {
            simpleTrigger.setEndTime(this.getEndTime());
        }
        long l = 0L;
        switch ((int)this.getRecurrenceIntervalUnit()) {
            case 1: {
                l = this.getRecurrenceInterval() * (long)this.timesteps * (long)this.thousand;
                break;
            }
            case 2: {
                l = this.getRecurrenceInterval() * (long)this.timesteps * (long)this.timesteps * (long)this.thousand;
                break;
            }
            case 3: {
                l = this.getRecurrenceInterval() * (long)this.hoursteps * (long)this.timesteps * (long)this.timesteps * (long)this.thousand;
                break;
            }
            case 4: {
                l = this.getRecurrenceInterval() * (long)this.weeksteps * (long)this.hoursteps * (long)this.timesteps * (long)this.timesteps * (long)this.thousand;
            }
        }
        simpleTrigger.setRepeatInterval(l);
        simpleTrigger.setMisfireInstruction(5);
        return simpleTrigger;
    }

    public int getITriggerIdPrefix() {
        return 2;
    }

    public void setRepeatCount(long l) {
        this.repeatCount = l;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public void setRecurrenceInterval(long l) {
        this.recurrenceInterval = l;
    }

    public long getRecurrenceInterval() {
        return this.recurrenceInterval;
    }

    public void setRecurrenceIntervalUnit(long l) {
        this.recurrenceIntervalUnit = l;
    }

    public long getRecurrenceIntervalUnit() {
        return this.recurrenceIntervalUnit;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleITrigger)) {
            return false;
        }
        SimpleITrigger simpleITrigger = (SimpleITrigger)object;
        return this.getRepeatCount() == simpleITrigger.getRepeatCount() && ComparatorUtils.equals((Object)this.getEndTime(), (Object)simpleITrigger.getEndTime()) && this.getRecurrenceInterval() == simpleITrigger.getRecurrenceInterval() && this.getRecurrenceIntervalUnit() == simpleITrigger.getRecurrenceIntervalUnit();
    }
}

