/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.third.org.quartz.SimpleTrigger;
import com.fr.third.org.quartz.Trigger;
import java.text.ParseException;
import java.util.Date;

public class OnceITrigger
extends ITrigger {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "fr_once_itrigger";
    public static final int TYPE = 1;
    public static final String NAME = "once";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(OnceITrigger.class, new Table("fr_once_itrigger"), ITrigger.ITRIGGER_FIELDMAPPER);

    public ITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            OnceITrigger onceITrigger = null;
            long l = jSONObject.getLong("startType");
            Date date = null;
            if (l == 2L) {
                String string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
                }
            }
            onceITrigger = new OnceITrigger();
            onceITrigger.setStartType(l);
            onceITrigger.setStartTime(date);
            if (jSONObject.has("id")) {
                onceITrigger.setId(jSONObject.optLong("id"));
            }
            return onceITrigger;
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            return null;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("recurrenceType", (Object)NAME);
        return jSONObject;
    }

    public Trigger createTrigger() {
        if (this.getStartType() == 1L) {
            return new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        }
        if (this.getStartType() == 2L && this.getStartTime() != null) {
            return new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs", this.getStartTime());
        }
        throw new IllegalStateException("The statemenet is illegal.");
    }

    public int getITriggerIdPrefix() {
        return 1;
    }
}

