/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.data.TableDataSource;
import com.fr.fs.schedule.job.ReportletJob;
import com.fr.general.Inter;
import com.fr.io.TemplateWorkBookIO;
import com.fr.log.LogUtils;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.report.ReportHelper;
import com.fr.report.report.WriteECReport;
import com.fr.report.stable.fun.Actor;
import com.fr.report.worksheet.WorkSheet;
import com.fr.report.write.ReportWriteAttr;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class WriteReportletJob
extends ReportletJob {
    protected void executeReport() {
        this.record_list = new ArrayList();
        this.arrayParaList = new ArrayList();
        this.reportlet = ReportHelper.generateReportlet((String)this.reportPath);
        ScheduleUtils.calculatorParameters(this.getExecuteParameter(), this.record_list, this.arrayParaList);
        try {
            TemplateWorkBook templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook((Env)FRContext.getCurrentEnv(), (String)this.reportPath);
            File file = new File(StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", this.reportPath}));
            if (!file.exists()) {
                this.log.error("[Schedule] WriteReportletJob . Not found reportlet: " + this.reportPath);
                return;
            }
            int n = this.record_list.size();
            for (int i = 0; i < n; ++i) {
                WriteWorkBook writeWorkBook;
                Map map = (Map)this.record_list.get(i);
                if (!this.checkExecuteFormula(map, (ResultWorkBook)(writeWorkBook = (WriteWorkBook)LogUtils.executeAndLogRecord((TemplateWorkBook)templateWorkBook, (String)this.reportPath, (Map)map, (Actor)ActorFactory.getActor((String)"write"))))) {
                    return;
                }
                this.writeReportData(writeWorkBook, templateWorkBook, Collections.EMPTY_MAP);
                String string = Inter.getLocText((String)"FS-Schedule-Reporting_Action");
                string = string + ":" + Inter.getLocText((String)"FS-Generic-Simple_Successfully");
                if (this.scheduleTask.getCounts() > 0) {
                    string = string + ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts());
                }
                this.log.scheduleInfo(this.scheduleTask.getName(), string);
            }
        }
        catch (Exception exception) {
            this.dealWithException(exception);
        }
        this.log.info("[Schedule] WriteJob complete successfully.");
    }

    public void logReportPathError() {
        this.log.error("[Schedule] WriteReportletJob : Reporlet path is null.");
    }

    public void logTipInfo() {
        this.log.info("[Schedule] Start to write. ReportPath :" + this.reportPath);
    }

    private void writeReportData(WriteWorkBook writeWorkBook, TemplateWorkBook templateWorkBook, Map map) throws Exception {
        int n = templateWorkBook.getReportCount();
        for (int i = 0; i < n; ++i) {
            this.writeInnerReportData(writeWorkBook.getWriteReport(i), (WorkSheet)templateWorkBook.getTemplateReport(i), map);
        }
    }

    private void writeInnerReportData(WriteECReport writeECReport, WorkSheet workSheet, Map map) throws Exception {
        ReportWriteAttr reportWriteAttr = (ReportWriteAttr)workSheet.getAttributeTarget("ReportWriteAttr");
        if (reportWriteAttr == null) {
            return;
        }
        reportWriteAttr.submit(writeECReport, (TableDataSource)workSheet.getTemplateWorkBook(), map);
    }
}

