/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.io.TemplateWorkBookIO;
import com.fr.main.TemplateWorkBook;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.FTPException;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DoFileActionJob
implements Job {
    private static int MINUTES = 60000;
    private static int RANDOM_RANGE = 10000;
    private static FRLogger log = FRLogger.getLogger();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        ScheduleTask scheduleTask = (ScheduleTask)jobDataMap.get((Object)"__restarttask__");
        List list = (List)jobDataMap.get((Object)"__attachlist__");
        DoFileActionJob.doFileAction(scheduleTask, list);
    }

    public static void doFileAction(ScheduleTask scheduleTask, List list) {
        ScheduledOutput scheduledOutput = scheduleTask.getScheduledOutput();
        if (scheduledOutput.getOutputFileActionList() == null || scheduledOutput.getOutputFileActionList().size() == 0) {
            scheduledOutput.synFileActionList();
        }
        ArrayList arrayList = scheduledOutput.getOutputFileActionList() == null ? new ArrayList() : scheduledOutput.getOutputFileActionList();
        boolean bl = false;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            OutputFileAction outputFileAction = (OutputFileAction)arrayList.get(i);
            if (outputFileAction == null) continue;
            File[] fileArray = outputFileAction.getFilesToDealWith(list.toArray(new File[list.size()]));
            try {
                outputFileAction.doFileAction(fileArray);
                DoFileActionJob.recordSuccess(scheduleTask, null);
                continue;
            }
            catch (Exception exception) {
                bl = true;
                DoFileActionJob.recordError(scheduleTask, exception, list, null);
            }
        }
        if (bl) {
            ScheduleTask scheduleTask2 = null;
            try {
                scheduleTask2 = scheduleTask.clone4Exe();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                log.error(cloneNotSupportedException.getMessage());
            }
            scheduleTask2.setCounts(scheduleTask2.getCounts() + 1);
            if (scheduleTask2.getCounts() > Integer.parseInt(scheduleTask2.getRepeatTimes()) || Integer.parseInt(scheduleTask2.getRepeatTimes()) == 0) {
                return;
            }
            DoFileActionJob.scheduleFileRestartTask(scheduleTask2, list);
        } else {
            scheduleTask.setCounts(0);
        }
    }

    private static Parameter[] getTaskTplParameters(ScheduleTask scheduleTask) {
        Object[] objectArray = scheduleTask.getParametersToArray();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            String string = scheduleTask.getReportletPath();
            TemplateWorkBook templateWorkBook = null;
            try {
                templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook((Env)FRContext.getCurrentEnv(), (String)string);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            objectArray = templateWorkBook.getParameters();
        }
        return objectArray;
    }

    public static void recordError(ScheduleTask scheduleTask, Exception exception, List list, String string) {
        String string2 = Inter.getLocText((String[])new String[]{"FS-Generic-Attach_File", "FS-Generic-Simple_Send"});
        string2 = string2 + ":" + Inter.getLocText((String)"FS-Generic-Simple_Failed");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        if (exception instanceof EmailException) {
            log.scheduleError(scheduleTask.getName(), string2, (Throwable)exception, Inter.getLocText((String[])new String[]{"FS-Generic-Simple_Mail", "FS-Generic-HJS_Send_Failed"}));
        } else if (exception instanceof FTPException) {
            log.scheduleError(scheduleTask.getName(), string2, (Throwable)exception, "FTP" + Inter.getLocText((String[])new String[]{"FS-Generic-Simple_Upload", "FS-Generic-Simple_Failed"}));
        } else {
            log.scheduleError(scheduleTask.getName(), string2, (Throwable)exception);
        }
    }

    public static void recordSuccess(ScheduleTask scheduleTask, String string) {
        String string2 = Inter.getLocText((String[])new String[]{"FS-Generic-Attach_File", "FS-Generic-Simple_Send"});
        string2 = string2 + ":" + Inter.getLocText((String)"FS-Generic-Simple_Successfully");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        log.scheduleInfo(scheduleTask.getName(), string2);
    }

    public static void scheduleFileRestartTask(ScheduleTask scheduleTask, List list) {
        int n = Integer.parseInt(scheduleTask.getRepeatTime()) * MINUTES;
        OnceITrigger onceITrigger = new OnceITrigger();
        onceITrigger.setStartType(2L);
        onceITrigger.setId(scheduleTask.getITrigger().getId());
        onceITrigger.setStartTime(new Date(new Date().getTime() + (long)n));
        JobDetail jobDetail = new JobDetail(scheduleTask.getName() + Math.random() * (double)RANDOM_RANGE, "FileActionRestart", DoFileActionJob.class);
        jobDetail.getJobDataMap().put((Object)"__restarttask__", (Object)scheduleTask);
        jobDetail.getJobDataMap().put((Object)"__attachlist__", (Object)list);
        Trigger trigger = onceITrigger.createTrigger();
        trigger.setName(trigger.getName() + "_FileRestart_" + Math.random());
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }
}

