/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.data.NetworkHelper;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.BasePrivilegeFilter;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.general.FRLogger;
import com.fr.general.privilege.NoCheckHyperLinkSessionAttribute;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.TemplateControlFilterProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthorityControlFilter
extends BasePrivilegeFilter {
    public PrivilegeVote filter(HttpServletRequest httpServletRequest) {
        PrivilegeVote privilegeVote;
        ExtraClassManagerProvider extraClassManagerProvider = (ExtraClassManagerProvider)StableFactory.getMarkedObject((String)"ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider == null) {
            return null;
        }
        TemplateControlFilterProcessor templateControlFilterProcessor = (TemplateControlFilterProcessor)extraClassManagerProvider.getSingle("TemplateControlFilterProcessor");
        if (templateControlFilterProcessor != null) {
            return (PrivilegeVote)templateControlFilterProcessor.filter(httpServletRequest);
        }
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            try {
                AbstractFSAuthService.dealCookie(httpServletRequest, null);
                fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(privilegeVote = this.filterByAuthentication(httpServletRequest, fSAuthentication)).isPermitted()) {
            return this.isHyperLinkNoCheck(httpServletRequest, fSAuthentication);
        }
        return privilegeVote;
    }

    public PrivilegeVote filterByAuthentication(HttpServletRequest httpServletRequest, FSAuthentication fSAuthentication) {
        String string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"reportlet");
        if (string == null) {
            string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"formlet");
        }
        int n = AuthorityControlFilter.createCheckType(httpServletRequest);
        if (string == null) {
            boolean bl = true;
            try {
                String string2 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"reportlets");
                if (StringUtils.isEmpty((String)string2)) {
                    return PrivilegeVoteImpls.MP_AUTH_ERROR;
                }
                bl = this.hasReportletsPrivilege(fSAuthentication, n, string2);
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
            if (bl) {
                return PrivilegeVoteImpls.SUCCESS;
            }
        }
        return this.access(fSAuthentication, string, n);
    }

    private boolean hasReportletsPrivilege(FSAuthentication fSAuthentication, int n, String string) throws JSONException {
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                if (!"reportlet".equals(string2) && !"formlet".equals(string2) || this.access(fSAuthentication, String.valueOf(object), n).isPermitted()) continue;
                return false;
            }
        }
        return true;
    }

    protected PrivilegeVote isHyperLinkNoCheck(HttpServletRequest httpServletRequest, FSAuthentication fSAuthentication) {
        String string;
        String string2;
        long l;
        HttpSession httpSession;
        NoCheckHyperLinkSessionAttribute noCheckHyperLinkSessionAttribute;
        String string3 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"reportlet");
        if (string3 == null) {
            string3 = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"formlet");
        }
        if ((noCheckHyperLinkSessionAttribute = (NoCheckHyperLinkSessionAttribute)(httpSession = httpServletRequest.getSession(true)).getAttribute("fr_nocheck_hyperlinkinfo")) != null && noCheckHyperLinkSessionAttribute.isOneOfTheHyperlinks(string3) && (l = noCheckHyperLinkSessionAttribute.checkAlive(string2 = (String)httpSession.getAttribute("fr_username"), string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"op"), string3)) > 0L) {
            if (System.currentTimeMillis() - l <= this.getTimeout()) {
                return PrivilegeVoteImpls.SUCCESS;
            }
            return PrivilegeVoteImpls.MP_AUTH_TIMEOUT;
        }
        if (fSAuthentication != null) {
            return PrivilegeVoteImpls.MP_ROLE_ERROR;
        }
        return PrivilegeVoteImpls.MP_AUTH_ERROR;
    }

    private static int createCheckType(HttpServletRequest httpServletRequest) {
        String string = null;
        try {
            string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"op");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("write".equalsIgnoreCase(string) || "form".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    private PrivilegeVote access(FSAuthentication fSAuthentication, String string, int n) {
        if (fSAuthentication == null) {
            return PrivilegeVoteImpls.MP_AUTH_ERROR;
        }
        long l = fSAuthentication.getUserInfo().getId();
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return PrivilegeVoteImpls.SUCCESS;
        }
        Set set = new HashSet();
        try {
            set = UserControl.getInstance().getAllTemplatePrivileges(l);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
            if (!(string = StringUtils.cutStringStartWith((String)string, (String)"/")).startsWith(roleTemplatePrivilege.getPath())) continue;
            switch (n) {
                case 0: {
                    if (roleTemplatePrivilege.getPage() != 1L) break;
                    return PrivilegeVoteImpls.SUCCESS;
                }
                case 2: {
                    if (roleTemplatePrivilege.getWrite() != 1L) break;
                    return PrivilegeVoteImpls.SUCCESS;
                }
            }
        }
        return PrivilegeVoteImpls.MP_ROLE_ERROR;
    }

    public int getID() {
        return 1;
    }
}

