/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.plugin.op.web.action;

import com.fr.base.FRContext;
import com.fr.fs.plugin.op.web.helper.DeleteHelper;
import com.fr.fs.plugin.op.web.helper.UploadHelper;
import com.fr.fs.plugin.op.web.helper.WebHelper;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLoader;
import com.fr.plugin.dependence.PluginDependenceException;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateFromDiskAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        File file = UploadHelper.getFileFromFront(httpServletRequest, httpServletResponse, WebHelper.DOWNLOAD_PATH, "temp.zip");
        this.updateFromDisk(file, printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private void updateFromDisk(File file, PrintWriter printWriter) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        try {
            Plugin plugin = WebHelper.readPlugin(file);
            if (plugin == null) {
                jSONObject.put("status", (Object)"failed").put("message", (Object)Inter.getLocText((String)"FS-Msg-Invalid_Plugin_Zip_File"));
                printWriter.println(jSONObject);
                return;
            }
            Plugin plugin2 = PluginLoader.getLoader().getPluginById(plugin.getId());
            if (plugin2 != null) {
                if (WebHelper.isNewThan(plugin, plugin2)) {
                    String[] stringArray = WebHelper.uninstallPlugin(FRContext.getCurrentEnv(), plugin2);
                    DeleteHelper.saveFilesWhichToDelete(stringArray);
                    DeleteHelper.removeFilesFromDir();
                    WebHelper.installPluginFromUnzippedDir(FRContext.getCurrentEnv(), plugin);
                }
                jSONObject.put("status", (Object)"success");
            } else {
                jSONObject.put("status", (Object)"failed").put("message", (Object)Inter.getLocText((String)"FS-Msg-Not_Found_Plugin"));
            }
            printWriter.println(jSONObject);
        }
        catch (PluginDependenceException pluginDependenceException) {
            double d = (double)pluginDependenceException.getPluginLength() / Math.pow(10.0, 6.0);
            String string = String.format("%.2f", d);
            String string2 = pluginDependenceException.getPluginID();
            jSONObject.put("status", (Object)"failed").put("message", (Object)"dependence").put("dependenceLength", (Object)string).put("pluginID", (Object)string2);
            printWriter.println(jSONObject);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            jSONObject.put("status", (Object)"failed").put("message", (Object)exception.getMessage());
            printWriter.println(jSONObject);
        }
    }

    public String getCMD() {
        return "local_update";
    }
}

