/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.plugin.customstyle.service;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.file.filetree.FileNode;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.OperatingSystem;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomStyle {
    private static CustomStyle customStyle = null;
    private static final String CUSTOM_STYLE_DIR = "customstyle";
    private static final int BUFFER_SIZE = 1024;
    private static final String STYLE_ENV_PATH = StableUtils.pathJoin((String[])new String[]{"resources", "customstyle"});
    private static final String COVER_NAME = "cover.png";
    private static final String COVER_NAME_FOR_MAC = "cover@2x.png";
    private static final String CUSTOM_STYLE_PACKAGE_NAME = "com.fr.fs.plugin.customstyle.";
    private static final String CUSTOM_STYLE_PACKAGE_PATH = "/com/fr/fs/plugin/customstyle/";

    public static CustomStyle getInstance() {
        if (customStyle != null) {
            return customStyle;
        }
        customStyle = new CustomStyle();
        return customStyle;
    }

    public JSONArray readCustomStyleList(String string) {
        String string2 = STYLE_ENV_PATH;
        JSONArray jSONArray = JSONArray.create();
        try {
            Env env = FRContext.getCurrentEnv();
            FileNode[] fileNodeArray = env.listFile(string2);
            for (FileNode fileNode : fileNodeArray) {
                String string3 = fileNode.getName();
                if (!fileNode.isDirectory() || !string3.startsWith(string + "-")) continue;
                JSONObject jSONObject = JSONObject.create();
                String string4 = string3.substring((string + "-").length());
                jSONObject.put("name", (Object)string4);
                jSONObject.put("cover", (Object)("customstyle/" + string3 + "/" + (OperatingSystem.isMacOS() ? COVER_NAME_FOR_MAC : COVER_NAME)));
                jSONArray.put((Object)jSONObject);
            }
            Set<String> set = this.getCustomStyleNames(CUSTOM_STYLE_PACKAGE_NAME + string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FileNode fileNode;
                String string5 = (String)iterator.next();
                fileNode = JSONObject.create();
                fileNode.put("name", (Object)string5);
                fileNode.put("cover", (Object)(CUSTOM_STYLE_PACKAGE_PATH + string + "/" + string5 + "/" + (OperatingSystem.isMacOS() ? COVER_NAME_FOR_MAC : COVER_NAME)));
                jSONArray.put((Object)fileNode);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return jSONArray;
    }

    public JSONObject saveStyle(String string, String string2) {
        String string3;
        File file;
        JSONObject jSONObject = JSONObject.create();
        Attachment attachment = AttachmentCacheManager.getAttachment((String)string);
        if (attachment == null) {
            return jSONObject;
        }
        String string4 = attachment.getFilename();
        if (string4.indexOf(46) != -1) {
            string4 = string4.substring(0, string4.lastIndexOf(46));
        }
        if (!(file = new File(string3 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), STYLE_ENV_PATH}))).exists()) {
            file.mkdir();
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attachment.getBytes());
            String string5 = StringUtils.perfectStart((String)string4, (String)(string2 + "-"));
            File file2 = new File(StableUtils.pathJoin((String[])new String[]{string3, "temp"}));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtils.copyBinaryTo((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
            IOUtils.unzip((File)file2, (String)StableUtils.pathJoin((String[])new String[]{string3, string5}));
            fileOutputStream.close();
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
            jSONObject.put("name", (Object)string4);
            File file3 = new File(StableUtils.pathJoin((String[])new String[]{string3, string5, COVER_NAME}));
            if (file3.exists()) {
                jSONObject.put("cover", (Object)("customstyle/" + string5 + "/" + COVER_NAME));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Cannot save style: " + string4, (Throwable)exception);
        }
        return jSONObject;
    }

    private Set<String> getCustomStyleNames(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string2 = string.replace('.', '/');
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(string2);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string3 = uRL.getProtocol();
                if ("jar".equals(string3)) {
                    this.getStyleNamesFromJarFile(((JarURLConnection)uRL.openConnection()).getJarFile(), linkedHashSet, string2);
                    continue;
                }
                if (!"zip".equals(string3)) continue;
                JarFile jarFile = new JarFile(new File(URLDecoder.decode(uRL.getFile(), "utf-8").replace("!/" + string2, "").replace("file:/", "")));
                this.getStyleNamesFromJarFile(jarFile, linkedHashSet, string2);
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
        return linkedHashSet;
    }

    private void getStyleNamesFromJarFile(JarFile jarFile, Set<String> set, String string) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            int n;
            JarEntry jarEntry = enumeration.nextElement();
            String string3 = jarEntry.getName();
            if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
            if (!string3.startsWith(string) || (n = string3.lastIndexOf(47)) == -1 || !string3.endsWith("/") || !StringUtils.isNotEmpty((String)(string2 = string3.replace(string, "").replace("/", "")))) continue;
            set.add(string2);
        }
    }
}

