/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.device;

import com.fr.fs.device.DeviceInfo;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDevice
implements XMLable {
    public static final String XML_TAG = "UserDevice";
    private String username;
    private List<DeviceInfo> deviceInfoList = new ArrayList<DeviceInfo>();

    public UserDevice() {
    }

    public UserDevice(String string, DeviceInfo deviceInfo) {
        this.username = string;
        this.deviceInfoList.add(deviceInfo);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public boolean isEmpty() {
        return this.deviceInfoList.isEmpty();
    }

    public void addDeviceInfo(DeviceInfo deviceInfo) {
        boolean bl = false;
        for (DeviceInfo deviceInfo2 : this.deviceInfoList) {
            if (!this.isMacAddressMatch(deviceInfo2.getMacAddress(), deviceInfo.getMacAddress())) continue;
            deviceInfo2.setPassed(deviceInfo.isPassed());
            deviceInfo2.setDeviceName(deviceInfo.getDeviceName());
            bl = true;
            break;
        }
        if (!bl) {
            this.deviceInfoList.add(deviceInfo);
        }
    }

    public boolean matchMacAddress(String string) {
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            if (!this.isMacAddressMatch(deviceInfo.getMacAddress(), string) || !deviceInfo.isPassed()) continue;
            return true;
        }
        return false;
    }

    public boolean matchMacAddressNoPassCheck(String string) {
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            if (!this.isMacAddressMatch(deviceInfo.getMacAddress(), string)) continue;
            return true;
        }
        return false;
    }

    public DeviceInfo findDeviceInfoByMacAddress(String string) {
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            if (!this.isMacAddressMatch(deviceInfo.getMacAddress(), string)) continue;
            return deviceInfo;
        }
        return null;
    }

    public void unbind(String string, String string2) {
        Iterator<DeviceInfo> iterator = this.deviceInfoList.iterator();
        if (StringUtils.isBlank((String)string)) {
            while (iterator.hasNext()) {
                DeviceInfo deviceInfo = iterator.next();
                if (!deviceInfo.isPassed() && "false".equals(string2)) {
                    iterator.remove();
                }
                if (!deviceInfo.isPassed() || !"true".equals(string2)) continue;
                iterator.remove();
            }
        } else {
            while (iterator.hasNext()) {
                DeviceInfo deviceInfo = iterator.next();
                if (!this.isMacAddressMatch(deviceInfo.getMacAddress(), string)) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void bind(String string, String string2) {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            for (DeviceInfo deviceInfo : this.deviceInfoList) {
                deviceInfo.setPassed(true);
            }
        } else {
            DeviceInfo deviceInfo = this.findDeviceInfoByMacAddress(string);
            if (deviceInfo != null) {
                deviceInfo.setPassed(true);
            } else {
                this.addDeviceInfo(new DeviceInfo(string, string2, true));
            }
        }
    }

    public void updateMacAddress(String string, String string2) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        DeviceInfo deviceInfo = this.findDeviceInfoByMacAddress(string);
        if (deviceInfo != null) {
            deviceInfo.setMacAddress(string2);
        }
    }

    public JSONArray toJSONArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            jSONArray.put((Object)deviceInfo.toJSONObject());
        }
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.deviceInfoList.clear();
        }
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.username = xMLableReader.getAttrAsString("username", null);
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("DeviceInfo")) {
                        DeviceInfo deviceInfo = new DeviceInfo();
                        deviceInfo.readXML(xMLableReader);
                        UserDevice.this.deviceInfoList.add(deviceInfo);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("username", this.username);
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            deviceInfo.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof UserDevice && ComparatorUtils.equals((String)((UserDevice)object).username, (String)this.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    private boolean isMacAddressMatch(String string, String string2) {
        return ComparatorUtils.equalsIgnoreCase((String)string, (String)string2);
    }

    public List<DeviceInfo> getDeviceInfoList() {
        return this.deviceInfoList;
    }
}

