/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.device;

import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class DeviceInfo
implements XMLable {
    public static final String XML_TAG = "DeviceInfo";
    private static final int MAX_NAMELENGTH = 100;
    private String macAddress;
    private String deviceName;
    private boolean passed;

    public DeviceInfo() {
    }

    public DeviceInfo(String string, String string2, boolean bl) {
        this.macAddress = string;
        this.passed = bl;
        this.setDeviceName(string2);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String string) {
        this.macAddress = string;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String string) {
        if (StringUtils.getLength((String)string) > 100) {
            string = string.substring(0, 100);
        }
        this.deviceName = string;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean bl) {
        this.passed = bl;
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject().put("macaddress", (Object)this.macAddress).put("devname", (Object)this.deviceName).put("ispassed", this.passed);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.macAddress = xMLableReader.getAttrAsString("macaddress", null);
            this.setDeviceName(xMLableReader.getAttrAsString("device", null));
            this.passed = xMLableReader.getAttrAsBoolean("passed", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty((String)this.macAddress)) {
            xMLPrintWriter.attr("macaddress", this.macAddress);
        }
        if (StringUtils.isNotEmpty((String)this.deviceName)) {
            xMLPrintWriter.attr("device", this.deviceName);
        }
        if (this.passed) {
            xMLPrintWriter.attr("passed", true);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof DeviceInfo && ComparatorUtils.equals((String)((DeviceInfo)object).macAddress, (String)this.macAddress);
    }

    public int hashCode() {
        return this.macAddress.hashCode();
    }
}

