/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.general.FRLogger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportletEntryDAO
extends EntryDAO<ReportletEntry> {
    private static final String FIELD_REPORTLETPATH = "webletPath";
    private static final String FIELD_NAME = "displayName";
    private static final ReportletEntryDAO SC = new ReportletEntryDAO();

    public static ReportletEntryDAO getInstance() {
        return SC;
    }

    private ReportletEntryDAO() {
    }

    public void save(ReportletEntry reportletEntry) throws Exception {
        this.createSession().save((Object)reportletEntry);
    }

    public void transfer(ReportletEntry reportletEntry) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)reportletEntry);
    }

    public List getReports() throws Exception {
        DataAccessObjectSession dataAccessObjectSession = this.createSession();
        try {
            dataAccessObjectSession.beginTransaction();
            List list = this.createSession().list(ReportletEntry.class);
            return list;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean delete(ReportletEntry reportletEntry) throws Exception {
        long l = reportletEntry.getId();
        if (l < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        return this.deleteByID(l);
    }

    public ReportletEntry findByID(long l) throws Exception {
        return (ReportletEntry)this.createSession().load(ReportletEntry.class, l);
    }

    public List findByPath(String string) throws Exception {
        return this.createSession().listByFieldValue(ReportletEntry.class, FIELD_REPORTLETPATH, (Object)string);
    }

    public List findByReportletPath(String string) throws Exception {
        return this.createSession().listByFieldValue(ReportletEntry.class, FIELD_REPORTLETPATH, (Object)string);
    }

    public List findByName(String string) {
        return this.createSession().listByFieldValue(ReportletEntry.class, FIELD_NAME, (Object)string);
    }

    @Override
    protected Class getEntryClass() {
        return ReportletEntry.class;
    }

    @Override
    protected int getEntryType() {
        return 2;
    }
}

