/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.dao.FSDAOManagerProvider;
import com.fr.fs.fun.DataTransferProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;

public class FSDAOManagerImpl
implements FSDAOManagerProvider {
    private static FSDAOManagerProvider fsdaoManagerProvider;

    public static FSDAOManagerProvider getInstance() {
        if (fsdaoManagerProvider == null) {
            FSDAOManagerImpl.initCache();
        }
        return fsdaoManagerProvider;
    }

    private static synchronized void initCache() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                fsdaoManagerProvider = new FSDAOManagerImpl();
                RPC.registerSkeleton((Object)fsdaoManagerProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                fsdaoManagerProvider = (FSDAOManagerProvider)RPC.getProxy(FSDAOManagerImpl.class, (String)string);
                break;
            }
            default: {
                fsdaoManagerProvider = new FSDAOManagerImpl();
            }
        }
    }

    public DataAccessObjectSession createSession() {
        return FSDAOManager.createSession();
    }

    public DataAccessObjectSession createSession(DatabaseAction databaseAction) {
        if (databaseAction == DatabaseAction.NORMAL) {
            return this.createSession();
        }
        DataTransferProcessor dataTransferProcessor = (DataTransferProcessor)ExtraPlatformClassManager.getInstance().getSingle("DataTransferProcessor");
        if (dataTransferProcessor != null) {
            return dataTransferProcessor.createSession(databaseAction);
        }
        return this.createSession();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                fsdaoManagerProvider = null;
            }
        });
    }
}

