/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.tabledata;

import com.fr.base.FRContext;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleHomePagePrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.tabledata.TableDataFavoriteNode;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataSRole_User;
import com.fr.fs.cache.tabledata.TableDataSyncAction;
import com.fr.fs.cache.tabledata.TableDataSyncAndPersistenceThreadHolder;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.UserDataControl;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.tabledata.TableDataCompanyRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataDepartmentDAO;
import com.fr.fs.control.dao.tabledata.TableDataFavoriteNodeDAO;
import com.fr.fs.control.dao.tabledata.TableDataPostDAO;
import com.fr.fs.control.dao.tabledata.TableDataUserDAO;
import com.fr.fs.fun.FSConfigCompatibleProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONObject;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.sql.DATE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataDAOControl
implements UserDataControl {
    private static final long serialVersionUID = 1192378177381723817L;
    private static TableDataDAOControl tc = null;
    private EmbeddedTableData userTableData;
    private EmbeddedTableData postTableData;
    private EmbeddedTableData departmentTableData;
    private EmbeddedTableData companyRoleAndUserRelation;
    private EmbeddedTableData customRoleAndUserRelation;
    private EmbeddedTableData jRoleTableData;
    private EmbeddedTableData jRolePrivilegeTableData;
    private EmbeddedTableData jRoleESPrivilegeTableData;
    private EmbeddedTableData jRole_ModuleTableData;
    private EmbeddedTableData jRole_HomePageTableData;
    private EmbeddedTableData jRole_TemplatePrivilegeTableData;
    private EmbeddedTableData sRole_TemplatePrivilegeTableData;
    private EmbeddedTableData jRole_DataConnectionPrivilegeTableData;
    private EmbeddedTableData sRole_DataConnectionPrivilegeTableData;
    private Map<String, EmbeddedTableData> companyRole_PlateTableData = new ConcurrentHashMap<String, EmbeddedTableData>();
    private EmbeddedTableData sRoleTableData;
    private EmbeddedTableData sRolePrivilegeTableData;
    private EmbeddedTableData sRoleESPrivilegeTableData;
    private EmbeddedTableData sRole_ModuleTableData;
    private EmbeddedTableData sRole_HomePageTableData;
    private EmbeddedTableData sRole_UserTableData;
    private EmbeddedTableData companyRole_DepAndCRolePrivilegeTableData;
    private EmbeddedTableData customRole_DepAndCRolePrivilegeTableData;
    private Map<String, EmbeddedTableData> customRole_PlateTableData = new ConcurrentHashMap<String, EmbeddedTableData>();
    private EmbeddedTableData favoriteNodeTableData;
    private EmbeddedTableData ADHOCReportTableData;
    private EmbeddedTableData BIReportTableData;
    private EmbeddedTableData BISharedReportTableData;
    private String dsName;
    private int userNameIndex = -1;
    private int passwordIndex = -1;
    private int departmentIndex = -1;
    private int postIndex = -1;
    private int roleIndex = -1;
    private int nameIndex = -1;
    private int emailIndex = -1;
    private int mobileIndex = -1;
    private boolean newVersion = false;
    private PasswordValidator pv;
    private static final long DEFAULT_RATE = 600L;
    private static final long THOUSAND = 1000L;
    private int timeout = 60;
    private volatile long initGapTime = 600L;

    public static TableDataDAOControl getInstance() {
        if (tc == null) {
            tc = new TableDataDAOControl();
        }
        return tc;
    }

    public boolean hasSetTableDataSync() {
        boolean bl = FSConfig.getProviderInstance().getAuthenticateObjectType().authenticationWithoutPassword();
        return this.getDsName() != null && DatasourceManager.getProviderInstance().getTableData(this.getDsName()) != null && this.getUserNameIndex() > -1 && (bl || this.getPasswordIndex() > -1);
    }

    @Override
    public int getControlType() {
        return 1;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public long getInitGapTimeAsMillisecond() {
        return this.initGapTime * 1000L;
    }

    public long getInitGapTime() {
        if (this.newVersion) {
            return this.initGapTime;
        }
        return 600L;
    }

    public void setInitGapTime(long l) {
        this.initGapTime = l;
    }

    public void setNewVersion(boolean bl) {
        this.newVersion = bl;
    }

    public boolean isNewVersion() {
        return this.newVersion;
    }

    public void readXML(XMLableReader xMLableReader) {
        FSConfigCompatibleProcessor fSConfigCompatibleProcessor = (FSConfigCompatibleProcessor)ExtraPlatformClassManager.getInstance().getSingle("FSConfigCompatibleProcessor");
        if (fSConfigCompatibleProcessor != null) {
            fSConfigCompatibleProcessor.compatibleWithDataControl(this, xMLableReader);
        }
        this.readChild(xMLableReader);
    }

    private void readCustomRolesWithPlate(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("CustomRoleWithPlate")) {
                    xMLableReader.readXMLObject(new XMLReadable(){
                        EmbeddedTableData etd = null;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode()) {
                                if (ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"PlateName")) {
                                    this.etd = TableDataDAOControl.this.getCustomRoleTableDataByPlateName(xMLableReader.getElementValue());
                                } else if (ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"EmbededTableData")) {
                                    xMLableReader.readXMLObject((XMLReadable)this.etd);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private void readCompanyRolesWithPlate(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("CompanyRoleWithPlate")) {
                    xMLableReader.readXMLObject(new XMLReadable(){
                        EmbeddedTableData etd = null;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode()) {
                                if (ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"PlateName")) {
                                    this.etd = TableDataDAOControl.this.getCompanyRoleTableDataByPlateName(xMLableReader.getElementValue());
                                } else if (ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"EmbededTableData")) {
                                    xMLableReader.readXMLObject((XMLReadable)this.etd);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("dsName", (Object)this.getDsName());
        jSONObject.put("userName", this.getUserNameIndex());
        jSONObject.put("password", this.getPasswordIndex());
        jSONObject.put("department", this.getDepartmentIndex());
        jSONObject.put("post", this.getPostIndex());
        jSONObject.put("role", this.getRoleIndex());
        jSONObject.put("name", this.getNameIndex());
        jSONObject.put("rate", this.getInitGapTime());
        jSONObject.put("newVersion", true);
        PasswordValidator passwordValidator = this.getPv();
        JSONObject jSONObject2 = passwordValidator.toJSONObject();
        jSONObject.join(jSONObject2);
        jSONObject.put("email", this.getEmailIndex());
        jSONObject.put("mobile", this.getMobileIndex());
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.setTableDataParameter(jSONObject);
        this.setNewVersion(true);
        if (jSONObject.has("mobile")) {
            this.setMobileIndex(jSONObject.getInt("mobile"));
        } else {
            this.setMobileIndex(-1);
        }
        if (jSONObject.has("encrypt")) {
            int n = jSONObject.getInt("encrypt");
            if (n == 0) {
                this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
            } else if (n == 1) {
                ClassPasswordValidator classPasswordValidator = new ClassPasswordValidator();
                classPasswordValidator.setClassName(jSONObject.getString("myencrypt"));
                this.setPv((PasswordValidator)classPasswordValidator);
            } else {
                this.setPv(MessageDigestPasswordValidator.MD5_PASSWORD_VALIDATOR);
            }
        } else {
            this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
        }
    }

    private void setTableDataParameter(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("dsName")) {
            this.setDsName(jSONObject.getString("dsName"));
        } else {
            this.setDsName(null);
        }
        if (jSONObject.has("userName")) {
            this.setUserNameIndex(jSONObject.getInt("userName"));
        } else {
            this.setUserNameIndex(-1);
        }
        if (jSONObject.has("password")) {
            this.setPasswordIndex(jSONObject.getInt("password"));
        } else {
            this.setPasswordIndex(-1);
        }
        if (jSONObject.has("department")) {
            this.setDepartmentIndex(jSONObject.getInt("department"));
        } else {
            this.setDepartmentIndex(-1);
        }
        if (jSONObject.has("post")) {
            this.setPostIndex(jSONObject.getInt("post"));
        } else {
            this.setPostIndex(-1);
        }
        if (jSONObject.has("name")) {
            this.setNameIndex(jSONObject.getInt("name"));
        } else {
            this.setNameIndex(-1);
        }
        if (jSONObject.has("role")) {
            this.setRoleIndex(jSONObject.getInt("role"));
        } else {
            this.setRoleIndex(-1);
        }
        if (jSONObject.has("email")) {
            this.setEmailIndex(jSONObject.getInt("email"));
        } else {
            this.setEmailIndex(-1);
        }
        if (jSONObject.has("rate")) {
            this.setInitGapTime(jSONObject.getLong("rate"));
        } else {
            this.setInitGapTime(600L);
        }
    }

    public String getDsName() {
        return this.dsName;
    }

    private void setDsName(String string) {
        this.dsName = string;
    }

    public int getUserNameIndex() {
        return this.userNameIndex;
    }

    private void setUserNameIndex(int n) {
        this.userNameIndex = n;
    }

    public int getPasswordIndex() {
        return this.passwordIndex;
    }

    private void setPasswordIndex(int n) {
        this.passwordIndex = n;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    private void setPostIndex(int n) {
        this.postIndex = n;
    }

    public int getRoleIndex() {
        return this.roleIndex;
    }

    private void setRoleIndex(int n) {
        this.roleIndex = n;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    private void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public int getDepartmentIndex() {
        return this.departmentIndex;
    }

    private void setDepartmentIndex(int n) {
        this.departmentIndex = n;
    }

    public int getEmailIndex() {
        return this.emailIndex;
    }

    private void setEmailIndex(int n) {
        this.emailIndex = n;
    }

    public int getMobileIndex() {
        return this.mobileIndex;
    }

    private void setMobileIndex(int n) {
        this.mobileIndex = n;
    }

    public EmbeddedTableData getUserTableData() {
        if (this.userTableData == null) {
            this.userTableData = this.initEmbeddedTableData(UserTable.USERCOLUMN);
        }
        return this.userTableData;
    }

    public EmbeddedTableData getPostTableData() {
        if (this.postTableData == null) {
            this.postTableData = this.initEmbeddedTableData(PostTable.POSTCOLUMN);
        }
        return this.postTableData;
    }

    public EmbeddedTableData getDepartmentTableData() {
        if (this.departmentTableData == null) {
            this.departmentTableData = this.initEmbeddedTableData(DepartmentTable.DEPARTMENTCOLUMN);
        }
        return this.departmentTableData;
    }

    public EmbeddedTableData getCompanyRoleAndUserRelation() {
        if (this.companyRoleAndUserRelation == null) {
            this.companyRoleAndUserRelation = this.initEmbeddedTableData(CompanyRoleForeignKeyToUserTable.USERCOMPANYROLERELATIONCOLUMN);
        }
        return this.companyRoleAndUserRelation;
    }

    public EmbeddedTableData getCustomRoleAndUserRelation() {
        if (this.customRoleAndUserRelation == null) {
            this.customRoleAndUserRelation = this.initEmbeddedTableData(CustomRoleForeignKeyToUserTable.USERCUSTOMROLERELATIONCOLUMN);
        }
        return this.customRoleAndUserRelation;
    }

    public EmbeddedTableData getJRoleTableData() {
        if (this.jRoleTableData == null) {
            this.jRoleTableData = this.initEmbeddedTableData(JRoleTable.COLUMNS);
        }
        return this.jRoleTableData;
    }

    public EmbeddedTableData getSRoleTableData() {
        if (this.sRoleTableData == null) {
            this.sRoleTableData = this.initEmbeddedTableData(SRoleTable.COLUMNS);
        }
        return this.sRoleTableData;
    }

    public EmbeddedTableData getJRolePrivilegeTableData() {
        if (this.jRolePrivilegeTableData == null) {
            this.jRolePrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRolePrivilegeTableData;
    }

    public EmbeddedTableData getJRoleTemplatePrivilegeTableData() {
        if (this.jRole_TemplatePrivilegeTableData == null) {
            this.jRole_TemplatePrivilegeTableData = this.initEmbeddedTableData(RoleTemplatePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRole_TemplatePrivilegeTableData;
    }

    public EmbeddedTableData getSRoleTemplatePrivilegeTableData() {
        if (this.sRole_TemplatePrivilegeTableData == null) {
            this.sRole_TemplatePrivilegeTableData = this.initEmbeddedTableData(RoleTemplatePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_TemplatePrivilegeTableData;
    }

    public EmbeddedTableData getJRoleDataConnectionPrivilegeTableData() {
        if (this.jRole_DataConnectionPrivilegeTableData == null) {
            this.jRole_DataConnectionPrivilegeTableData = this.initEmbeddedTableData(RoleDataConnectionPrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRole_DataConnectionPrivilegeTableData;
    }

    public EmbeddedTableData getSRoleDataConnectionPrivilegeTableData() {
        if (this.sRole_DataConnectionPrivilegeTableData == null) {
            this.sRole_DataConnectionPrivilegeTableData = this.initEmbeddedTableData(RoleDataConnectionPrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_DataConnectionPrivilegeTableData;
    }

    public EmbeddedTableData getJRoleESPrivilegeTableData() {
        if (this.jRoleESPrivilegeTableData == null) {
            this.jRoleESPrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRoleESPrivilegeTableData;
    }

    public EmbeddedTableData getSRolePrivilegeTableData() {
        if (this.sRolePrivilegeTableData == null) {
            this.sRolePrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRolePrivilegeTableData;
    }

    public EmbeddedTableData getSRoleESPrivilegeTableData() {
        if (this.sRoleESPrivilegeTableData == null) {
            this.sRoleESPrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRoleESPrivilegeTableData;
    }

    public EmbeddedTableData getCompanyRoleDepAndCRolePrivilegeTableData() {
        if (this.companyRole_DepAndCRolePrivilegeTableData == null) {
            this.companyRole_DepAndCRolePrivilegeTableData = this.initEmbeddedTableData(Role_DepAndCRolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.companyRole_DepAndCRolePrivilegeTableData;
    }

    public EmbeddedTableData getCustomRoleDepAndCRolePrivilegeTableData() {
        if (this.customRole_DepAndCRolePrivilegeTableData == null) {
            this.customRole_DepAndCRolePrivilegeTableData = this.initEmbeddedTableData(Role_DepAndCRolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.customRole_DepAndCRolePrivilegeTableData;
    }

    public EmbeddedTableData getSRole_UserTableData() {
        if (this.sRole_UserTableData == null) {
            this.sRole_UserTableData = this.initEmbeddedTableData(SRole_UserTable.COLUMNS);
        }
        return this.sRole_UserTableData;
    }

    public EmbeddedTableData getSRole_ModuleTableData() {
        if (this.sRole_ModuleTableData == null) {
            this.sRole_ModuleTableData = this.initEmbeddedTableData(Role_ModuleTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_ModuleTableData;
    }

    public EmbeddedTableData getCustomRoleHomePageTableData() {
        if (this.sRole_HomePageTableData == null) {
            this.sRole_HomePageTableData = this.initEmbeddedTableData(Role_HomePageTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_HomePageTableData;
    }

    public EmbeddedTableData getCustomRoleTableDataByPlateName(String string) {
        if (this.customRole_PlateTableData.get(string) != null) {
            return this.customRole_PlateTableData.get(string);
        }
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(PlateFactory.getTableDataColumnsByName(string));
        this.customRole_PlateTableData.put(string, embeddedTableData);
        return embeddedTableData;
    }

    public EmbeddedTableData getJRole_ModuleTableData() {
        if (this.jRole_ModuleTableData == null) {
            this.jRole_ModuleTableData = this.initEmbeddedTableData(Role_ModuleTable.COMPANYCOLUMNS);
        }
        return this.jRole_ModuleTableData;
    }

    public EmbeddedTableData getCompanyRoleHomePageTableData() {
        if (this.jRole_HomePageTableData == null) {
            this.jRole_HomePageTableData = this.initEmbeddedTableData(Role_HomePageTable.COMPANYCOLUMNS);
        }
        return this.jRole_HomePageTableData;
    }

    public EmbeddedTableData getCompanyRoleTableDataByPlateName(String string) {
        if (this.companyRole_PlateTableData.get(string) != null) {
            return this.companyRole_PlateTableData.get(string);
        }
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(PlateFactory.getTableDataColumnsByName(string));
        this.companyRole_PlateTableData.put(string, embeddedTableData);
        return embeddedTableData;
    }

    public EmbeddedTableData getFavoriteNodeTableData() {
        if (this.favoriteNodeTableData == null) {
            this.favoriteNodeTableData = this.initEmbeddedTableData(FavoriteNodeTable.COLUMNS);
        }
        return this.favoriteNodeTableData;
    }

    public EmbeddedTableData getADHOCReportTabledata() {
        if (this.ADHOCReportTableData == null) {
            this.ADHOCReportTableData = this.initEmbeddedTableData(ADHOCReportTable.COLUMNS);
        }
        return this.ADHOCReportTableData;
    }

    public EmbeddedTableData getBIReportTabledata() {
        if (this.BIReportTableData == null) {
            this.BIReportTableData = this.initEmbeddedTableData(BIReportTable.COLUMNS);
        }
        return this.BIReportTableData;
    }

    public EmbeddedTableData getBISharedReportTableData() {
        if (this.BISharedReportTableData == null) {
            this.BISharedReportTableData = this.initEmbeddedTableData(BISharedReportTable.COLUMNS);
        }
        return this.BISharedReportTableData;
    }

    @Override
    public CompanyRoleDAO getCompanyRoleDAO() {
        return TableDataCompanyRoleDAO.getInstance();
    }

    @Override
    public CustomRoleDAO getCustomRoleDAO() {
        return TableDataCustomRoleDAO.getInstance();
    }

    @Override
    public UserDAO getUserDAO() {
        return TableDataUserDAO.getInstance();
    }

    @Override
    public FavoriteNodeDAO getFavoriteNodeDAO() {
        return TableDataFavoriteNodeDAO.getInstance();
    }

    @Override
    public DepartmentDAO getDepartmentDAO() {
        return TableDataDepartmentDAO.getInstance();
    }

    @Override
    public PostDAO getPostDAO() {
        return TableDataPostDAO.getInstance();
    }

    @Override
    public <T> T getOpenDAO(Class<? extends T> clazz) {
        return (T)StableFactory.getMarkedObject((String)TableDataDAOControl.class.getName(), clazz);
    }

    @Override
    public boolean init() {
        try {
            TableDataSyncDB.getInstance().reinit();
            FSConfig.getProviderInstance().clearCache();
            if (this.newVersion) {
                TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataSyncThread().triggerWork(new TableDataSyncAction());
            } else {
                new TableDataSyncAction().work();
            }
            TableDataSyncAndPersistenceThreadHolder.getInstance().resetTimer(TableDataDAOControl.getInstance().getInitGapTimeAsMillisecond(), TableDataDAOControl.getInstance().getInitGapTimeAsMillisecond());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    private EmbeddedTableData initEmbeddedTableData(ColumnColumn[] columnColumnArray) {
        EmbeddedTableData embeddedTableData = new EmbeddedTableData();
        for (ColumnColumn columnColumn : columnColumnArray) {
            embeddedTableData.addColumn(columnColumn.getName(), columnColumn.getClazz());
        }
        return embeddedTableData;
    }

    public void writeSRoleTableData(Set<Map.Entry<Long, CustomRole>> set) {
        this.sRoleTableData = this.initEmbeddedTableData(SRoleTable.COLUMNS);
        for (Map.Entry<Long, CustomRole> entry : set) {
            CustomRole customRole = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(customRole.getId()));
            arrayList.add(customRole.getRolename());
            arrayList.add(customRole.getDescription());
            this.sRoleTableData.addRow(arrayList);
        }
    }

    public void writePostTableData(Set<Map.Entry<String, Long>> set) {
        this.postTableData = this.initEmbeddedTableData(PostTable.POSTCOLUMN);
        for (Map.Entry<String, Long> entry : set) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(entry.getKey());
            arrayList.add(String.valueOf(entry.getValue()));
            this.postTableData.addRow(arrayList);
        }
    }

    public void writeDepartmentTableData(Set<Map.Entry<String, Department>> set) {
        this.departmentTableData = this.initEmbeddedTableData(DepartmentTable.DEPARTMENTCOLUMN);
        for (Map.Entry<String, Department> entry : set) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(entry.getValue().getId()));
            arrayList.add(String.valueOf(entry.getValue().getPid()));
            arrayList.add(entry.getValue().getName());
            arrayList.add(entry.getValue().getDescription());
            this.departmentTableData.addRow(arrayList);
        }
    }

    public void writeUserTableData(Set<Map.Entry<Long, TableDataUser>> set) {
        this.userTableData = this.initEmbeddedTableData(UserTable.USERCOLUMN);
        this.companyRoleAndUserRelation = this.initEmbeddedTableData(CompanyRoleForeignKeyToUserTable.USERCOMPANYROLERELATIONCOLUMN);
        this.customRoleAndUserRelation = this.initEmbeddedTableData(CustomRoleForeignKeyToUserTable.USERCUSTOMROLERELATIONCOLUMN);
        for (Map.Entry<Long, TableDataUser> entry : set) {
            Object object;
            Object object2;
            TableDataUser tableDataUser = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataUser.getId()));
            arrayList.add(tableDataUser.getUserName());
            arrayList.add(tableDataUser.getPassword());
            arrayList.add(tableDataUser.getName());
            arrayList.add(tableDataUser.getEmail());
            arrayList.add(tableDataUser.getMobile());
            this.userTableData.addRow(arrayList);
            Iterator iterator = tableDataUser.getJobIterator();
            while (iterator.hasNext()) {
                object2 = (Job)iterator.next();
                object = new ArrayList<String>();
                object.add(String.valueOf(tableDataUser.getId()));
                object.add(String.valueOf(((Job)object2).getDepartmentID()));
                object.add(String.valueOf(((Job)object2).getPostID()));
                this.companyRoleAndUserRelation.addRow((List)object);
            }
            object2 = tableDataUser.getSroleIterator();
            while (object2.hasNext()) {
                object = (CustomRole)((Object)object2.next());
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(String.valueOf(tableDataUser.getId()));
                arrayList2.add(String.valueOf(object.getId()));
                this.customRoleAndUserRelation.addRow(arrayList2);
            }
        }
    }

    public void writeSRole_UserTableData(Set<Map.Entry<Long, TableDataSRole_User>> set) {
        this.sRole_UserTableData = this.initEmbeddedTableData(SRole_UserTable.COLUMNS);
        for (Map.Entry<Long, TableDataSRole_User> entry : set) {
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataSRole_User.getId()));
            arrayList.add(String.valueOf(tableDataSRole_User.getsRoleId()));
            arrayList.add(tableDataSRole_User.getUserName());
            this.sRole_UserTableData.addRow(arrayList);
        }
    }

    public void writeTableDataFavoriteMap(Set<Map.Entry<Long, TableDataFavoriteNode>> set) {
        this.favoriteNodeTableData = this.initEmbeddedTableData(FavoriteNodeTable.COLUMNS);
        for (Map.Entry<Long, TableDataFavoriteNode> entry : set) {
            TableDataFavoriteNode tableDataFavoriteNode = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataFavoriteNode.getId()));
            arrayList.add(tableDataFavoriteNode.getUserName());
            arrayList.add(String.valueOf(tableDataFavoriteNode.getType()));
            arrayList.add(String.valueOf(tableDataFavoriteNode.getEntryid()));
            this.favoriteNodeTableData.addRow(arrayList);
        }
    }

    public void writeJRoleTableData(Set<Map.Entry<Long, TableDataJRole>> set) {
        this.jRoleTableData = this.initEmbeddedTableData(JRoleTable.COLUMNS);
        for (Map.Entry<Long, TableDataJRole> entry : set) {
            TableDataJRole tableDataJRole = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataJRole.getId()));
            arrayList.add(tableDataJRole.getDpName());
            arrayList.add(tableDataJRole.getPostName());
            arrayList.add(tableDataJRole.getDescription());
            arrayList.add(String.valueOf(tableDataJRole.getDpId()));
            arrayList.add(tableDataJRole.getDpMarkValue());
            this.jRoleTableData.addRow(arrayList);
        }
    }

    public void writeJRoleEnrtyPrivilegeTableData(Set<Map.Entry<Long, RoleEntryPrivilege>> set) {
        this.jRolePrivilegeTableData = this.writeRolePrivilegeTableData(set, RolePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeSRoleEnrtyPrivilegeTableData(Set<Map.Entry<Long, RoleEntryPrivilege>> set) {
        this.sRolePrivilegeTableData = this.writeRolePrivilegeTableData(set, RolePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRoleDataConnectionPrivilegeTableData(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set) {
        this.jRole_DataConnectionPrivilegeTableData = this.writeRoleDataConnectionPrivilegeTableData(set, RoleDataConnectionPrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeSRoleDataConnectionPrivilegeTableData(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set) {
        this.sRole_DataConnectionPrivilegeTableData = this.writeRoleDataConnectionPrivilegeTableData(set, RoleDataConnectionPrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRoleTemplatePrivilegeTableData(Set<Map.Entry<Long, RoleTemplatePrivilege>> set) {
        this.jRole_TemplatePrivilegeTableData = this.writeRoleTemplatePrivilegeTableData(set, RoleTemplatePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeSRoleTemplatePrivilegeTableData(Set<Map.Entry<Long, RoleTemplatePrivilege>> set) {
        this.sRole_TemplatePrivilegeTableData = this.writeRoleTemplatePrivilegeTableData(set, RoleTemplatePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeCompanyRoleDepAndCRolePrivilegeTableData(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set) {
        this.companyRole_DepAndCRolePrivilegeTableData = this.writeRoleDepAndCRolePrivilegeTableData(set, Role_DepAndCRolePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeCustomRoleDepAndCRolePrivilegeTableData(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set) {
        this.customRole_DepAndCRolePrivilegeTableData = this.writeRoleDepAndCRolePrivilegeTableData(set, Role_DepAndCRolePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRoleESPrivilegeTableData(Set<Map.Entry<Long, RoleESPrivilege>> set) {
        this.jRoleESPrivilegeTableData = this.writeRoleESPrivilegeTableData(set, RolePrivilegeTable.COMPANYCOLUMNS);
    }

    public void writeSRoleESPrivilegeTableData(Set<Map.Entry<Long, RoleESPrivilege>> set) {
        this.sRoleESPrivilegeTableData = this.writeRoleESPrivilegeTableData(set, RolePrivilegeTable.CUSTOMROLECOLUMNS);
    }

    public void writeJRole_ModulePrivilegeTableData(Set<Map.Entry<Long, RoleModulePrivilege>> set) {
        this.jRole_ModuleTableData = this.writeRoleModulePrivilegeTableData(set, Role_ModuleTable.COMPANYCOLUMNS, true);
    }

    public void writeSRole_ModulePrivilegeTableData(Set<Map.Entry<Long, RoleModulePrivilege>> set) {
        this.sRole_ModuleTableData = this.writeRoleModulePrivilegeTableData(set, Role_ModuleTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRole_HomePagePrivilegeTableData(Set<Map.Entry<Long, RoleHomePagePrivilege>> set) {
        this.jRole_HomePageTableData = this.writeRoleHomePagePrivilegeTableData(set, Role_HomePageTable.COMPANYCOLUMNS, true);
    }

    public void writeSRole_HomePagePrivilegeTableData(Set<Map.Entry<Long, RoleHomePagePrivilege>> set) {
        this.sRole_HomePageTableData = this.writeRoleHomePagePrivilegeTableData(set, Role_HomePageTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRole_PlatePrivilegeTableData(Set<Map.Entry<Long, RoleEntryPrivilege>> set, String string) {
        this.companyRole_PlateTableData.put(string, this.writeRolePrivilegeTableData(set, PlateFactory.getTableDataColumnsByName(string), true));
    }

    public void writeSRole_PlatePrivilegeTableData(Set<Map.Entry<Long, RoleEntryPrivilege>> set, String string) {
        this.customRole_PlateTableData.put(string, this.writeRolePrivilegeTableData(set, PlateFactory.getTableDataColumnsByName(string), false));
    }

    private EmbeddedTableData writeRolePrivilegeTableData(Set<Map.Entry<Long, RoleEntryPrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleEntryPrivilege.getId()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getRoleId()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getType()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getEntryid()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getView()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getAuthorized()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getEdit()));
            if (!bl) {
                arrayList.add(((CustomRoleEntryPrivilege)roleEntryPrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleESPrivilegeTableData(Set<Map.Entry<Long, RoleESPrivilege>> set, ColumnColumn[] columnColumnArray) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleESPrivilege> entry : set) {
            RoleESPrivilege roleESPrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleESPrivilege.getId()));
            arrayList.add(String.valueOf(roleESPrivilege.getRoleId()));
            arrayList.add(String.valueOf(roleESPrivilege.getType()));
            arrayList.add(String.valueOf(roleESPrivilege.getEntryID()));
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleDepAndCRolePrivilegeTableData(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : set) {
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getId()));
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getRoleid()));
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getType()));
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getDeporcroleid()));
            if (!bl) {
                arrayList.add(((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleTemplatePrivilegeTableData(Set<Map.Entry<Long, RoleTemplatePrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleTemplatePrivilege.getId()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getRoleId()));
            arrayList.add(roleTemplatePrivilege.getPath());
            arrayList.add(String.valueOf(roleTemplatePrivilege.getPage()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getWrite()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getDesign()));
            if (!bl) {
                arrayList.add(((CustomRoleTemplatePrivilege)roleTemplatePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleDataConnectionPrivilegeTableData(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleDataConnectionPrivilege> entry : set) {
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getId()));
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getRoleId()));
            arrayList.add(roleDataConnectionPrivilege.getName());
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getView()));
            if (!bl) {
                arrayList.add(((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleModulePrivilegeTableData(Set<Map.Entry<Long, RoleModulePrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleModulePrivilege> entry : set) {
            RoleModulePrivilege roleModulePrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleModulePrivilege.getId()));
            arrayList.add(String.valueOf(roleModulePrivilege.getRoleId()));
            arrayList.add(String.valueOf(-1));
            arrayList.add(String.valueOf(roleModulePrivilege.getModuleid()));
            arrayList.add(String.valueOf(roleModulePrivilege.getView()));
            arrayList.add(String.valueOf(roleModulePrivilege.getAuthorized()));
            if (!bl) {
                arrayList.add(((CustomRoleModulePrivilege)roleModulePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleHomePagePrivilegeTableData(Set<Map.Entry<Long, RoleHomePagePrivilege>> set, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        for (Map.Entry<Long, RoleHomePagePrivilege> entry : set) {
            RoleHomePagePrivilege roleHomePagePrivilege = entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleHomePagePrivilege.getId()));
            arrayList.add(String.valueOf(roleHomePagePrivilege.getRoleId()));
            arrayList.add(String.valueOf(roleHomePagePrivilege.getHomePageId()));
            arrayList.add(String.valueOf(roleHomePagePrivilege.getView()));
            if (!bl) {
                arrayList.add(((CustomRoleHomePagePrivilege)roleHomePagePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    @Override
    public PasswordValidator getPv() {
        if (this.pv == null) {
            this.pv = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
        }
        return this.pv;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setPv(PasswordValidator passwordValidator) {
        this.pv = passwordValidator;
    }

    private void readChild(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                this.dsName = xMLableReader.getAttrAsString("dsName", "");
                this.userNameIndex = xMLableReader.getAttrAsInt("userName", 0);
                this.passwordIndex = xMLableReader.getAttrAsInt("password", 0);
                this.departmentIndex = xMLableReader.getAttrAsInt("department", 0);
                this.postIndex = xMLableReader.getAttrAsInt("post", 0);
                this.roleIndex = xMLableReader.getAttrAsInt("role", 0);
                this.nameIndex = xMLableReader.getAttrAsInt("name", 0);
                this.emailIndex = xMLableReader.getAttrAsInt("email", 0);
                this.mobileIndex = xMLableReader.getAttrAsInt("mobile", 0);
                this.initGapTime = xMLableReader.getAttrAsLong("rate", 600L);
                this.timeout = xMLableReader.getAttrAsInt("timeout", 60);
                this.newVersion = xMLableReader.getAttrAsBoolean("newVersion", false);
            } else if ("JRole".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRoleTableData());
            } else if ("SRole".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRoleTableData());
            } else if ("SRole_User".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRole_UserTableData());
            } else if ("JRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRolePrivilegeTableData());
            } else if ("SRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRolePrivilegeTableData());
            } else if ("JRoleESPrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRoleESPrivilegeTableData());
            } else if ("SRoleESPrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRoleESPrivilegeTableData());
            } else if ("SRoleModule".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRole_ModuleTableData());
            } else if ("JRoleModule".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRole_ModuleTableData());
            } else if ("JRoleHomePagePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCompanyRoleHomePageTableData());
            } else if ("SRoleHomePagePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCustomRoleHomePageTableData());
            } else if ("CompanyRolesWithPlate".equals(string)) {
                this.readCompanyRolesWithPlate(xMLableReader);
            } else if ("CustomRolesWithPlate".equals(string)) {
                this.readCustomRolesWithPlate(xMLableReader);
            } else if ("favorateNode".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getFavoriteNodeTableData());
            } else if ("BIReport".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getBIReportTabledata());
            } else if ("BISharedReport".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getBISharedReportTableData());
            } else if ("CompanyRoleDepAndCRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCompanyRoleDepAndCRolePrivilegeTableData());
            } else if ("CustomRoleDepAndCRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCustomRoleDepAndCRolePrivilegeTableData());
            } else if ("JRoleTemplatePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRoleTemplatePrivilegeTableData());
            } else if ("SRoleTemplatePrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRoleTemplatePrivilegeTableData());
            } else if ("JRoleDataConnectionPrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getJRoleDataConnectionPrivilegeTableData());
            } else if ("SRoleDataConnectionPrivilege".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getSRoleDataConnectionPrivilegeTableData());
            } else if ("PasswordValidator".equals(string)) {
                this.setPv((PasswordValidator)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader));
            } else if ("Post".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getPostTableData());
            } else if ("Department".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getDepartmentTableData());
            } else if ("TableUser".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getUserTableData());
            } else if ("CompanyRoleAndUserRelation".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCompanyRoleAndUserRelation());
            } else if ("CustomRoleAndUserRelation".equals(string)) {
                xMLableReader.readXMLObject((XMLReadable)this.getCustomRoleAndUserRelation());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr");
        xMLPrintWriter.attr("dsName", this.getDsName());
        xMLPrintWriter.attr("userName", this.getUserNameIndex());
        xMLPrintWriter.attr("password", this.getPasswordIndex());
        xMLPrintWriter.attr("department", this.getDepartmentIndex());
        xMLPrintWriter.attr("post", this.getPostIndex());
        xMLPrintWriter.attr("role", this.getRoleIndex());
        xMLPrintWriter.attr("name", this.getNameIndex());
        xMLPrintWriter.attr("email", this.getEmailIndex());
        xMLPrintWriter.attr("mobile", this.getMobileIndex());
        xMLPrintWriter.attr("rate", this.getInitGapTime());
        xMLPrintWriter.attr("timeout", this.getTimeout());
        xMLPrintWriter.attr("newVersion", true);
        xMLPrintWriter.end();
        this.writeUserAndDepartmentAndPost(xMLPrintWriter);
        this.writeRoles(xMLPrintWriter);
        this.writePrivilege(xMLPrintWriter);
        this.writeESPrivilege(xMLPrintWriter);
        this.writeDepAndCRolePrivilege(xMLPrintWriter);
        this.writeTemplatePrivilege(xMLPrintWriter);
        this.writeHomePagePrivilege(xMLPrintWriter);
        this.writeDataConnectionPrivilege(xMLPrintWriter);
        if (this.sRole_ModuleTableData != null) {
            xMLPrintWriter.startTAG("SRoleModule");
            this.getSRole_ModuleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeCustomPlate(xMLPrintWriter);
        if (this.jRole_ModuleTableData != null) {
            xMLPrintWriter.startTAG("JRoleModule");
            this.getJRole_ModuleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeCompanyPlate(xMLPrintWriter);
        if (this.favoriteNodeTableData != null) {
            xMLPrintWriter.startTAG("favorateNode");
            this.getFavoriteNodeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeBI(xMLPrintWriter);
    }

    private void writeUserAndDepartmentAndPost(XMLPrintWriter xMLPrintWriter) {
        if (this.postTableData != null) {
            xMLPrintWriter.startTAG("Post");
            this.getPostTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.departmentTableData != null) {
            xMLPrintWriter.startTAG("Department");
            this.getDepartmentTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.userTableData != null) {
            xMLPrintWriter.startTAG("TableUser");
            this.getUserTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.companyRoleAndUserRelation != null) {
            xMLPrintWriter.startTAG("CompanyRoleAndUserRelation");
            this.getCompanyRoleAndUserRelation().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.customRoleAndUserRelation != null) {
            xMLPrintWriter.startTAG("CustomRoleAndUserRelation");
            this.getCustomRoleAndUserRelation().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeRoles(XMLPrintWriter xMLPrintWriter) {
        if (this.pv != null && this.pv != PasswordValidator.EMPTY_PASSWORD_VALIDATOR) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.pv, (String)"PasswordValidator");
        }
        if (this.jRoleTableData != null) {
            xMLPrintWriter.startTAG("JRole");
            this.getJRoleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRoleTableData != null) {
            xMLPrintWriter.startTAG("SRole");
            this.getSRoleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRole_UserTableData != null) {
            xMLPrintWriter.startTAG("SRole_User");
            this.getSRole_UserTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRolePrivilege");
            this.getJRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRolePrivilege");
            this.getSRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeHomePagePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRole_HomePageTableData != null) {
            xMLPrintWriter.startTAG("JRoleHomePagePrivilege");
            this.getCompanyRoleHomePageTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRole_HomePageTableData != null) {
            xMLPrintWriter.startTAG("SRoleHomePagePrivilege");
            this.getCustomRoleHomePageTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeTemplatePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRole_TemplatePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleTemplatePrivilege");
            this.getJRoleTemplatePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleTemplatePrivilege");
            this.getSRoleTemplatePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeDataConnectionPrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRole_DataConnectionPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleDataConnectionPrivilege");
            this.getJRoleDataConnectionPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRole_DataConnectionPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleDataConnectionPrivilege");
            this.getSRoleDataConnectionPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeDepAndCRolePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.companyRole_DepAndCRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("CompanyRoleDepAndCRolePrivilege");
            this.getCompanyRoleDepAndCRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.customRole_DepAndCRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("CustomRoleDepAndCRolePrivilege");
            this.getCustomRoleDepAndCRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeESPrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRoleESPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleESPrivilege");
            this.getJRoleESPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRoleESPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleESPrivilege");
            this.getSRoleESPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeCustomPlate(XMLPrintWriter xMLPrintWriter) {
        if (this.customRole_PlateTableData != null) {
            xMLPrintWriter.startTAG("CustomRolesWithPlate");
            for (String string : this.customRole_PlateTableData.keySet()) {
                xMLPrintWriter.startTAG("CustomRoleWithPlate");
                xMLPrintWriter.startTAG("PlateName").textNode(string).end();
                xMLPrintWriter.startTAG("EmbededTableData");
                this.getCustomRoleTableDataByPlateName(string).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    private void writeCompanyPlate(XMLPrintWriter xMLPrintWriter) {
        if (this.companyRole_PlateTableData != null) {
            xMLPrintWriter.startTAG("CompanyRolesWithPlate");
            for (String string : this.customRole_PlateTableData.keySet()) {
                xMLPrintWriter.startTAG("CompanyRoleWithPlate");
                xMLPrintWriter.startTAG("PlateName").textNode(string).end();
                xMLPrintWriter.startTAG("EmbededTableData");
                this.getCompanyRoleTableDataByPlateName(string).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    private void writeBI(XMLPrintWriter xMLPrintWriter) {
        if (this.BIReportTableData != null) {
            xMLPrintWriter.startTAG("BIReport");
            this.getBIReportTabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.BISharedReportTableData != null) {
            xMLPrintWriter.startTAG("BISharedReport");
            this.getBISharedReportTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public static class ColumnColumn {
        private String name;
        private Class clazz;

        public ColumnColumn(String string, Class clazz) {
            this.setName(string);
            this.setClazz(clazz);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }
    }

    private static final class BISharedReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("bid", String.class), new ColumnColumn("userId", String.class)};

        private BISharedReportTable() {
        }
    }

    private static final class BIReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("path", String.class), new ColumnColumn("reportName", String.class), new ColumnColumn("createTime", Date.class), new ColumnColumn("modifyTime", Date.class), new ColumnColumn("type", Integer.class), new ColumnColumn("description", String.class)};

        private BIReportTable() {
        }
    }

    private static final class ADHOCReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("path", String.class), new ColumnColumn("reportName", String.class), new ColumnColumn("createTime", DATE.class), new ColumnColumn("description", String.class)};

        private ADHOCReportTable() {
        }
    }

    private static final class FavoriteNodeTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("entryid", String.class)};

        private FavoriteNodeTable() {
        }
    }

    private static final class Role_HomePageTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("homepageid", String.class), new ColumnColumn("view", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private Role_HomePageTable() {
        }
    }

    private static final class Role_ModuleTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("moduleid", String.class), new ColumnColumn("view", String.class), new ColumnColumn("authorized", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private Role_ModuleTable() {
        }
    }

    private static final class Role_DepAndCRolePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("deporcroleid", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private Role_DepAndCRolePrivilegeTable() {
        }
    }

    private static final class RoleDataConnectionPrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleId", String.class), new ColumnColumn("name", String.class), new ColumnColumn("view", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private RoleDataConnectionPrivilegeTable() {
        }
    }

    private static final class RoleTemplatePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleId", String.class), new ColumnColumn("path", String.class), new ColumnColumn("page", String.class), new ColumnColumn("write", String.class), new ColumnColumn("design", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private RoleTemplatePrivilegeTable() {
        }
    }

    private static final class RolePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("entryid", String.class), new ColumnColumn("view", String.class), new ColumnColumn("authorized", String.class), new ColumnColumn("edit", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add((Object[])COMPANYCOLUMNS, (Object)new ColumnColumn("srolename", String.class));

        private RolePrivilegeTable() {
        }
    }

    private static final class SRole_UserTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("sroleid", String.class), new ColumnColumn("username", String.class), new ColumnColumn("srolename", String.class)};

        private SRole_UserTable() {
        }
    }

    private static final class SRoleTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("rolename", String.class), new ColumnColumn("description", String.class)};

        private SRoleTable() {
        }
    }

    private static final class JRoleTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("department", String.class), new ColumnColumn("post", String.class), new ColumnColumn("description", String.class), new ColumnColumn("departmentid", String.class), new ColumnColumn("dpMarkValue", String.class)};

        private JRoleTable() {
        }
    }

    private static final class CustomRoleForeignKeyToUserTable {
        private static final ColumnColumn[] USERCUSTOMROLERELATIONCOLUMN = new ColumnColumn[]{new ColumnColumn("userid", String.class), new ColumnColumn("customroleid", String.class)};

        private CustomRoleForeignKeyToUserTable() {
        }
    }

    private static final class CompanyRoleForeignKeyToUserTable {
        private static final ColumnColumn[] USERCOMPANYROLERELATIONCOLUMN = new ColumnColumn[]{new ColumnColumn("userid", String.class), new ColumnColumn("departmentid", String.class), new ColumnColumn("postid", String.class)};

        private CompanyRoleForeignKeyToUserTable() {
        }
    }

    private static final class UserTable {
        private static final ColumnColumn[] USERCOLUMN = new ColumnColumn[]{new ColumnColumn("userid", String.class), new ColumnColumn("username", String.class), new ColumnColumn("password", String.class), new ColumnColumn("name", String.class), new ColumnColumn("email", String.class), new ColumnColumn("mobile", String.class)};

        private UserTable() {
        }
    }

    private static final class DepartmentTable {
        private static final ColumnColumn[] DEPARTMENTCOLUMN = new ColumnColumn[]{new ColumnColumn("departmentid", String.class), new ColumnColumn("parentdepartmentid", String.class), new ColumnColumn("departmentname", String.class), new ColumnColumn("description", String.class)};

        private DepartmentTable() {
        }
    }

    private static final class PostTable {
        private static final ColumnColumn[] POSTCOLUMN = new ColumnColumn[]{new ColumnColumn("postname", String.class), new ColumnColumn("postid", String.class)};

        private PostTable() {
        }
    }
}

