/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleBean;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CompanyRoleCacheImpl;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.UserDataControl;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.web.FSConstants;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyRoleControl {
    private static CompanyRoleControl jc;
    private final IDLockCreator jroleDaoIDLockCreator = new IDLockCreator();
    private long DEPARTMENT_ALL = -5L;
    private long POST_ALL = -5L;

    public static CompanyRoleControl getInstance() {
        if (jc == null) {
            jc = new CompanyRoleControl();
        }
        return jc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDepartmentAllID() {
        if (this.DEPARTMENT_ALL == -1L) {
            throw new RuntimeException("[DEPARTMENT_ALL_ID] inited failed!");
        }
        if (this.DEPARTMENT_ALL >= 0L) {
            return this.DEPARTMENT_ALL;
        }
        String string = FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME;
        synchronized (string) {
            if (this.DEPARTMENT_ALL < -1L) {
                try {
                    DepartmentDAO departmentDAO = FSConfig.getProviderInstance().getControl().getDepartmentDAO();
                    Department department = departmentDAO.findByNameAndPid(FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, -2L);
                    long l = -1L;
                    if (department != null) {
                        l = department.getId();
                    }
                    if (l < 0L) {
                        FRContext.getLogger().error("Can not find no-check-department!");
                    } else {
                        this.DEPARTMENT_ALL = l;
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
                if (this.DEPARTMENT_ALL < 0L) {
                    ++this.DEPARTMENT_ALL;
                    throw new RuntimeException("[DEPARTMENT_ALL_ID] inited failed!");
                }
            }
            return this.DEPARTMENT_ALL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPostAllID() {
        if (this.POST_ALL == -1L) {
            throw new RuntimeException("[POST_ALL] inited failed!");
        }
        if (this.POST_ALL >= 0L) {
            return this.POST_ALL;
        }
        String string = FSConstants.COMPANYROLE.POST_ALL_NAME;
        synchronized (string) {
            if (this.POST_ALL < -1L) {
                try {
                    PostDAO postDAO = FSConfig.getProviderInstance().getControl().getPostDAO();
                    Post post = postDAO.findByPostName(FSConstants.COMPANYROLE.POST_ALL_NAME);
                    long l = -1L;
                    if (post != null) {
                        l = post.getId();
                    }
                    if (l < 0L) {
                        FRContext.getLogger().error("Can not find no-check-post!");
                    } else {
                        this.POST_ALL = l;
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
                if (this.POST_ALL < 0L) {
                    ++this.POST_ALL;
                    throw new RuntimeException("[POST_ALL] inited failed!");
                }
            }
            return this.POST_ALL;
        }
    }

    public List<CompanyRole> getAllCompanyRole() throws Exception {
        return CompanyRoleCacheImpl.getInstance().getAllCompanyRole();
    }

    public List<CustomRole> getAllCustomRole() throws Exception {
        return CustomRoleCacheImpl.getInstance().getAllCustomRole();
    }

    public String[] getAllCompanyRole4Designer() throws Exception {
        ArrayList<RoleBean> arrayList = new ArrayList<RoleBean>(128);
        arrayList.addAll(this.getAllCompanyRole());
        arrayList.addAll(this.getAllCustomRole());
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            RoleBean roleBean;
            Object e = arrayList.get(i);
            if (e instanceof CompanyRole) {
                roleBean = (CompanyRole)((Object)e);
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)roleBean).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)roleBean).getPostId());
                stringArray[i] = string + string2;
                continue;
            }
            roleBean = (CustomRole)((Object)e);
            stringArray[i] = ((CustomRole)roleBean).getRolename();
        }
        return stringArray;
    }

    public JSONArray getAllCompanyRoleInfoWithDepAll() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<CompanyRole> list = this.getAllCompanyRole();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompanyRole companyRole = list.get(i);
                JSONObject jSONObject = companyRole.createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", (Object)string);
                jSONObject.put("postname", (Object)string2);
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONArray getAllCompanyRoleInfo() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<CompanyRole> list = this.getAllCompanyRole();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompanyRole companyRole = list.get(i);
                if (companyRole.getDepartmentId() == CompanyRoleControl.getInstance().getDepartmentAllID() || companyRole.getPostId() == CompanyRoleControl.getInstance().getPostAllID()) continue;
                JSONObject jSONObject = companyRole.createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", (Object)string);
                jSONObject.put("postname", (Object)string2);
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONObject getAllPostitonRoleInfoByDepartment(long l) throws Exception {
        long l2 = this.getPostAllID();
        return this.getOrCreateAllRole(l, l2).createJSONConfig();
    }

    public JSONObject getAllDepartmentRoleInfoByPosition(long l) throws Exception {
        long l2 = this.getDepartmentAllID();
        return this.getOrCreateAllRole(l2, l).createJSONConfig();
    }

    public CompanyRole getOrCreateAllRole(long l, long l2) throws Exception {
        List<CompanyRole> list = this.getJRole(l, l2);
        CompanyRole companyRole = null;
        for (CompanyRole companyRole2 : list) {
            if (companyRole2.getDepartmentId() != l || companyRole2.getPostId() != l2) continue;
            companyRole = companyRole2;
            break;
        }
        if (companyRole == null && (l == this.getDepartmentAllID() || l2 == this.getPostAllID())) {
            companyRole = new CompanyRole(l2, l, "");
            this.addCompanyRole(companyRole);
        }
        return companyRole;
    }

    public List<CompanyRole> getJRole(long l, long l2) throws Exception {
        if (l2 >= 0L && l2 != this.getPostAllID() && l >= 0L && l != this.getDepartmentAllID()) {
            Long[] longArray;
            ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
            Long[] longArray2 = DepartmentControl.getInstance().getDepartmentIDPath(l);
            if (longArray2 == null) {
                longArray = new Long[1];
            } else {
                longArray = new Long[longArray2.length + 1];
                for (int i = 0; i < longArray2.length; ++i) {
                    longArray[i] = longArray2[i];
                }
            }
            longArray[longArray.length - 1] = new Long(this.getDepartmentAllID());
            Long[] longArray3 = new Long[]{l, new Long(this.getDepartmentAllID())};
            List<CompanyRole> list = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(new Long(l2), longArray3);
            if (list != null) {
                arrayList.addAll(list);
            }
            if ((list = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(new Long(this.getPostAllID()), longArray)) != null) {
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if (l2 == CompanyRoleControl.getInstance().getPostAllID() || l == CompanyRoleControl.getInstance().getDepartmentAllID()) {
            Long[] longArray = new Long[]{l};
            return FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(l2, longArray);
        }
        return null;
    }

    public CompanyRole getJRole(long l) throws Exception {
        if (l < 0L) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByID(l);
    }

    public long addCompanyRole4WithPlateName(CompanyRole companyRole, Set set, String string) throws Exception {
        if (companyRole.getId() > 0L || this.addCompanyRole(companyRole)) {
            if (set != null) {
                List<Long> list = Arrays.asList(set.toArray(new Long[set.size()]));
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updatePlatePrivileges(companyRole.getId(), list, null, string);
                try {
                    CompanyRoleCacheImpl.getInstance().refreshPrivilegesWithPlateName(companyRole.getId(), FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getPrivilegesWithPlateName(companyRole.getId(), string), string);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    CompanyRoleCacheImpl.getInstance().reInitCache();
                }
            }
            return companyRole.getId();
        }
        return -1L;
    }

    public long addCompanyRole(CompanyRole companyRole, Set<RoleModulePrivilege> set, Set<EntryTypeAndID> set2, Set<String> set3) throws Exception {
        companyRole.setId(-1L);
        if (this.addCompanyRole(companyRole)) {
            List<Object> list;
            if (set != null) {
                list = Arrays.asList(set.toArray(new RoleModulePrivilege[set.size()]));
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateModulePrivileges(companyRole.getId(), list, null);
                try {
                    CompanyRoleCacheImpl.getInstance().refreshModulePrivileges(companyRole.getId(), FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getModulePrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    CompanyRoleCacheImpl.getInstance().reInitCache();
                }
            }
            if (set2 != null) {
                list = Arrays.asList(set2.toArray(new EntryTypeAndID[set2.size()]));
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateEntryPrivileges(companyRole.getId(), list, null);
                try {
                    CompanyRoleCacheImpl.getInstance().refreshEntryPrivileges(companyRole.getId(), FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getEntryPrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    CompanyRoleCacheImpl.getInstance().reInitCache();
                }
            }
            if (set3 != null) {
                list = Arrays.asList(set3.toArray(new String[set3.size()]));
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateDepAndCrolePrivilege(companyRole.getId(), list, null);
                try {
                    CompanyRoleCacheImpl.getInstance().refreshDepAndCrolePrivileges(companyRole.getId(), FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getDepAndCrolePrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                    CompanyRoleCacheImpl.getInstance().reInitCache();
                }
            }
            return companyRole.getId();
        }
        return -1L;
    }

    public boolean addCompanyRole(CompanyRole companyRole) throws Exception {
        if (companyRole == null) {
            return false;
        }
        companyRole.setId(-1L);
        FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().save(companyRole);
        if (companyRole.getId() >= 0L) {
            try {
                CompanyRoleCacheImpl.getInstance().cacheNew(companyRole);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                CompanyRoleCacheImpl.getInstance().reInitCache();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCompanyRole(long l) throws Exception {
        boolean bl;
        if (l < 0L) {
            return false;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        List<EntryTypeAndID> list = CompanyRoleControl.getInstance().getAllEntryPrivileges(l);
        List<RoleModulePrivilege> list2 = CompanyRoleControl.getInstance().getAllModulePrivileges(l);
        List<String> list3 = CompanyRoleCacheImpl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
        if (list.size() > 0) {
            CompanyRoleControl.getInstance().updateEntryPrivileges(l, null, new HashSet<EntryTypeAndID>(list));
        }
        if (list2.size() > 0) {
            CompanyRoleControl.getInstance().updateModulePrivileges(l, null, new HashSet<RoleModulePrivilege>(list2));
        }
        if (list3.size() > 0) {
            CompanyRoleControl.getInstance().updateDepAndCRolePrivileges(l, null, new HashSet<String>(list3));
        }
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().deleteByID(l);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        if (bl) {
            try {
                CompanyRoleCacheImpl.getInstance().removeCache(l);
            }
            catch (Exception exception) {
                CompanyRoleCacheImpl.getInstance().reInitCache();
            }
            try {
                UserCacheImpl.getInstance().refreshAfterDeleteCompanyRole(l);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                UserCacheImpl.getInstance().removeAllCache();
            }
        }
        return bl;
    }

    public boolean updateDepartmentAndPost(long l, long l2, long l3) throws Exception {
        return this.updateDepartAndPostWithDescription(l, l2, l3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDepartAndPostWithDescription(long l, long l2, long l3, String string) throws Exception {
        boolean bl;
        if (l < 0L) {
            return false;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        CompanyRole companyRole = null;
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().update(l, new Department(l2), new Post(l3), string);
                if (bl) {
                    companyRole = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findByID(l);
                }
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        if (bl) {
            try {
                UserCacheImpl.getInstance().refreshAfterUpdateJRole(companyRole);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                UserCacheImpl.getInstance().removeAllCache();
            }
        }
        return bl;
    }

    public List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllEntryPrivileges(l);
    }

    public List<JSONObject> getAllEntryPrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<EntryTypeAndID> list = this.getAllEntryPrivileges(l);
        for (EntryTypeAndID entryTypeAndID : list) {
            try {
                arrayList.add(entryTypeAndID.toJSONObject());
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return arrayList;
    }

    public List<String> getAllESPrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllESPrivilegeDescriptions(l);
    }

    public List<JSONObject> getAllModulePrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<RoleModulePrivilege> list = this.getAllModulePrivileges(l);
        for (RoleModulePrivilege roleModulePrivilege : list) {
            arrayList.add(roleModulePrivilege.toJSONObject());
        }
        return arrayList;
    }

    public List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllModulePrivileges(l);
    }

    public List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllHomePagePrivileges(l);
    }

    public List<String> getAllDepAndCRolePrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
    }

    public List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllTemplatePrivileges(l);
    }

    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        return CompanyRoleCacheImpl.getInstance().getAllDataConnectionPrivileges(l);
    }

    public JSONArray getAllDepAndCRoleInfo(long l) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<RoleDepAndCRolePrivilege> list = CompanyRoleCacheImpl.getInstance().getAllDepAndCRolePrivileges(l);
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : list) {
            RoleBean roleBean;
            if (roleDepAndCRolePrivilege.getType() == 1) {
                roleBean = CompanyRoleControl.getInstance().getJRole(roleDepAndCRolePrivilege.getRoleid());
                JSONObject jSONObject = ((CompanyRole)roleBean).createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)roleBean).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)roleBean).getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", (Object)string);
                jSONObject.put("postname", (Object)string2);
                jSONArray.put((Object)jSONObject);
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == 2) {
                roleBean = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getRoleid());
                jSONArray.put((Object)((CustomRole)roleBean).createJSONConfig());
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == -1) {
                roleBean = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
                int n = roleBean.length();
                for (int i = 0; i < n; ++i) {
                    jSONArray.put(roleBean.get(i));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != -2) continue;
            roleBean = CustomRoleControl.getInstance().getAllCustomRoleInfo();
            int n = roleBean.length();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(roleBean.get(i));
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulePrivileges(long l, Set<RoleModulePrivilege> set, Set<RoleModulePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleModulePrivilege> arrayList2 = new ArrayList<RoleModulePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateModulePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshModulePrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getModulePrivileges(l));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set, Set<RoleHomePagePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleHomePagePrivilege> arrayList2 = new ArrayList<RoleHomePagePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateHomePagePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshHomePagePrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getHomePagePrivileges(l));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set, Set<RoleTemplatePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleTemplatePrivilege> arrayList2 = new ArrayList<RoleTemplatePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateTemplatePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshTemplatePrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getTemplatePrivileges(l));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    public void removeAllTemplatePrivileges() throws Exception {
        FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().removeAllTemplatePrivileges();
    }

    public void removeTemplatePrivileges(long l) throws Exception {
        FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().removeTemplatePrivileges(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateEntryPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshEntryPrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getEntryPrivileges(l));
        }
        catch (Exception exception) {
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDepAndCRolePrivileges(long l, Set<String> set, Set<String> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateDepAndCrolePrivilege(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshDepAndCrolePrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getDepAndCrolePrivileges(l));
        }
        catch (Exception exception) {
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataConnectionPrivileges(long l, Set<String> set, Set<String> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateDataConnectionPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshDataConnectionPrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getDataConnectionPrivileges(l));
        }
        catch (Exception exception) {
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateESPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        Object object = this.jroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().updateESPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CompanyRoleCacheImpl.getInstance().refreshESPrivileges(l, FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getESPrivileges(l));
        }
        catch (Exception exception) {
            CompanyRoleCacheImpl.getInstance().reInitCache();
        }
    }

    public Set getUsersID(long l) throws Exception {
        UserDataControl userDataControl = FSConfig.getProviderInstance().getControl();
        if (userDataControl.getControlType() == 1) {
            CompanyRole companyRole = this.getJRole(l);
            if (companyRole == null) {
                return new HashSet();
            }
            return UserControl.getInstance().getDepartPostUsers(companyRole.getDepartmentId(), companyRole.getPostId());
        }
        return UserControl.getInstance().getUsersByJRoleID(l);
    }

    public Set<CompanyRole> getCompanyRoleSet(long l) throws Exception {
        HashSet<CompanyRole> hashSet = new HashSet<CompanyRole>();
        Set<Long> set = UserControl.getInstance().getAllCompanyRoleIDs(l);
        if (set != null) {
            for (long l2 : set) {
                CompanyRole companyRole = CompanyRoleControl.getInstance().getJRole(l2);
                if (companyRole == null) continue;
                hashSet.add(companyRole);
            }
        }
        return hashSet;
    }

    public void reset() {
        jc = null;
    }
}

