/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache.tabledata;

import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.tabledata.DepartmentNameAndPostName;
import com.fr.fs.cache.tabledata.TableDataDAOBean;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataUser
extends TableDataDAOBean
implements Cloneable {
    private String userName;
    private String password;
    private String department;
    private Long departmentPid;
    private String post;
    private String name;
    private String email;
    private String mobile;
    private String role;
    private Set sroles = new CopyOnWriteArraySet();
    private Set jobs = new CopyOnWriteArraySet();
    private Set<String> customRoleSet = new HashSet<String>();
    private Set<DepartmentNameAndPostName> companyRoleSet = new HashSet<DepartmentNameAndPostName>();

    public TableDataUser(long l, String string, String string2) {
        this.setId(l);
        this.setUserName(string);
        this.setPassword(string2);
    }

    public User getUser() {
        User user = new User(this.id);
        user.setUsername(this.userName);
        user.setPassword(this.password);
        user.setRealname(this.name);
        user.setEmail(this.email);
        user.setMobile(this.mobile);
        return user;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setMobile(String string) {
        this.mobile = string;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public String getEmail() {
        return this.email;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getPostValue() {
        return this.post;
    }

    public void setPostValue(String string) {
        this.post = string;
    }

    public String getDepartmentValue() {
        return this.department;
    }

    public void setDepartmentValue(String string) {
        this.department = string;
    }

    public Long getDepartmentPid() {
        return this.departmentPid;
    }

    public void setDepartmentPid(Long l) {
        this.departmentPid = l;
    }

    public String getRoleValue() {
        return this.role;
    }

    public void setRoleValue(String string) {
        this.role = string;
    }

    public void addSrole(String string) throws CloneNotSupportedException {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        CustomRole customRole = TableDataSyncDB.getInstance().findSRoleBySRoleName(string);
        if (customRole != null) {
            this.sroles.add(customRole);
        }
    }

    public Iterator getSroleIterator() {
        return this.sroles.iterator();
    }

    public void addJob(String string, String string2, Long l) throws CloneNotSupportedException {
        Job job = new Job(TableDataSyncDB.getInstance().findDepartmentByDPNameAndPid(string, l).getId(), TableDataSyncDB.getInstance().findPostByPostName(string2).getId());
        this.jobs.add(job);
    }

    public Iterator getJobIterator() {
        return this.jobs.iterator();
    }

    public void removeJob(long l, long l2) {
        for (Object e : this.jobs) {
            Job job = (Job)e;
            if (!ComparatorUtils.equals((Object)l, (Object)job.getDepartmentID()) || !ComparatorUtils.equals((Object)l2, (Object)job.getPostID())) continue;
            this.jobs.remove(e);
            return;
        }
    }

    public void removeSrole(long l) {
        for (Object e : this.sroles) {
            CustomRole customRole = (CustomRole)((Object)e);
            if (!ComparatorUtils.equals((Object)l, (Object)customRole.getId())) continue;
            this.sroles.remove(e);
            return;
        }
    }

    public Set<String> getCustomRoleSet() {
        return this.customRoleSet;
    }

    public void addCompanyRole(String string, String string2) {
        this.companyRoleSet.add(new DepartmentNameAndPostName(string, string2));
    }

    public Set<DepartmentNameAndPostName> getCompanyRoleSet() {
        return this.companyRoleSet;
    }

    public void addCustomRole(String string) {
        this.customRoleSet.add(string);
    }
}

