/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.base.FRContext;
import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.dao.UserDeviceDao;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.SortedJSONObject;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDeviceInfoCache {
    private static UserDeviceDao uDao = UserDeviceDao.getInstance();
    private static Map<String, List<UserDeviceInfo>> USER_DEVICE_MAP = new ConcurrentHashMap<String, List<UserDeviceInfo>>();

    static void checkInit() {
        if (USER_DEVICE_MAP.isEmpty()) {
            try {
                UserDeviceInfoCache.initUserDeviceInfoCache();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initUserDeviceInfoCache() throws Exception {
        Map<String, List<UserDeviceInfo>> map = USER_DEVICE_MAP;
        synchronized (map) {
            try {
                HashSet<String> hashSet = new HashSet<String>();
                List<UserDeviceInfo> list = uDao.findAll();
                for (UserDeviceInfo object : list) {
                    hashSet.add(object.getUsername());
                }
                for (String string : hashSet) {
                    USER_DEVICE_MAP.put(string, uDao.findByUserName(string));
                }
            }
            catch (Exception exception) {
                USER_DEVICE_MAP.clear();
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map<String, List<UserDeviceInfo>> map = USER_DEVICE_MAP;
        synchronized (map) {
            USER_DEVICE_MAP.clear();
            UserDeviceInfoCache.initUserDeviceInfoCache();
        }
    }

    public static boolean containCache(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        UserDeviceInfoCache.checkInit();
        return USER_DEVICE_MAP.containsKey(string);
    }

    public static long getDeviceId(UserDeviceInfo userDeviceInfo) {
        if (userDeviceInfo == null) {
            return -1L;
        }
        UserDeviceInfoCache.checkInit();
        List<UserDeviceInfo> list = UserDeviceInfoCache.getAllUserDeviceInfoByName(userDeviceInfo.getUsername());
        for (UserDeviceInfo userDeviceInfo2 : list) {
            if (!UserDeviceInfoCache.isMacAddressMatch(userDeviceInfo2.getMacAddress(), userDeviceInfo.getMacAddress())) continue;
            return userDeviceInfo2.getId();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UserDeviceInfo> getAllUserDeviceInfoByName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return new ArrayList<UserDeviceInfo>(0);
        }
        UserDeviceInfoCache.checkInit();
        Map<String, List<UserDeviceInfo>> map = USER_DEVICE_MAP;
        synchronized (map) {
            return USER_DEVICE_MAP.containsKey(string) ? USER_DEVICE_MAP.get(string) : new ArrayList(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getAllUserDeviceJsonByName(String string) throws JSONException {
        if (StringUtils.isEmpty((String)string)) {
            return JSONArray.create();
        }
        UserDeviceInfoCache.checkInit();
        Map<String, List<UserDeviceInfo>> map = USER_DEVICE_MAP;
        synchronized (map) {
            JSONArray jSONArray = JSONArray.create();
            for (UserDeviceInfo userDeviceInfo : UserDeviceInfoCache.getAllUserDeviceInfoByName(string)) {
                jSONArray.put((Object)userDeviceInfo.toJSONObject());
            }
            return jSONArray;
        }
    }

    public static synchronized void cache(UserDeviceInfo userDeviceInfo) {
        if (userDeviceInfo == null) {
            return;
        }
        UserDeviceInfoCache.checkInit();
        List<UserDeviceInfo> list = USER_DEVICE_MAP.get(userDeviceInfo.getUsername());
        if (list != null) {
            boolean bl = true;
            for (UserDeviceInfo userDeviceInfo2 : list) {
                if (!UserDeviceInfoCache.isMacAddressMatch(userDeviceInfo.getMacAddress(), userDeviceInfo2.getMacAddress())) continue;
                userDeviceInfo2.setDeviceName(userDeviceInfo.getDeviceName());
                userDeviceInfo2.setPassed(userDeviceInfo.isPassed());
                bl = false;
            }
            if (bl) {
                list.add(userDeviceInfo);
            }
        } else {
            list = new ArrayList<UserDeviceInfo>();
            list.add(userDeviceInfo);
            USER_DEVICE_MAP.put(userDeviceInfo.getUsername(), list);
        }
    }

    public static synchronized void removeCache(String string) {
        if (string == null) {
            return;
        }
        if (USER_DEVICE_MAP.containsKey(string)) {
            USER_DEVICE_MAP.remove(string);
        }
    }

    public static synchronized void removeSingleCache(UserDeviceInfo userDeviceInfo) {
        if (userDeviceInfo == null) {
            return;
        }
        List<UserDeviceInfo> list = USER_DEVICE_MAP.get(userDeviceInfo.getUsername());
        if (list != null) {
            list.remove((Object)userDeviceInfo);
        } else {
            USER_DEVICE_MAP.remove(userDeviceInfo.getUsername());
        }
    }

    public static synchronized JSONObject getSortedUserDeviceJSONObject() throws JSONException {
        UserDeviceInfoCache.checkInit();
        SortedJSONObject sortedJSONObject = SortedJSONObject.create();
        TreeMap<String, List<UserDeviceInfo>> treeMap = new TreeMap<String, List<UserDeviceInfo>>(new AlphabetDeviceComparator(FRContext.getLocale()));
        treeMap.putAll(USER_DEVICE_MAP);
        for (Map.Entry entry : treeMap.entrySet()) {
            JSONArray jSONArray = JSONArray.create();
            for (UserDeviceInfo userDeviceInfo : (List)entry.getValue()) {
                jSONArray.put((Object)userDeviceInfo.toJSONObject());
            }
            sortedJSONObject.put((String)entry.getKey(), (Object)jSONArray);
        }
        return sortedJSONObject;
    }

    public static synchronized boolean updateByMacAddress(UserDeviceInfo userDeviceInfo) {
        if (userDeviceInfo == null) {
            return false;
        }
        List<UserDeviceInfo> list = USER_DEVICE_MAP.get(userDeviceInfo.getUsername());
        for (UserDeviceInfo userDeviceInfo2 : list) {
            if (!UserDeviceInfoCache.isMacAddressMatch(userDeviceInfo2.getMacAddress(), userDeviceInfo.getMacAddress())) continue;
            userDeviceInfo.setPassed(userDeviceInfo.isPassed());
            return true;
        }
        return false;
    }

    public static synchronized boolean unbind(String string, String string2, boolean bl) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        if (StringUtils.isBlank((String)string2)) {
            List<UserDeviceInfo> list = UserDeviceInfoCache.getAllUserDeviceInfoByName(string);
            Iterator<UserDeviceInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                UserDeviceInfo userDeviceInfo = iterator.next();
                if (userDeviceInfo.isPassed() != bl) continue;
                iterator.remove();
            }
            return true;
        }
        List<UserDeviceInfo> list = UserDeviceInfoCache.getAllUserDeviceInfoByName(string);
        for (UserDeviceInfo userDeviceInfo : list) {
            if (!UserDeviceInfoCache.isMacAddressMatch(userDeviceInfo.getMacAddress(), string2)) continue;
            list.remove((Object)userDeviceInfo);
            return true;
        }
        return false;
    }

    public static synchronized void bind(String string, String string2, String string3) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        UserDeviceInfoCache.checkInit();
        if (StringUtils.isBlank((String)string2)) {
            List<UserDeviceInfo> list = UserDeviceInfoCache.getAllUserDeviceInfoByName(string);
            for (UserDeviceInfo userDeviceInfo : list) {
                userDeviceInfo.setPassed(true);
            }
            return;
        }
        List<UserDeviceInfo> list = UserDeviceInfoCache.getAllUserDeviceInfoByName(string);
        for (UserDeviceInfo userDeviceInfo : list) {
            if (!UserDeviceInfoCache.isMacAddressMatch(userDeviceInfo.getMacAddress(), string2)) continue;
            userDeviceInfo.setPassed(true);
            userDeviceInfo.setDeviceName(string3);
            return;
        }
        UserDeviceInfoCache.cache(new UserDeviceInfo(string, string2, string3, true));
    }

    public static Set<String> getAllUsers() {
        UserDeviceInfoCache.checkInit();
        return USER_DEVICE_MAP.keySet();
    }

    private static boolean isMacAddressMatch(String string, String string2) {
        return ComparatorUtils.equalsIgnoreCase((String)string, (String)string2);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                USER_DEVICE_MAP.clear();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AlphabetDeviceComparator
    implements Comparator<String>,
    Serializable {
        private RuleBasedCollator collator = null;

        public AlphabetDeviceComparator() {
            this.collator = (RuleBasedCollator)Collator.getInstance(Locale.CHINA);
        }

        public AlphabetDeviceComparator(Locale locale) {
            this.collator = (RuleBasedCollator)Collator.getInstance(locale);
        }

        @Override
        public int compare(String string, String string2) {
            CollationKey collationKey = this.collator.getCollationKey(string);
            CollationKey collationKey2 = this.collator.getCollationKey(string2);
            return this.collator.compare(collationKey.getSourceString(), collationKey2.getSourceString());
        }
    }
}

