/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleCacheInfo {
    protected String name = null;
    private long sortIndex = 0L;
    protected Set<EntryTypeAndID> entryPrivilegeSet = new HashSet<EntryTypeAndID>();
    protected Set<EntryTypeAndID> ESPrivilegeSet = new HashSet<EntryTypeAndID>();
    protected Set<RoleModulePrivilege> moduleSet = new HashSet<RoleModulePrivilege>();
    protected Set<RoleHomePagePrivilege> homePagePrivilegeSet = new HashSet<RoleHomePagePrivilege>();
    protected Set<RoleDepAndCRolePrivilege> deptAndCustomRolePrivilegeSet;
    protected Set<RoleTemplatePrivilege> templateSet;
    protected Set<RoleDataConnectionPrivilege> dataConnectionSet;
    private Map<String, Set<String>> platePrivilegeMap = new ConcurrentHashMap<String, Set<String>>();

    public RoleCacheInfo() {
        this.deptAndCustomRolePrivilegeSet = new HashSet<RoleDepAndCRolePrivilege>();
        this.templateSet = new HashSet<RoleTemplatePrivilege>();
        this.dataConnectionSet = new HashSet<RoleDataConnectionPrivilege>();
    }

    public long getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(long l) {
        this.sortIndex = l;
    }

    public void addPrivileges4Plates(long l, boolean bl) throws Exception {
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            Set<RelationObject> set;
            String string = iterator.next();
            if (!PlateFactory.getPlateByName(string).needPrivilege() || (set = bl ? FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().getPrivilegesWithPlateName(l, string) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getPrivilegesWithPlateName(l, string)) == null) continue;
            Iterator<RelationObject> iterator2 = set.iterator();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (iterator2.hasNext()) {
                RelationObject relationObject = iterator2.next();
                hashSet.add(relationObject.getValue(PlateFactory.getRelationClassByName(string)));
            }
            this.platePrivilegeMap.put(string, hashSet);
        }
    }

    public void addPlatePrivileges(RelationObject relationObject, String string) {
        Set<String> set = this.platePrivilegeMap.get(string);
        set.add((String)relationObject.getValue(PlateFactory.getRelationClassByName(string)));
    }

    public Set<String> getPlatePrivilege(String string) {
        return this.platePrivilegeMap.get(string);
    }

    public boolean containPlatePrivilege(long l, String string) {
        Set<String> set = this.platePrivilegeMap.get(string);
        return set != null && set.contains(new Long(l));
    }

    public void clearPlatePrivileges(String string) {
        Set<String> set = this.platePrivilegeMap.get(string);
        if (set != null) {
            set.clear();
        }
    }
}

