/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSPlate;
import com.fr.fs.PlateFactory;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.dao.FileEntryDAO;
import com.fr.fs.dao.FolderEntryDAO;
import com.fr.fs.dao.ReportProcessEntryDAO;
import com.fr.fs.dao.ReportletEntryDAO;
import com.fr.fs.dao.URLEntryDAO;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.stable.EnvChangedListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCache {
    public static final long ROOT_FOLDER_ID = -1L;
    private static FolderEntryDAO folderDao = FolderEntryDAO.getInstance();
    private static ReportletEntryDAO reportletDao = ReportletEntryDAO.getInstance();
    private static FileEntryDAO fileDao = FileEntryDAO.getInstance();
    private static URLEntryDAO urlDao = URLEntryDAO.getInstance();
    private static ReportProcessEntryDAO ReportProcessEntryDao = ReportProcessEntryDAO.getInstance();
    private static EntryTreeFolderNode root;
    private static final Map<EntryTypeAndID, Object> LISTMAP;
    private static final long ROOT_PARENTFOLDER_ID = -100L;

    private static void initRoot() {
        String string = "FS-Report_Management-Directory";
        FolderEntry folderEntry = new FolderEntry(Inter.getLocText((String)string), "This is the root.", string);
        folderEntry.setId(-1L);
        folderEntry.setParentId(-2L);
        folderEntry.setMobileDeviceConfig(7L);
        folderEntry.setParentDeviceConfig(7L);
        root = new EntryTreeFolderNode(folderEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initCacheTree() throws Exception {
        Map<EntryTypeAndID, Object> map = LISTMAP;
        synchronized (map) {
            if (LISTMAP.isEmpty()) {
                try {
                    LISTMAP.put(EntryTypeAndID.getInstance(0, -1L), root);
                    List list = folderDao.findAll();
                    List list2 = reportletDao.findAll();
                    List list3 = fileDao.findAll();
                    List list4 = urlDao.findAll();
                    List list5 = ReportProcessEntryDao.findAll();
                    ArrayList<Entry> arrayList = new ArrayList<Entry>();
                    if (list != null) {
                        FolderEntry folderEntry;
                        int n;
                        int n2 = list.size();
                        for (n = 0; n < n2; ++n) {
                            folderEntry = (FolderEntry)list.get(n);
                            LISTMAP.put(EntryTypeAndID.getInstance(0, folderEntry.getId()), new EntryTreeFolderNode(folderEntry));
                        }
                        n2 = list.size();
                        for (n = 0; n < n2; ++n) {
                            folderEntry = (FolderEntry)list.get(n);
                            EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, folderEntry.getParentId()));
                            if (entryTreeFolderNode != null) {
                                entryTreeFolderNode.addFolder(folderEntry.getId(), (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, folderEntry.getId())));
                                continue;
                            }
                            arrayList.add(folderEntry);
                        }
                        EntryCache.addEntry(list2, arrayList);
                        EntryCache.addEntry(list3, arrayList);
                        EntryCache.addEntry(list4, arrayList);
                        EntryCache.addEntryByPlate(arrayList);
                        EntryCache.addEntry(list5, arrayList);
                    }
                }
                catch (Exception exception) {
                    LISTMAP.clear();
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map<EntryTypeAndID, Object> map = LISTMAP;
        synchronized (map) {
            EntryCache.clearEntryCache();
            EntryCache.initCacheTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEntryCache() {
        Map<EntryTypeAndID, Object> map = LISTMAP;
        synchronized (map) {
            EntryCache.initRoot();
            LISTMAP.clear();
        }
    }

    private static void addEntryByPlate(List<Entry> list) throws Exception {
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            FSPlate fSPlate = PlateFactory.getPlateByName(iterator.next());
            List<EntryDAO> list2 = fSPlate.getEntryDaoAccess();
            if (list2 == null) continue;
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                EntryDAO entryDAO = list2.get(i);
                EntryCache.addEntry(entryDAO.findAll(), list);
            }
        }
    }

    private static void addEntry(List<?> list, List<Entry> list2) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Entry entry = (Entry)list.get(i);
                EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entry.getParentId()));
                if (entryTreeFolderNode != null) {
                    entryTreeFolderNode.addNode(entry);
                    LISTMAP.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entry);
                    continue;
                }
                list2.add(entry);
            }
        }
    }

    public static EntryTreeFolderNode getRootNode() {
        return root;
    }

    public static EntryTreeFolderNode getFolderTreeNode(long l) {
        if (l < -1L) {
            return null;
        }
        EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, l));
        return entryTreeFolderNode;
    }

    public static long getParentFolderID(int n, long l) {
        if (l < 0L) {
            return -100L;
        }
        Object object = LISTMAP.get(EntryTypeAndID.getInstance(n, l));
        if (object == null) {
            return -100L;
        }
        if (n == 0) {
            return ((EntryTreeFolderNode)object).getFolderParentID();
        }
        return ((Entry)object).getParentId();
    }

    public static Entry getCacheEntry(int n, long l) {
        if (l < -1L) {
            return null;
        }
        if (n == 0) {
            EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(n, l));
            if (entryTreeFolderNode != null) {
                return entryTreeFolderNode.getLClonedFolderEntry();
            }
            return null;
        }
        try {
            BaseEntry baseEntry = (BaseEntry)LISTMAP.get(EntryTypeAndID.getInstance(n, l));
            if (baseEntry != null) {
                return (Entry)baseEntry.clone();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public static synchronized boolean cache(Entry entry) {
        if (entry == null || entry.getId() < 0L) {
            return false;
        }
        if (entry instanceof FolderEntry) {
            EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
            if (entryTreeFolderNode == null) {
                EntryTreeFolderNode entryTreeFolderNode2 = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entry.getParentId()));
                if (entryTreeFolderNode2 != null) {
                    entryTreeFolderNode = new EntryTreeFolderNode((FolderEntry)entry);
                    entryTreeFolderNode2.addFolder(entry.getId(), entryTreeFolderNode);
                    LISTMAP.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entryTreeFolderNode);
                    return true;
                }
                return false;
            }
            if (entryTreeFolderNode.getFolderParentID() != entry.getParentId()) {
                throw new RuntimeException("Can not update parent-folder!");
            }
            entryTreeFolderNode.setFolder((FolderEntry)entry);
            return true;
        }
        Entry entry2 = (Entry)LISTMAP.get(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
        if (entry2 == null) {
            EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entry.getParentId()));
            if (entryTreeFolderNode != null) {
                entryTreeFolderNode.addNode(entry);
                LISTMAP.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entry);
                return true;
            }
            return false;
        }
        if (entry2.getParentId() != entry.getParentId()) {
            throw new RuntimeException("Can not update parent-folder!");
        }
        EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entry.getParentId()));
        if (entryTreeFolderNode != null) {
            entryTreeFolderNode.removeNode(entry2);
            entryTreeFolderNode.addNode(entry);
            LISTMAP.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entry);
            return true;
        }
        LISTMAP.remove(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
        return false;
    }

    public static synchronized void removeCache(int n, long l) {
        if (l < 0L) {
            return;
        }
        if (n == 0) {
            EntryTreeFolderNode entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.remove(EntryTypeAndID.getInstance(n, l));
            if (entryTreeFolderNode != null) {
                List list = entryTreeFolderNode.removeAll();
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    Entry entry = (Entry)list.get(i);
                    LISTMAP.remove(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
                }
                EntryTreeFolderNode entryTreeFolderNode2 = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entryTreeFolderNode.getFolderParentID()));
                if (entryTreeFolderNode2 != null) {
                    entryTreeFolderNode2.removeFolderNode(l);
                }
            }
        } else {
            EntryTreeFolderNode entryTreeFolderNode;
            Entry entry = (Entry)LISTMAP.remove(EntryTypeAndID.getInstance(n, l));
            if (entry != null && (entryTreeFolderNode = (EntryTreeFolderNode)LISTMAP.get(EntryTypeAndID.getInstance(0, entry.getParentId()))) != null) {
                entryTreeFolderNode.removeNode(entry);
            }
        }
    }

    static {
        LISTMAP = new Hashtable<EntryTypeAndID, Object>(128);
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                EntryCache.clearEntryCache();
            }
        });
        EntryCache.initRoot();
    }
}

