/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.RelationObject;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CompanyRoleCacheProvider;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyRoleCacheImpl
implements CompanyRoleCacheProvider {
    private static CompanyRoleCacheProvider companyRoleCacheProvider;

    public static CompanyRoleCacheProvider getInstance() {
        if (companyRoleCacheProvider == null) {
            CompanyRoleCacheImpl.initCacheImpl();
        }
        return companyRoleCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                companyRoleCacheProvider = new CompanyRoleCacheImpl();
                RPC.registerSkeleton((Object)companyRoleCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                companyRoleCacheProvider = (CompanyRoleCacheProvider)RPC.getProxy(CompanyRoleCacheImpl.class, (String)string);
                break;
            }
            default: {
                companyRoleCacheProvider = new CompanyRoleCacheImpl();
            }
        }
    }

    @Override
    public List<CompanyRole> getAllCompanyRole() {
        return CompanyRoleCache.getAllCompanyRole();
    }

    @Override
    public boolean containCache(long l) {
        return CompanyRoleCache.containCache(l);
    }

    @Override
    public void initCache() throws Exception {
        CompanyRoleCache.initCache();
    }

    @Override
    public void reInitCache() throws Exception {
        CompanyRoleCache.reInitCache();
    }

    @Override
    public void clearCache() throws Exception {
        CompanyRoleCache.clearCache();
    }

    @Override
    public void cacheNew(CompanyRole companyRole) throws Exception {
        CompanyRoleCache.cacheNew(companyRole);
    }

    @Override
    public void removeCache(long l) {
        CompanyRoleCache.removeCache(l);
    }

    @Override
    public List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        return CompanyRoleCache.getAllEntryPrivileges(l);
    }

    @Override
    public List<String> getAllESPrivilegeDescriptions(long l) {
        return CompanyRoleCache.getAllESPrivilegeDescriptions(l);
    }

    @Override
    public List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        return CompanyRoleCache.getAllModulePrivileges(l);
    }

    @Override
    public List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        return CompanyRoleCache.getAllHomePagePrivileges(l);
    }

    @Override
    public List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        return CompanyRoleCache.getAllTemplatePrivileges(l);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        return CompanyRoleCache.getAllDataConnectionPrivileges(l);
    }

    @Override
    public List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        return CompanyRoleCache.getAllDepAndCRolePrivileges(l);
    }

    @Override
    public List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        return CompanyRoleCache.getAllDepAndCRolePrivilegeDescriptions(l);
    }

    @Override
    public List getAllPrivilegesWithPlateName(long l, String string) {
        return CompanyRoleCache.getAllPrivilegesWithPlateName(l, string);
    }

    @Override
    public boolean containModulePrivilege(long l, long l2) {
        return CompanyRoleCache.containModulePrivilege(l, l2);
    }

    @Override
    public boolean containHomePagePrivilege(long l, long l2) {
        return CompanyRoleCache.containHomePagePrivilege(l, l2);
    }

    @Override
    public boolean containEntryPrivilege(long l, int n, long l2) {
        return CompanyRoleCache.containEntryPrivilege(l, n, l2);
    }

    @Override
    public boolean containPlatePrivilege(long l, long l2, String string) {
        return CompanyRoleCache.containPlatePrivilege(l, l2, string);
    }

    @Override
    public void refreshModulePrivileges(long l, Set<RoleModulePrivilege> set) {
        CompanyRoleCache.refreshModulePrivileges(l, set);
    }

    @Override
    public void refreshHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set) {
        CompanyRoleCache.refreshHomePagePrivileges(l, set);
    }

    @Override
    public void refreshTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set) {
        CompanyRoleCache.refreshTemplatePrivileges(l, set);
    }

    @Override
    public void refreshEntryPrivileges(long l, Set<RoleEntryPrivilege> set) {
        CompanyRoleCache.refreshEntryPrivileges(l, set);
    }

    @Override
    public void refreshDepAndCrolePrivileges(long l, Set<RoleDepAndCRolePrivilege> set) {
        CompanyRoleCache.refreshDepAndCrolePrivileges(l, set);
    }

    @Override
    public void refreshDataConnectionPrivileges(long l, Set<RoleDataConnectionPrivilege> set) {
        CompanyRoleCache.refreshDataConnectionPrivileges(l, set);
    }

    @Override
    public void refreshESPrivileges(long l, Set<RoleESPrivilege> set) {
        CompanyRoleCache.refreshESPrivileges(l, set);
    }

    @Override
    public void refreshPrivilegesWithPlateName(long l, Set<RelationObject> set, String string) {
        CompanyRoleCache.refreshPrivilegesWithPlateName(l, set, string);
    }

    @Override
    public void refreshEntryPrivileges(long l, int n, long l2, long l3) {
        CompanyRoleCache.refreshEntryPrivileges(l, n, l2, l3);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                CompanyRoleCacheImpl.companyRoleCacheProvider = null;
            }
        });
    }
}

