/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.basic;

import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.fs.web.BannerType;
import com.fr.fs.web.FSConstants;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Device;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemAttr
implements XMLable {
    public static final String XML_TAG = "SystemAttr";
    private String loginImageID4FS;
    private String bgImageID4FS;
    private int backgroundColor;
    private String customBackgroundColor;
    private String logoImageID4FS;
    private String loginUrl4FS;
    private String loginTitle4FS;
    private boolean isLoginPageImg;
    private boolean isBackgroundImg = true;
    private BannerType bannerType = BannerType.IMAGE_WITH_TITLE;
    private String homePageURL;
    private String homePageURL4Pad;
    private String homePageURL4Phone;

    public String getLoginImageID4FS() {
        return this.loginImageID4FS;
    }

    public void setLoginImageID4FS(String string) {
        this.loginImageID4FS = string;
    }

    public String getBgImageID4FS() {
        return this.bgImageID4FS;
    }

    public void setBgImageID4FS(String string) {
        this.bgImageID4FS = string;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.backgroundColor = n;
    }

    public String getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    public void setCustomBackgroundColor(String string) {
        this.customBackgroundColor = string;
    }

    public String getLogoImageID4FS() {
        return this.logoImageID4FS;
    }

    public void setLogoImageID4FS(String string) {
        this.logoImageID4FS = string;
    }

    public String getLoginUrl4FS() {
        return this.loginUrl4FS;
    }

    public void setLoginUrl4FS(String string) {
        this.loginUrl4FS = string;
    }

    public String getLoginTitle4FS() {
        if (StringUtils.isBlank((String)this.loginTitle4FS)) {
            return FRContext.getCompanyName() + Inter.getLocText((String)"FS-Generic-Simple_Name");
        }
        return this.loginTitle4FS;
    }

    public String getRealLoginTitle4FS() {
        return this.loginTitle4FS;
    }

    public void setLoginTitle4FS(String string) {
        this.loginTitle4FS = string;
    }

    public boolean isLoginPageImg() {
        return this.isLoginPageImg;
    }

    public void setIsLoginPageImg(boolean bl) {
        this.isLoginPageImg = bl;
    }

    public boolean isBackgroundImg() {
        return this.isBackgroundImg;
    }

    public void setIsBackgroundImg(boolean bl) {
        this.isBackgroundImg = bl;
    }

    public BannerType getBannerType() {
        return this.bannerType;
    }

    public void setBannerType(BannerType bannerType) {
        this.bannerType = bannerType;
    }

    public String getHomePageURL() {
        return this.homePageURL != null ? this.homePageURL : "";
    }

    public void setHomePageURL(String string) {
        this.homePageURL = string;
    }

    public String getHomePageURL4Pad() {
        return this.homePageURL4Pad != null ? this.homePageURL4Pad : "";
    }

    public void setHomePageURL4Pad(String string) {
        this.homePageURL4Pad = string;
    }

    public String getHomePageURL4Phone() {
        return this.homePageURL4Phone != null ? this.homePageURL4Phone : "";
    }

    public String getHomePageURL(Device device) {
        if (device == null) {
            return "";
        }
        if (device.isPhone()) {
            return this.getHomePageURL4Phone();
        }
        if (device.isPad()) {
            return this.getHomePageURL4Pad();
        }
        return this.getHomePageURL();
    }

    public void setHomePageURL4Phone(String string) {
        this.homePageURL4Phone = string;
    }

    public String createBackgroundColorConfig() {
        String string = this.backgroundColor == -1 ? this.getCustomBackgroundColor() : FSConstants.BACKGROUND_COLORS.COLORS[this.backgroundColor];
        return string;
    }

    public void fillAttrToMap(Map<String, Object> map) {
        map.put("company", this.getLoginTitle4FS());
        map.put("loginImageID4FS", this.getLoginImageID4FS());
        map.put("backgroundImageID", this.getBgImageID4FS());
        map.put("isBackgroundImg", this.isBackgroundImg());
        map.put("backgroundColor", this.createBackgroundColorConfig());
        map.put("bannerType", this.getBannerType().toInt());
        map.put("logoImageID4FS", this.getLogoImageID4FS());
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.loginUrl4FS = xMLableReader.getAttrAsString("loginUrl", null);
            this.homePageURL = xMLableReader.getAttrAsString("homePageURL", null);
            this.homePageURL4Pad = xMLableReader.getAttrAsString("homePageURL4Pad", null);
            this.homePageURL4Phone = xMLableReader.getAttrAsString("homePageURL4Phone", null);
            this.loginTitle4FS = xMLableReader.getAttrAsString("loginTitle", null);
            this.isLoginPageImg = xMLableReader.getAttrAsBoolean("isLoginPageImg", true);
            this.isBackgroundImg = xMLableReader.getAttrAsBoolean("isBackgroundImg", true);
            this.backgroundColor = xMLableReader.getAttrAsInt("backgroundColor", 0);
            this.customBackgroundColor = xMLableReader.getAttrAsString("customBackgroundColor", FSConstants.BACKGROUND_COLORS.COLORS[0]);
            this.bannerType = BannerType.parse(xMLableReader.getAttrAsInt("bannerType", 2));
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("loginImage")) {
                        SystemAttr.this.loginImageID4FS = SystemAttr.this.readImage(xMLableReader, "loginImage");
                    } else if (string.equals("logoImage")) {
                        SystemAttr.this.logoImageID4FS = SystemAttr.this.readImage(xMLableReader, "logoImage");
                    } else if (string.equals("backgroundImage")) {
                        SystemAttr.this.bgImageID4FS = SystemAttr.this.readImage(xMLableReader, "backgroundImage");
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("loginUrl", this.loginUrl4FS);
        if (StringUtils.isNotEmpty((String)this.homePageURL)) {
            xMLPrintWriter.attr("homePageURL", this.homePageURL);
        }
        if (StringUtils.isNotEmpty((String)this.homePageURL4Pad)) {
            xMLPrintWriter.attr("homePageURL4Pad", this.homePageURL4Pad);
        }
        if (StringUtils.isNotEmpty((String)this.homePageURL4Phone)) {
            xMLPrintWriter.attr("homePageURL4Phone", this.homePageURL4Phone);
        }
        if (this.loginTitle4FS != null) {
            xMLPrintWriter.attr("loginTitle", this.loginTitle4FS);
        }
        xMLPrintWriter.attr("isLoginPageImg", this.isLoginPageImg);
        xMLPrintWriter.attr("isBackgroundImg", this.isBackgroundImg);
        xMLPrintWriter.attr("backgroundColor", this.backgroundColor);
        xMLPrintWriter.attr("customBackgroundColor", this.customBackgroundColor);
        xMLPrintWriter.attr("bannerType", this.bannerType.toInt());
        this.writeImage(xMLPrintWriter, "loginImage", this.loginImageID4FS);
        this.writeImage(xMLPrintWriter, "logoImage", this.logoImageID4FS);
        this.writeImage(xMLPrintWriter, "backgroundImage", this.bgImageID4FS);
        xMLPrintWriter.end();
    }

    private String readImage(XMLableReader xMLableReader, String string) {
        String string2 = xMLableReader.getAttrAsString("id", null);
        byte[] byArray = GeneralXMLTools.readByteArray((XMLableReader)xMLableReader);
        if (StringUtils.isNotBlank((String)string2) && byArray != null) {
            AttachmentSource.putAttachment((String)string2, (Attachment)new Attachment(string2, "image", string2, byArray));
        }
        return string2;
    }

    private void writeImage(XMLPrintWriter xMLPrintWriter, String string, String string2) {
        Attachment attachment = AttachmentCacheManager.getAttachment((String)string2);
        if (StringUtils.isNotEmpty((String)string2) && attachment != null) {
            xMLPrintWriter.startTAG(string);
            xMLPrintWriter.attr("id", string2);
            GeneralXMLTools.writeByteArray((XMLPrintWriter)xMLPrintWriter, (byte[])attachment.getBytes());
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

