/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.base.entity;

import com.fr.base.Base64;
import com.fr.file.DefaultClusterServerProcessor;
import com.fr.general.ComparatorUtils;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CodeUtils;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.ClusterServerProcessor;
import com.fr.stable.fun.SessionPrivilegeFilterProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UserInfo
implements FCloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int COOKIE_LIFE = 1209600000;
    private long id;
    private String username;
    private String password;
    private String desc;
    private boolean remember = false;

    public UserInfo() {
    }

    public UserInfo(HttpServletRequest httpServletRequest) throws Exception {
        this.analysisCookies(httpServletRequest);
    }

    public UserInfo(String string, String string2, boolean bl) {
        this.username = string;
        this.password = string2;
        this.remember = bl;
    }

    public UserInfo(long l, String string, String string2) {
        this.id = l;
        this.username = string;
        this.password = string2;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRemember(boolean bl) {
        this.remember = bl;
    }

    public boolean analysisCookies(HttpServletRequest httpServletRequest) throws Exception {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length < 3) {
            return false;
        }
        for (Cookie cookie : cookieArray) {
            String string = cookie.getName();
            if (string.equalsIgnoreCase("fr_username")) {
                this.username = CodeUtils.cjkDecode((String)cookie.getValue());
                continue;
            }
            if (string.equalsIgnoreCase("fr_password")) {
                String string2 = cookie.getValue();
                try {
                    this.password = StringUtils.isEmpty((String)string2) ? string2 : this.decodeCookie(string2);
                }
                catch (Exception exception) {
                    this.password = string2;
                }
                continue;
            }
            if (!string.equalsIgnoreCase("fr_remember")) continue;
            this.remember = Boolean.valueOf(cookie.getValue());
        }
        return !StringUtils.isEmpty((String)this.username) && !StringUtils.isEmpty((String)this.password);
    }

    private String encodeCookie(String string) {
        Set set = ExtraClassManager.getInstance().getArray("SessionPrivilegeFilterProvider");
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            SessionPrivilegeFilterProvider sessionPrivilegeFilterProvider = (SessionPrivilegeFilterProvider)iterator.next();
            return sessionPrivilegeFilterProvider.encodeCookie(string);
        }
        return Base64.encode((byte[])(String.valueOf(Math.random()).substring(2, 4) + string).getBytes());
    }

    private String decodeCookie(String string) {
        Set set = ExtraClassManager.getInstance().getArray("SessionPrivilegeFilterProvider");
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            SessionPrivilegeFilterProvider sessionPrivilegeFilterProvider = (SessionPrivilegeFilterProvider)iterator.next();
            return sessionPrivilegeFilterProvider.decodeCookie(string);
        }
        return new String(Base64.decode((String)string)).substring(2);
    }

    public void dealBrowserCookies(HttpServletResponse httpServletResponse) throws Exception {
        this.dealBrowserCookies(httpServletResponse, null);
    }

    public void dealBrowserCookies(HttpServletResponse httpServletResponse, HttpSession httpSession) throws Exception {
        Cookie cookie2;
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        int n = this.remember ? 1209600000 : -1;
        String string = this.remember ? this.encodeCookie(this.password) : "";
        arrayList.add(new Cookie("fr_remember", Boolean.valueOf(this.remember).toString()));
        arrayList.add(new Cookie("fr_password", string));
        arrayList.add(new Cookie("fr_username", CodeUtils.cjkEncode((String)this.username)));
        for (Cookie cookie2 : arrayList) {
            cookie2.setMaxAge(n);
            httpServletResponse.addCookie(cookie2);
        }
        ClusterServerProcessor clusterServerProcessor = (ClusterServerProcessor)ExtraClassManager.getInstance().getSingle("ClusterServerProcessor", DefaultClusterServerProcessor.class);
        cookie2 = clusterServerProcessor.generateLoginCookie(httpSession);
        if (cookie2 != null) {
            httpServletResponse.addCookie(cookie2);
        }
    }

    public void removeCookies(HttpServletResponse httpServletResponse) {
        Cookie cookie2;
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        arrayList.add(new Cookie("fr_password", ""));
        arrayList.add(new Cookie("fr_remember", "false"));
        for (Cookie cookie2 : arrayList) {
            cookie2.setMaxAge(-1);
            httpServletResponse.addCookie(cookie2);
        }
        ClusterServerProcessor clusterServerProcessor = (ClusterServerProcessor)ExtraClassManager.getInstance().getSingle("ClusterServerProcessor", DefaultClusterServerProcessor.class);
        cookie2 = clusterServerProcessor.generateLoginCookie(null);
        if (cookie2 != null) {
            httpServletResponse.addCookie(cookie2);
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = 31 * n2 + (this.username == null ? 0 : this.username.hashCode());
        n2 = 31 * n2 + (this.desc == null ? 0 : this.desc.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        return object instanceof UserInfo && this.id == ((UserInfo)object).id && ComparatorUtils.equals((String)this.username, (String)((UserInfo)object).username) && ComparatorUtils.equals((String)this.desc, (String)((UserInfo)object).desc);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

