/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.base.entity;

import com.fr.data.dao.DAOBean;
import com.fr.fs.control.UserControl;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.Date;

public class User
extends DAOBean {
    private String username;
    private String password;
    private String realname;
    private Date birthday;
    private boolean male;
    private String mobile;
    private String workphone;
    private String email;

    public User() {
    }

    public User(long l) {
        this.id = l;
    }

    public User(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        this.realname = string3;
    }

    public User(String string, String string2, String string3, Date date, boolean bl, String string4, String string5, String string6) {
        this.username = string;
        this.password = string2;
        this.realname = string3;
        this.birthday = date;
        this.male = bl;
        this.mobile = string4;
        this.workphone = string5;
        this.email = string6;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String string) {
        this.realname = string;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date date) {
        this.birthday = date;
    }

    public boolean isMale() {
        return this.male;
    }

    public void setMale(boolean bl) {
        this.male = bl;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String string) {
        this.mobile = string;
    }

    public String getWorkphone() {
        return this.workphone;
    }

    public void setWorkphone(String string) {
        this.workphone = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public JSONObject createJSON4Share() throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FArray fArray = UserControl.getInstance().getUserDP(this.getId());
            int n = fArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = (JSONObject)fArray.elementAt(i);
                stringBuffer.append(jSONObject.getString("departments") + "--" + jSONObject.getString("jobTitle"));
                if (i + 1 >= n) continue;
                stringBuffer.append(" ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JSONObject().put("user_id", this.getId()).put("user_name", (Object)this.getRealname()).put("user_department", (Object)stringBuffer.toString());
    }

    public JSONObject createUnEditInfoJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = this.realname == null ? "" : this.realname;
        jSONObject.put("id", this.getId());
        jSONObject.put("username", (Object)this.getUsername());
        jSONObject.put("text", (Object)(string + "(" + this.getUsername() + ")"));
        jSONObject.put("value", (Object)this.getUsername());
        jSONObject.put("realname", (Object)this.getRealname());
        jSONObject.put("password", (Object)"********");
        jSONObject.put("mobile", (Object)this.getMobile());
        jSONObject.put("email", (Object)this.getEmail());
        return jSONObject;
    }

    public JSONObject createEditInfoJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = this.realname == null ? "" : this.realname;
        jSONObject.put("username", (Object)this.getUsername());
        jSONObject.put("text", (Object)(string + "(" + this.getUsername() + ")"));
        jSONObject.put("value", (Object)this.getUsername());
        jSONObject.put("realname", (Object)this.getRealname());
        jSONObject.put("id", this.getId());
        if (this.getBirthday() != null) {
            jSONObject.put("birthday", (Object)DateUtils.DATEFORMAT2.format(this.birthday));
        }
        jSONObject.put("male", this.isMale());
        jSONObject.put("mobile", (Object)this.getMobile());
        jSONObject.put("email", (Object)this.getEmail());
        jSONObject.put("workphone", (Object)this.getWorkphone());
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("id")) {
            this.setId(jSONObject.getLong("id"));
        }
        if (jSONObject.has("username")) {
            this.setUsername(jSONObject.getString("username"));
        }
        if (jSONObject.has("password")) {
            this.setPassword(jSONObject.getString("password"));
        }
        if (jSONObject.has("realname")) {
            this.setRealname(jSONObject.getString("realname"));
        }
        if (jSONObject.has("birthday")) {
            this.setBirthday(DateUtils.string2Date((String)jSONObject.getString("birthday"), (boolean)true));
        }
        if (jSONObject.has("male")) {
            this.setMale(jSONObject.getBoolean("male"));
        }
        if (jSONObject.has("mobile")) {
            this.setMobile(jSONObject.getString("mobile"));
        }
        if (jSONObject.has("email")) {
            this.setEmail(jSONObject.getString("email"));
        }
        if (jSONObject.has("workphone")) {
            this.setWorkphone(jSONObject.getString("workphone"));
        }
    }

    protected int hashCode4Properties() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.birthday == null ? 0 : this.birthday.hashCode());
        n2 = 31 * n2 + (this.email == null ? 0 : this.email.hashCode());
        n2 = 31 * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = 31 * n2 + (this.male ? 1231 : 1237);
        n2 = 31 * n2 + (this.mobile == null ? 0 : this.mobile.hashCode());
        n2 = 31 * n2 + (this.password == null ? 0 : this.password.hashCode());
        n2 = 31 * n2 + (this.realname == null ? 0 : this.realname.hashCode());
        n2 = 31 * n2 + (this.username == null ? 0 : this.username.hashCode());
        n2 = 31 * n2 + (this.workphone == null ? 0 : this.workphone.hashCode());
        return n2;
    }

    public boolean equals4Properties(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        User user = (User)((Object)object);
        return this.id == user.id && this.male == user.male && ComparatorUtils.equals((String)this.username, (String)user.username) && ComparatorUtils.equals((String)this.password, (String)user.password) && ComparatorUtils.equals((String)this.realname, (String)user.realname) && ComparatorUtils.equals((Object)this.birthday, (Object)user.birthday) && ComparatorUtils.equals((String)this.email, (String)user.email) && ComparatorUtils.equals((String)this.mobile, (String)user.mobile) && ComparatorUtils.equals((String)this.workphone, (String)user.workphone);
    }
}

