/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.auth;

import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.privilege.auth.LdapAuthenticationProvider;
import com.fr.general.GeneralUtils;
import com.fr.privilege.Authentication;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class LdapAuthenticateObjectType
implements AuthenticateObjectType {
    private static final String XML_TAG = "LdapAuthenticateObjectType";
    public static final String AUTH_SIMPLE = "simple";
    public static final String REFERRAL_FOLLOW = "follow";
    private static final String SUN_DEFAULT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private String ldapUrl = "";
    private String ldapSearchBase = "";
    private boolean retrieveLocAsBaseDN = true;
    private String authentication = "simple";
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String referral = "follow";
    private String principalSuffix = "";
    private String ldapSystemName = "";
    private String ldapSystemPassword = "";

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String string) {
        this.ldapUrl = string;
    }

    public String getLdapSearchBase() {
        return this.ldapSearchBase;
    }

    public void setLdapSearchBase(String string) {
        this.ldapSearchBase = string;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String string) {
        this.referral = string;
    }

    public String getPrincipalSuffix() {
        return this.principalSuffix;
    }

    public void setPrincipalSuffix(String string) {
        this.principalSuffix = string;
    }

    public String getLdapSystemName() {
        return this.ldapSystemName;
    }

    public void setLdapSystemName(String string) {
        this.ldapSystemName = string;
    }

    public String getLdapSystemPassword() {
        return this.ldapSystemPassword;
    }

    public void setLdapSystemPassword(String string) {
        this.ldapSystemPassword = string;
    }

    public boolean isRetrieveLocAsBaseDN() {
        return this.retrieveLocAsBaseDN;
    }

    public void setRetrieveLocAsBaseDN(boolean bl) {
        this.retrieveLocAsBaseDN = bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && XML_TAG.equals(string = xMLableReader.getTagName())) {
            this.ldapUrl = xMLableReader.getAttrAsString("ldapUrl", null);
            this.referral = xMLableReader.getAttrAsString("referral", null);
            this.ldapSearchBase = xMLableReader.getAttrAsString("ldapSearchBase", null);
            this.retrieveLocAsBaseDN = xMLableReader.getAttrAsBoolean("retrieveLocAsBaseDN", true);
            this.authentication = xMLableReader.getAttrAsString("authentication", null);
            this.contextFactory = xMLableReader.getAttrAsString("contextFactory", null);
            this.principalSuffix = xMLableReader.getAttrAsString("principalSuffix", null);
            this.ldapSystemName = xMLableReader.getAttrAsString("ldapSystemName", null);
            this.ldapSystemPassword = xMLableReader.getAttrAsString("ldapSystemPassword", null);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("ldapUrl", this.ldapUrl);
        xMLPrintWriter.attr("ldapSearchBase", this.ldapSearchBase);
        xMLPrintWriter.attr("retrieveLocAsBaseDN", this.retrieveLocAsBaseDN);
        xMLPrintWriter.attr("authentication", this.authentication);
        xMLPrintWriter.attr("contextFactory", this.contextFactory);
        xMLPrintWriter.attr("referral", this.referral);
        xMLPrintWriter.attr("principalSuffix", this.principalSuffix);
        xMLPrintWriter.attr("ldapSystemName", this.ldapSystemName);
        xMLPrintWriter.attr("ldapSystemPassword", this.ldapSystemPassword);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        LdapAuthenticateObjectType ldapAuthenticateObjectType = (LdapAuthenticateObjectType)super.clone();
        return ldapAuthenticateObjectType;
    }

    public boolean authentication(Authentication authentication) throws Exception {
        if (StringUtils.isNotEmpty((String)this.principalSuffix)) {
            String string = GeneralUtils.objectToString((Object)authentication.getPrincipal()) + this.principalSuffix;
            authentication.setPrincipal((Object)string);
        }
        return LdapAuthenticationProvider.getInstance().ldapAuthentication(authentication);
    }

    public boolean authenticationWithoutPassword() {
        return true;
    }

    public String markType() {
        return "ldap";
    }
}

