/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.data.impl.EscapeSqlHelper;
import com.fr.file.BaseClusterHelper;
import com.fr.file.ClusterReinitListener;
import com.fr.file.XMLFileManager;
import com.fr.fs.PreventSqlInjConfigProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.SiteCenter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreventSqlInjConfig
extends XMLFileManager
implements PreventSqlInjConfigProvider {
    public static final String XML_TAG = "PreventSqlInjConfig";
    private static final String FILE_NAME = "preventsqlinjConfig.xml";
    private static final String DEFAULT_FORBID_KEY = "\\b(?i)and\\b|\\b(?i)exec\\b|\\b(?i)insert\\b|\\b(?i)select\\b|\\b(?i)delete\\b|\\b(?i)update\\b|\\b(?i)count\\b|\\b(?i)chr\\b|\\b(?i)mid\\b|\\b(?i)master\\b|\\b(?i)truncate\\b|\\b(?i)char\\b|\\b(?i)declare\\b|\\b(?i)or\\b|\\b(?i)drop\\b|\\b(?i)create\\b|\\b(?i)alert\\b";
    private static final String DEFAULT_SPECIAL_CHAR = "'|;|--";
    private static final String REGEX_DEFAULT_SPILT = "\\|";
    private static final String DEFAULT_SPILT = "|";
    private static final String PREVENT_SQL_INJ_TOGGLE = "Toggle";
    private static final String SELECTED_FORBID_WORD_XML_TAG = "SelectedForbidWord";
    private static final String UNSELECTED_FORBID_WORD_XML_TAG = "UnSelectedForbidWord";
    private static final String CUSTOM_FORBID_WORD_XML_TAG = "CustomForbidWord";
    private static final String SELECTED_SPECIAL_CHAR_XML_TAG = "SelectedSpecialChar";
    private static final String UNSELECTED_SPECIAL_CHAR_XML_TAG = "UnSelectedSpecialChar";
    private static final String CUSTOM_SPECIAL_CHAR_XML_TAG = "CustomSpecialChar";
    private static final String DATA_XML_TAG = "data";
    private List<String> selectedForbidWordList = new ArrayList<String>();
    private List<String> customForbidWordList = new ArrayList<String>();
    private List<String> selectedSpecialCharList = new ArrayList<String>();
    private List<String> customSpecialCharList = new ArrayList<String>();
    private boolean useForbidWord = false;
    private boolean useEscapeSpecialChar = false;
    private static PreventSqlInjConfigProvider preventSqlInjConfig = null;

    private PreventSqlInjConfig() {
    }

    public static synchronized PreventSqlInjConfig getInstance() {
        return (PreventSqlInjConfig)PreventSqlInjConfig.getProviderInstance();
    }

    public static void reinit() {
        preventSqlInjConfig = null;
        PreventSqlInjConfig.getProviderInstance();
    }

    public static synchronized PreventSqlInjConfigProvider getProviderInstance() {
        if (preventSqlInjConfig != null) {
            return preventSqlInjConfig;
        }
        PreventSqlInjConfig.refreshPreventSqlInjConfig();
        return preventSqlInjConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshPreventSqlInjConfig() {
        Class<PreventSqlInjConfig> clazz = PreventSqlInjConfig.class;
        synchronized (PreventSqlInjConfig.class) {
            if (PreventSqlInjConfig.isClusterMember()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (!preventSqlInjConfig.readXMLFile()) {
                preventSqlInjConfig.generateDefaultConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                preventSqlInjConfig = new PreventSqlInjConfig();
                RPC.registerSkeleton((Object)preventSqlInjConfig);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                preventSqlInjConfig = (PreventSqlInjConfigProvider)RPC.getProxy(PreventSqlInjConfig.class, (String)string);
                return true;
            }
        }
        preventSqlInjConfig = new PreventSqlInjConfig();
        return false;
    }

    @Override
    public void generateDefaultConfig() {
        String[] stringArray = this.getForbidWordFormCloud();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        this.selectedForbidWordList = arrayList;
        EscapeSqlHelper.getInstance().setSelectedForbidWord(stringArray);
        String[] stringArray2 = this.getSpecialCharFormCloud();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Collections.addAll(arrayList2, stringArray2);
        this.selectedSpecialCharList = arrayList2;
        EscapeSqlHelper.getInstance().setSelectedSpecialChar(stringArray2);
        this.customForbidWordList = new ArrayList<String>();
        this.customSpecialCharList = new ArrayList<String>();
    }

    @Override
    public boolean addForbidWord(String string) {
        this.selectedForbidWordList.add(string);
        EscapeSqlHelper.getInstance().addSelectedForbidWord(string);
        return true;
    }

    @Override
    public boolean setForbidWord(String string) {
        this.selectedForbidWordList.clear();
        if (ComparatorUtils.equals((String)string, (String)"")) {
            EscapeSqlHelper.getInstance().setSelectedForbidWord(new String[0]);
        } else {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(this.selectedForbidWordList, stringArray);
            EscapeSqlHelper.getInstance().setSelectedForbidWord(stringArray);
        }
        return true;
    }

    @Override
    public boolean addCustomForbidWord(String string) {
        if (!this.getAllForbidWord().contains(string)) {
            this.customForbidWordList.add(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCustomForbidWord(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, stringArray);
        this.customForbidWordList.removeAll(arrayList);
        this.selectedForbidWordList.removeAll(arrayList);
        return true;
    }

    @Override
    public JSONObject getForbidWordJson(JSONObject jSONObject) throws JSONException {
        jSONObject.put(SELECTED_FORBID_WORD_XML_TAG, this.selectedForbidWordList);
        return jSONObject;
    }

    @Override
    public JSONObject getUnSelectedForbidWordJson(JSONObject jSONObject) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getForbidWordFormCloud();
        Collections.addAll(arrayList, stringArray);
        arrayList.addAll(this.customForbidWordList);
        arrayList.removeAll(this.selectedForbidWordList);
        jSONObject.put(UNSELECTED_FORBID_WORD_XML_TAG, arrayList);
        return jSONObject;
    }

    @Override
    public JSONObject getCustomForbidWordJson(JSONObject jSONObject) throws JSONException {
        jSONObject.put(DATA_XML_TAG, this.customForbidWordList);
        return jSONObject;
    }

    @Override
    public boolean addSpecialChar(String string) {
        this.selectedSpecialCharList.add(string);
        EscapeSqlHelper.getInstance().addSelectedSpecialChar(string);
        return true;
    }

    @Override
    public boolean setSpecialChar(String string) {
        this.selectedSpecialCharList.clear();
        if (ComparatorUtils.equals((String)string, (String)"")) {
            EscapeSqlHelper.getInstance().setSelectedSpecialChar(new String[0]);
        } else {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(this.selectedSpecialCharList, stringArray);
            EscapeSqlHelper.getInstance().setSelectedSpecialChar(stringArray);
        }
        return true;
    }

    @Override
    public boolean addCustomSpecialChar(String string) {
        if (!this.getAllSpecialChar().contains(string)) {
            this.customSpecialCharList.add(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCustomSpecialChar(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, stringArray);
        this.customSpecialCharList.removeAll(arrayList);
        this.selectedSpecialCharList.removeAll(arrayList);
        return true;
    }

    @Override
    public JSONObject getSpecialCharJson(JSONObject jSONObject) throws JSONException {
        jSONObject.put(SELECTED_SPECIAL_CHAR_XML_TAG, this.selectedSpecialCharList);
        return jSONObject;
    }

    @Override
    public JSONObject getUnSelectedSpecialCharJson(JSONObject jSONObject) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getSpecialCharFormCloud();
        Collections.addAll(arrayList, stringArray);
        arrayList.addAll(this.customSpecialCharList);
        arrayList.removeAll(this.selectedSpecialCharList);
        jSONObject.put(UNSELECTED_SPECIAL_CHAR_XML_TAG, arrayList);
        return jSONObject;
    }

    @Override
    public JSONObject getCustomSpecialCharJson(JSONObject jSONObject) throws JSONException {
        jSONObject.put(DATA_XML_TAG, this.customSpecialCharList);
        return jSONObject;
    }

    private Set<String> getAllForbidWord() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.getForbidWordFormCloud();
        Collections.addAll(hashSet, stringArray);
        hashSet.addAll(this.customForbidWordList);
        hashSet.addAll(this.selectedForbidWordList);
        return hashSet;
    }

    private Set<String> getAllSpecialChar() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.getSpecialCharFormCloud();
        Collections.addAll(hashSet, stringArray);
        hashSet.addAll(this.customSpecialCharList);
        hashSet.addAll(this.selectedSpecialCharList);
        return hashSet;
    }

    private String reduceString(Iterable iterable, String string) {
        if (iterable == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private List<String> handlerFW(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ComparatorUtils.equals((String)string, (String)"")) {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(arrayList, stringArray);
            EscapeSqlHelper.getInstance().setSelectedForbidWord(stringArray);
        }
        return arrayList;
    }

    private List<String> handlerUCFW(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ComparatorUtils.equals((String)string, (String)"")) {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(arrayList, stringArray);
        }
        return arrayList;
    }

    private List<String> handlerSC(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ComparatorUtils.equals((String)string, (String)"")) {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(arrayList, stringArray);
            EscapeSqlHelper.getInstance().setSelectedSpecialChar(stringArray);
        }
        return arrayList;
    }

    private List<String> handlerUCSC(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ComparatorUtils.equals((String)string, (String)"")) {
            String[] stringArray = string.split(REGEX_DEFAULT_SPILT);
            Collections.addAll(arrayList, stringArray);
        }
        return arrayList;
    }

    private String[] getForbidWordFormCloud() {
        String string = SiteCenter.getInstance().acquireUrlByKind("sqlagainject.special", DEFAULT_FORBID_KEY);
        return string.split(REGEX_DEFAULT_SPILT);
    }

    private String[] getSpecialCharFormCloud() {
        String string = SiteCenter.getInstance().acquireUrlByKind("sqlagainject.sym", DEFAULT_SPECIAL_CHAR);
        return string.split(REGEX_DEFAULT_SPILT);
    }

    @Override
    public void setUseForbidWord(boolean bl) {
        this.useForbidWord = bl;
        EscapeSqlHelper.getInstance().setUseForbidWord(bl);
    }

    @Override
    public void setUseEscapeSpecialChar(boolean bl) {
        this.useEscapeSpecialChar = bl;
        EscapeSqlHelper.getInstance().setUseEscapeSpecialChar(bl);
    }

    @Override
    public boolean isUseForbidWord() {
        return this.useForbidWord;
    }

    @Override
    public boolean isUseEscapeSpecialChar() {
        return this.useEscapeSpecialChar;
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        PreventSqlInjConfig preventSqlInjConfig = new PreventSqlInjConfig();
        XMLTools.readInputStreamXML((XMLReadable)preventSqlInjConfig, (InputStream)inputStream);
        PreventSqlInjConfig.preventSqlInjConfig = preventSqlInjConfig;
        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)preventSqlInjConfig);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(SELECTED_FORBID_WORD_XML_TAG)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 == null) {
                    string2 = "";
                }
                this.selectedForbidWordList = this.handlerFW(string2);
            } else if (string.equals(SELECTED_SPECIAL_CHAR_XML_TAG)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 == null) {
                    string3 = "";
                }
                this.selectedSpecialCharList = this.handlerSC(string3);
            } else if (string.equals(CUSTOM_FORBID_WORD_XML_TAG)) {
                String string4 = xMLableReader.getElementValue();
                if (string4 == null) {
                    string4 = "";
                }
                this.customForbidWordList = this.handlerUCFW(string4);
            } else if (string.equals(CUSTOM_SPECIAL_CHAR_XML_TAG)) {
                String string5 = xMLableReader.getElementValue();
                if (string5 == null) {
                    string5 = "";
                }
                this.customSpecialCharList = this.handlerUCSC(string5);
            } else if (string.equals(PREVENT_SQL_INJ_TOGGLE)) {
                this.setUseForbidWord(xMLableReader.getAttrAsBoolean("useForbidWord", false));
                this.setUseEscapeSpecialChar(xMLableReader.getAttrAsBoolean("useEscapeSpecialChar", false));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG(PREVENT_SQL_INJ_TOGGLE).attr("useForbidWord", this.useForbidWord).attr("useEscapeSpecialChar", this.useEscapeSpecialChar).end();
        xMLPrintWriter.startTAG(SELECTED_FORBID_WORD_XML_TAG).textNode(this.reduceString(this.selectedForbidWordList, DEFAULT_SPILT)).end();
        xMLPrintWriter.startTAG(CUSTOM_FORBID_WORD_XML_TAG).textNode(this.reduceString(this.customForbidWordList, DEFAULT_SPILT)).end();
        xMLPrintWriter.startTAG(SELECTED_SPECIAL_CHAR_XML_TAG).textNode(this.reduceString(this.selectedSpecialCharList, DEFAULT_SPILT)).end();
        xMLPrintWriter.startTAG(CUSTOM_SPECIAL_CHAR_XML_TAG).textNode(this.reduceString(this.customSpecialCharList, DEFAULT_SPILT)).end();
        xMLPrintWriter.end();
    }

    public String fileName() {
        return FILE_NAME;
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)PreventSqlInjConfig.getInstance());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                preventSqlInjConfig = null;
            }
        });
        BaseClusterHelper.addManagerReinitListener((ClusterReinitListener)new ClusterReinitListener(){

            public void reinit() {
                PreventSqlInjConfig.reinit();
            }
        });
    }
}

