/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.platform.msg.MessageHelper;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.fs.FSConfigProvider;
import com.fr.fs.PlateFactory;
import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.auth.AuthorizeAttr;
import com.fr.fs.auth.DefaultAuthenticateObjectType;
import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.base.entity.User;
import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.basic.AutoBackupTimerAttr;
import com.fr.fs.basic.DatabaseAdapterAttr;
import com.fr.fs.basic.SystemAttr;
import com.fr.fs.basic.SystemStyle;
import com.fr.fs.basic.Theme;
import com.fr.fs.cache.AlphabetUserDeviceComparator;
import com.fr.fs.cache.CompanyRoleCacheImpl;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.cache.DepartmentCacheImpl;
import com.fr.fs.cache.PostCacheImpl;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.UserDataControl;
import com.fr.fs.control.UserDataControlFactory;
import com.fr.fs.control.UserDeviceControl;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.device.DeviceInfo;
import com.fr.fs.device.UserDevice;
import com.fr.fs.fun.FSConfigCompatibleProcessor;
import com.fr.fs.fun.ThemeFinder;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.web.service.FSOpenEntryService;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.SiteCenter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.SortedJSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.LicUtils;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.ResourceHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSConfig
extends XMLFileManager
implements FSConfigProvider {
    private static final String XML_TAG = "fsconfig";
    private static final String XML_PLUGIN_TAG = "Plugin";
    public static final int DEFAULT_USER_LIMIT = 0;
    public static final int DEFAULT_MOBILE_USER_AUTH_LIMIT = 0;
    private static int userLimit = 0;
    private static int mobileUserAuthLimit = 0;
    private boolean useFS = false;
    private static FSConfigProvider fsConfig = null;
    private UserDataControl control = HSQLDBDAOControl.getInstance();
    private SystemManagerFavoriteAndADHOC sysManagerFvAndAD = SystemManagerFavoriteAndADHOC.getInstance();
    private Theme theme = new Theme("default");
    private String pluginId = "";
    private DatabaseAdapterAttr databaseAdapterAttr = new DatabaseAdapterAttr();
    private SystemAttr systemAttr = new SystemAttr();
    private SystemStyle systemStyle = new SystemStyle();
    private AutoBackupTimerAttr autoBackupTimerAttr = new AutoBackupTimerAttr();
    private boolean needUpdate = true;
    private AuthenticateObjectType authenticateObjectType = new DefaultAuthenticateObjectType();
    private boolean mobileDeviceBinding = false;
    private Map<String, UserDevice> userDeviceMap = new HashMap<String, UserDevice>();
    private AuthorizeAttr authorizeAttr = new AuthorizeAttr();
    private long xmlVersion;

    public static FSConfig getInstance() {
        return (FSConfig)FSConfig.getProviderInstance();
    }

    public static FSConfigProvider getProviderInstance() {
        if (fsConfig != null) {
            return fsConfig;
        }
        FSConfig.refreshFSConfig();
        return fsConfig;
    }

    @Override
    public void transferDeviceInfo() {
        if (this.userDeviceMap.isEmpty()) {
            return;
        }
        for (UserDevice userDevice : this.userDeviceMap.values()) {
            List<DeviceInfo> list = userDevice.getDeviceInfoList();
            for (DeviceInfo deviceInfo : list) {
                try {
                    UserDeviceControl.getInstance().addUserDeviceInfo(new UserDeviceInfo(userDevice.getUsername(), deviceInfo.getMacAddress(), deviceInfo.getDeviceName(), deviceInfo.isPassed()));
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        this.userDeviceMap.clear();
        try {
            this.writeResource();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFSConfig() {
        Class<FSConfig> clazz = FSConfig.class;
        synchronized (FSConfig.class) {
            if (FSConfig.isClusterMember()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            fsConfig.readXMLFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                fsConfig = new FSConfig();
                RPC.registerSkeleton((Object)fsConfig);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                fsConfig = (FSConfigProvider)RPC.getProxy(FSConfig.class, (String)string);
                return true;
            }
        }
        fsConfig = new FSConfig();
        return false;
    }

    private FSConfig() {
    }

    public String fileName() {
        return "fsconfig.xml";
    }

    @Override
    public SystemAttr getSystemAttr() {
        return this.systemAttr;
    }

    @Override
    public SystemStyle getSystemStyle() {
        return this.systemStyle;
    }

    @Override
    public void setSystemStyle(SystemStyle systemStyle) {
        this.systemStyle = systemStyle;
    }

    @Override
    public void setSystemAttr(SystemAttr systemAttr) {
        this.systemAttr = systemAttr;
    }

    @Override
    public AutoBackupTimerAttr getAutoBackupTimerAttr() {
        return this.autoBackupTimerAttr;
    }

    @Override
    public void setAutoBackupTimerAttr(AutoBackupTimerAttr autoBackupTimerAttr) {
        this.autoBackupTimerAttr = autoBackupTimerAttr;
    }

    @Override
    public boolean isUseFS() {
        return this.useFS;
    }

    @Override
    public void setUseFS(boolean bl) {
        this.useFS = bl;
    }

    @Override
    public UserDataControl getControl() {
        return this.control;
    }

    @Override
    public boolean setControl(UserDataControl userDataControl) {
        this.control = userDataControl;
        boolean bl = userDataControl.init();
        FSConfigCompatibleProcessor fSConfigCompatibleProcessor = (FSConfigCompatibleProcessor)ExtraPlatformClassManager.getInstance().getSingle("FSConfigCompatibleProcessor");
        if (fSConfigCompatibleProcessor != null) {
            fSConfigCompatibleProcessor.compatibleControlSet();
            return bl;
        }
        try {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void clearCache() {
        UserCacheImpl.getInstance().removeAllCache();
        try {
            CustomRoleCacheImpl.getInstance().clearCache();
            CompanyRoleCacheImpl.getInstance().clearCache();
            PostCacheImpl.getInstance().clearCache();
            DepartmentCacheImpl.getInstance().clearCache();
            CompanyRoleControl.getInstance().reset();
            CustomRoleControl.getInstance().reset();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void setNeedUpdate(boolean bl) {
        this.needUpdate = bl;
    }

    @Override
    public AuthorizeAttr getAuthorizeAttr() {
        return this.authorizeAttr;
    }

    @Override
    public void setAuthorizeAttr(AuthorizeAttr authorizeAttr) {
        this.authorizeAttr = authorizeAttr;
    }

    @Override
    public <T> T getAuthenticateObjectType(Class<? extends T> clazz) {
        if (StableUtils.objectInstanceOf((Object)this.authenticateObjectType, clazz)) {
            return (T)this.authenticateObjectType;
        }
        return null;
    }

    @Override
    public AuthenticateObjectType getAuthenticateObjectType() {
        return this.authenticateObjectType;
    }

    @Override
    public void setAuthenticateObjectType(AuthenticateObjectType authenticateObjectType) {
        this.authenticateObjectType = authenticateObjectType;
    }

    @Override
    public boolean isMobileDeviceBinding() {
        return this.mobileDeviceBinding;
    }

    @Override
    public void setMobileDeviceBinding(boolean bl) {
        this.mobileDeviceBinding = bl;
    }

    @Override
    public void addUserDevice(String string, UserDevice userDevice) {
        this.userDeviceMap.put(string, userDevice);
    }

    @Override
    public void addUserDevice(String string, DeviceInfo deviceInfo) {
        UserDevice userDevice = this.userDeviceMap.get(string);
        if (userDevice != null) {
            userDevice.addDeviceInfo(deviceInfo);
        } else {
            this.userDeviceMap.put(string, new UserDevice(string, deviceInfo));
        }
    }

    @Override
    public UserDevice getUserDevice(String string) {
        return this.userDeviceMap.get(string);
    }

    @Override
    public UserDevice removeUserDevice(String string) {
        return this.userDeviceMap.remove(string);
    }

    @Override
    public JSONObject getUserDeviceJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : this.userDeviceMap.keySet()) {
            UserDevice userDevice = this.userDeviceMap.get(string);
            jSONObject.put(string, (Object)userDevice.toJSONArray());
        }
        return jSONObject;
    }

    @Override
    public JSONObject getSortedUserDeviceJSONObject() throws JSONException {
        SortedJSONObject sortedJSONObject = SortedJSONObject.create();
        ArrayList<UserDevice> arrayList = new ArrayList<UserDevice>(this.userDeviceMap.values());
        Collections.sort(arrayList, new AlphabetUserDeviceComparator(FRContext.getLocale()));
        for (int i = 0; i < arrayList.size(); ++i) {
            sortedJSONObject.put(((UserDevice)arrayList.get(i)).getUsername(), (Object)((UserDevice)arrayList.get(i)).toJSONArray());
        }
        return sortedJSONObject;
    }

    @Override
    public int getUserLimit() {
        return userLimit;
    }

    @Override
    public int getMobileUserAuthLimit() {
        return mobileUserAuthLimit;
    }

    @Override
    public void initLoginUserListByType(int n) {
        int n2;
        List<LoginUser> list;
        if (n == 1) {
            list = LoginUserControl.getFSLoginUserList();
            n2 = this.getUserLimit();
        } else {
            list = LoginUserControl.getMobileLoginUserList();
            n2 = this.getMobileUserAuthLimit();
        }
        if (n2 > 0 && list.isEmpty()) {
            try {
                List list2 = this.getControl().getUserDAO().findAllSortByUserName();
                int n3 = Math.min(list2.size(), n2);
                for (int i = 0; i < n3; ++i) {
                    LoginUser loginUser;
                    String string = ((User)((Object)list2.get(i))).getUsername();
                    if (LoginUserControl.hasLoginUser(string)) {
                        loginUser = LoginUserControl.getLoginUser(string);
                        loginUser.setLoginType(loginUser.getLoginType() | n);
                        LoginUserControl.saveOrUpdateLoginUser(loginUser);
                        continue;
                    }
                    loginUser = new LoginUser(string, n);
                    LoginUserControl.addLoginUser(loginUser);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        } else if (n2 > 0 && list.size() > n2) {
            try {
                for (int i = n2; i < list.size(); ++i) {
                    LoginUser loginUser = list.get(i);
                    int n4 = loginUser.getLoginType() ^ 3;
                    n4 = loginUser.getLoginType() & n4;
                    if (n4 > 0) {
                        loginUser.setLoginType(n4);
                        LoginUserControl.saveOrUpdateLoginUser(loginUser);
                        continue;
                    }
                    LoginUserControl.deleteLoginUser(loginUser);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public long getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(long l) {
        this.xmlVersion = l;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    @Override
    public String getLoginPluginId() {
        return this.pluginId;
    }

    @Override
    public void setLoginPluginId(String string) {
        this.pluginId = string;
    }

    @Override
    public Map<String, Object> getFSParaMap(String string, long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userName", string);
        hashMap.put("jsVersion", ResourceHelper.getJsVersion());
        hashMap.put("cssVersion", ResourceHelper.getCssVersion());
        hashMap.put("position", UserControl.getInstance().getUserDPWithAllDepartment(l));
        hashMap.put("srole", UserControl.getInstance().getAllSRoleNames(l));
        hashMap.put("isRegiste", !ComparatorUtils.equals((byte[])StableUtils.getBytes(), null));
        hashMap.put("registerMail", SiteCenter.getInstance().acquireUrlByKind("register.email", ProductConstants.BUSINESS_EMAIL));
        if (FRContext.getLocale() == Locale.JAPAN || FRContext.getLocale() == Locale.JAPANESE) {
            hashMap.put("registerUrl", SiteCenter.getInstance().acquireUrlByKind("register.jp"));
        } else {
            hashMap.put("registerUrl", SiteCenter.getInstance().acquireUrlByKind("register.url", ProductConstants.REGISTER_URL));
        }
        hashMap.put("hasRegistePrivilege", UserControl.getInstance().hasModulePrivilege(l, 8L));
        hashMap.put("isLicExist", BaseUtils.checkLicExist());
        hashMap.put("authenticateType", this.authenticateObjectType.markType());
        hashMap.put("templatePrivilegeType", PrivilegeManager.getProviderInstance().getPrivilegeFilterType());
        hashMap.put("dataConnectionAuthority", this.authorizeAttr.isDataConnectionAuthority());
        hashMap.put("isAdmin", l == -999L);
        hashMap.put("forceMessage", MessageHelper.getMessageDataAccessObjectCount() > 2);
        hashMap.put("roots", this.getRootInfo(l).toString());
        hashMap.put("isTableDataUser", this.control.getControlType() == 1);
        hashMap.put("supportModules", new JSONArray((Object)PlateFactory.supportModules()));
        hashMap.put("ismobilebinddev", String.valueOf(this.isMobileDeviceBinding()));
        hashMap.put("departmentAllID", CompanyRoleControl.getInstance().getDepartmentAllID());
        hashMap.put("postAllID", CompanyRoleControl.getInstance().getPostAllID());
        hashMap.put("userLimit", this.getUserLimit());
        hashMap.put("mobileUserAuthLimit", this.getMobileUserAuthLimit());
        hashMap.put("pluginId", this.pluginId);
        ThemeFinder themeFinder = (ThemeFinder)ExtraPlatformClassManager.getInstance().getSingle("ThemeFinder");
        if (themeFinder == null) {
            themeFinder = FSOpenEntryService.DefaultThemeFinder.getInstance();
        }
        hashMap.put("theme", themeFinder.find(string).createJSONObject());
        if (this.authorizeAttr != null) {
            this.authorizeAttr.fillAttrToMap(hashMap);
        }
        if (this.systemStyle != null) {
            this.systemStyle.fillAttrToMap(hashMap);
        }
        if (this.systemAttr != null) {
            this.systemAttr.fillAttrToMap(hashMap);
        }
        return hashMap;
    }

    @Override
    public JSONObject getRootInfo(long l) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("modules", (Object)ModuleControl.getInstance().getModuleRootShowInfo(l));
        return jSONObject;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.userDeviceMap.clear();
            this.readAttr(xMLableReader);
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            FSConfigCompatibleProcessor fSConfigCompatibleProcessor = (FSConfigCompatibleProcessor)ExtraPlatformClassManager.getInstance().getSingle("FSConfigCompatibleProcessor");
            if (fSConfigCompatibleProcessor != null) {
                fSConfigCompatibleProcessor.compatibleFSConfigChildNode(xMLableReader, string, this);
            }
            if ("UerDataControl".equals(string)) {
                int n = xMLableReader.getAttrAsInt("type", 0);
                this.control = UserDataControlFactory.create(n);
                xMLableReader.readXMLObject((XMLReadable)this.control);
                this.control.init();
            } else if (ComparatorUtils.equals((String)"systemManagerFavoriteAndADHOCReport", (String)string)) {
                xMLableReader.readXMLObject((XMLReadable)this.sysManagerFvAndAD);
                this.sysManagerFvAndAD.init();
            } else if ("UserDevice".equals(string)) {
                UserDevice userDevice = new UserDevice();
                userDevice.readXML(xMLableReader);
                this.userDeviceMap.put(userDevice.getUsername(), userDevice);
            } else if ("AuthenticateObjectType".equals(string)) {
                this.authenticateObjectType = (AuthenticateObjectType)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
            } else if (string.equals("SystemAttr")) {
                this.systemAttr = new SystemAttr();
                this.systemAttr.readXML(xMLableReader);
            } else if (string.equals("AuthorizeAttr")) {
                this.authorizeAttr = new AuthorizeAttr();
                this.authorizeAttr.readXML(xMLableReader);
            } else if ("fstheme".equals(string)) {
                this.theme = new Theme();
                this.theme.readXML(xMLableReader);
            } else if ("SystemStyle".equals(string)) {
                this.systemStyle = new SystemStyle();
                this.systemStyle.readXML(xMLableReader);
            } else if ("AutoBackupTimerAttr".equals(string)) {
                this.autoBackupTimerAttr = new AutoBackupTimerAttr();
                this.autoBackupTimerAttr.readXML(xMLableReader);
            } else if ("DatabaseAdapterAttr".equals(string)) {
                this.databaseAdapterAttr = new DatabaseAdapterAttr();
                this.databaseAdapterAttr.readXML(xMLableReader);
            } else if (XML_PLUGIN_TAG.equals(string)) {
                this.pluginId = xMLableReader.getAttrAsString("pluginId", "");
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("useFS", this.useFS);
        xMLPrintWriter.attr("mobileDeviceBinding", this.mobileDeviceBinding);
        this.writeSMFavoriteAndADHOCReportXML(xMLPrintWriter);
        xMLPrintWriter.end();
        this.writeMobileUserDevices(xMLPrintWriter);
        this.writeAuthenticateObjectType(xMLPrintWriter);
        this.writeSystemAttr(xMLPrintWriter);
        this.writeAuthorizeAttr(xMLPrintWriter);
        if (this.control != null) {
            xMLPrintWriter.startTAG("UerDataControl");
            xMLPrintWriter.attr("type", this.control.getControlType());
            this.control.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.theme != null) {
            this.theme.writeXML(xMLPrintWriter);
        }
        if (this.systemStyle != null) {
            this.systemStyle.writeXML(xMLPrintWriter);
        }
        if (this.autoBackupTimerAttr != null) {
            this.autoBackupTimerAttr.writeXML(xMLPrintWriter);
        }
        if (this.databaseAdapterAttr != null) {
            this.databaseAdapterAttr.writeXML(xMLPrintWriter);
        }
        if (StringUtils.isNotEmpty((String)this.pluginId)) {
            xMLPrintWriter.startTAG(XML_PLUGIN_TAG);
            xMLPrintWriter.attr("pluginId", this.pluginId);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    private void readAttr(XMLableReader xMLableReader) {
        this.useFS = xMLableReader.getAttrAsBoolean("useFS", false);
        FSConfigCompatibleProcessor fSConfigCompatibleProcessor = (FSConfigCompatibleProcessor)ExtraPlatformClassManager.getInstance().getSingle("FSConfigCompatibleProcessor");
        if (fSConfigCompatibleProcessor != null) {
            fSConfigCompatibleProcessor.compatibleFSConfigAttr(xMLableReader, this);
        } else {
            this.setMobileDeviceBinding(xMLableReader.getAttrAsBoolean("mobileDeviceBinding", false));
        }
        int n = xMLableReader.getAttrAsInt("controlType", 0);
        this.control = n == 1 ? TableDataDAOControl.getInstance() : HSQLDBDAOControl.getInstance();
        this.setNeedUpdate(xMLableReader.getXMLVersion().needVersionUpdate());
        this.setXmlVersion(xMLableReader.getAttrAsLong("xmlVersion", 0L));
    }

    private void writeSystemAttr(XMLPrintWriter xMLPrintWriter) {
        if (this.systemAttr != null) {
            this.systemAttr.writeXML(xMLPrintWriter);
        }
    }

    private void writeAuthorizeAttr(XMLPrintWriter xMLPrintWriter) {
        if (this.authorizeAttr != null) {
            this.authorizeAttr.writeXML(xMLPrintWriter);
        }
    }

    private void writeDatabaseAdapt(XMLPrintWriter xMLPrintWriter) {
        if (this.databaseAdapterAttr != null) {
            this.databaseAdapterAttr.writeXML(xMLPrintWriter);
        }
    }

    private void writeAuthenticateObjectType(XMLPrintWriter xMLPrintWriter) {
        if (this.authenticateObjectType != null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.authenticateObjectType, (String)"AuthenticateObjectType");
        }
    }

    private void writeMobileUserDevices(XMLPrintWriter xMLPrintWriter) {
        for (String string : this.userDeviceMap.keySet()) {
            this.userDeviceMap.get(string).writeXML(xMLPrintWriter);
        }
    }

    private void writeSMFavoriteAndADHOCReportXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("systemManagerFavoriteAndADHOCReport");
        this.sysManagerFvAndAD.writeXML(xMLPrintWriter);
    }

    @Override
    public DatabaseAdapterAttr getDatabaseAdapterAttr() {
        return this.databaseAdapterAttr;
    }

    @Override
    public void setDatabaseAdapterAttr(DatabaseAdapterAttr databaseAdapterAttr) {
        this.databaseAdapterAttr = databaseAdapterAttr;
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
    }

    @Override
    public Collection<UserDevice> getUserDeviceList() {
        return this.userDeviceMap.values();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                fsConfig = null;
            }
        });
        byte[] byArray = StableUtils.getBytes();
        try {
            if (byArray != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LicUtils.decode((byte[])byArray, (OutputStream)byteArrayOutputStream);
                String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                JSONObject jSONObject = new JSONObject(string);
                if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis()) {
                    userLimit = Math.max(0, jSONObject.optInt("FS_USER"));
                    mobileUserAuthLimit = Math.max(0, jSONObject.optInt("MOBILE_FS_USER"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

