/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.ByteOrderInputStream;

public class ByteCountInputStream
extends ByteOrderInputStream {
    private int index;
    private int[] size;
    private long len;

    public ByteCountInputStream(InputStream inputStream, boolean bl, int n2) {
        super(inputStream, bl);
        this.size = new int[n2];
        this.index = -1;
        this.len = 0L;
    }

    public int read() throws IOException {
        if (this.index == -1) {
            ++this.len;
            return super.read();
        }
        if (this.size[this.index] <= 0) {
            return -1;
        }
        int n2 = this.index;
        this.size[n2] = this.size[n2] - 1;
        ++this.len;
        return super.read();
    }

    public void pushBuffer(int n2) {
        if (this.index >= this.size.length - 1) {
            System.err.println("ByteCountInputStream: trying to push more buffers than stackDepth: " + this.size.length);
            return;
        }
        if (this.index >= 0) {
            if (this.size[this.index] < n2) {
                System.err.println("ByteCountInputStream: trying to set a length: " + n2 + ", longer than the underlying buffer: " + this.size[this.index]);
                return;
            }
            int n3 = this.index;
            this.size[n3] = this.size[n3] - n2;
        }
        ++this.index;
        this.size[this.index] = n2;
    }

    public byte[] popBuffer() throws IOException {
        if (this.index >= 0) {
            int n2 = this.size[this.index];
            if (n2 > 0) {
                return this.readByte(n2);
            }
            if (n2 < 0) {
                System.err.println("ByteCountInputStream: Internal Error");
            }
            --this.index;
        }
        return null;
    }

    public long getLength() {
        return this.index >= 0 ? (long)this.size[this.index] : this.len;
    }
}

