/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import org.freehep.util.io.TaggedInputStream;
import org.freehep.util.io.TaggedOutputStream;

public abstract class Action {
    private int code;
    private String name;

    protected Action(int n2) {
        this.code = n2;
        this.name = this.getClass().getName();
        int n3 = this.name.lastIndexOf(".");
        this.name = n3 >= 0 ? this.name.substring(n3 + 1) : this.name;
    }

    public abstract Action read(int var1, TaggedInputStream var2, int var3) throws IOException;

    public abstract void write(int var1, TaggedOutputStream var2) throws IOException;

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Action " + this.getName() + " (" + this.getCode() + ")";
    }

    public static class Unknown
    extends Action {
        private int[] data;

        public Unknown() {
            super(0);
        }

        public Unknown(int n2) {
            super(n2);
        }

        public Action read(int n2, TaggedInputStream taggedInputStream, int n3) throws IOException {
            Unknown unknown = new Unknown(n2);
            unknown.data = taggedInputStream.readUnsignedByte(n3);
            return unknown;
        }

        public void write(int n2, TaggedOutputStream taggedOutputStream) throws IOException {
            taggedOutputStream.writeUnsignedByte(this.data);
        }

        public String toString() {
            return super.toString() + " UNKNOWN!, length " + this.data.length;
        }
    }
}

