/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.EncodingException;

public class ASCIIHexInputStream
extends InputStream {
    private boolean ignoreIllegalChars;
    private boolean endReached;
    private int prev;
    private int lineNo;
    private InputStream in;

    public ASCIIHexInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public ASCIIHexInputStream(InputStream inputStream, boolean bl) {
        this.in = inputStream;
        this.ignoreIllegalChars = bl;
        this.endReached = false;
        this.prev = -1;
        this.lineNo = 1;
    }

    public int read() throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n2 = this.readPart();
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.readPart();
        if (n3 == -1) {
            n3 = 0;
        }
        int n4 = (n2 << 4 | n3) & 0xFF;
        return n4;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private int readPart() throws IOException, EncodingException {
        block23: while (true) {
            int n2 = this.in.read();
            switch (n2) {
                case -1: {
                    this.endReached = true;
                    if (!this.ignoreIllegalChars) {
                        throw new EncodingException("missing '>' at end of ASCII HEX stream");
                    }
                    return -1;
                }
                case 62: {
                    this.endReached = true;
                    return -1;
                }
                case 13: {
                    ++this.lineNo;
                    this.prev = n2;
                    continue block23;
                }
                case 10: {
                    if (this.prev != 13) {
                        ++this.lineNo;
                    }
                    this.prev = n2;
                    continue block23;
                }
                case 0: 
                case 9: 
                case 12: 
                case 32: {
                    this.prev = n2;
                    continue block23;
                }
                case 48: {
                    return 0;
                }
                case 49: {
                    return 1;
                }
                case 50: {
                    return 2;
                }
                case 51: {
                    return 3;
                }
                case 52: {
                    return 4;
                }
                case 53: {
                    return 5;
                }
                case 54: {
                    return 6;
                }
                case 55: {
                    return 7;
                }
                case 56: {
                    return 8;
                }
                case 57: {
                    return 9;
                }
                case 65: 
                case 97: {
                    return 10;
                }
                case 66: 
                case 98: {
                    return 11;
                }
                case 67: 
                case 99: {
                    return 12;
                }
                case 68: 
                case 100: {
                    return 13;
                }
                case 69: 
                case 101: {
                    return 14;
                }
                case 70: 
                case 102: {
                    return 15;
                }
            }
            if (!this.ignoreIllegalChars) {
                throw new EncodingException("Illegal char " + n2 + " in HexStream");
            }
            this.prev = n2;
        }
    }
}

