/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.ASCII85;
import org.freehep.util.io.FinishableOutputStream;

public class ASCII85OutputStream
extends FilterOutputStream
implements ASCII85,
FinishableOutputStream {
    private boolean end = false;
    private int characters = 80;
    private int[] b = new int[4];
    private int bIndex = 0;
    private int[] c = new int[5];
    private String newline = "\n";

    public ASCII85OutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this.newline = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void write(int n2) throws IOException {
        this.b[this.bIndex] = n2 & 0xFF;
        ++this.bIndex;
        if (this.bIndex >= this.b.length) {
            this.writeTuple();
            this.bIndex = 0;
        }
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            if (this.bIndex > 0) {
                this.writeTuple();
            }
            this.writeEOD();
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeTuple() throws IOException {
        for (int i2 = this.bIndex; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        long l2 = (long)(this.b[0] << 24 | this.b[1] << 16 | this.b[2] << 8 | this.b[3]) & 0xFFFFFFFFL;
        this.c[0] = (int)(l2 / 52200625L + 33L);
        this.c[1] = (int)((l2 %= 52200625L) / 614125L + 33L);
        this.c[2] = (int)((l2 %= 614125L) / 7225L + 33L);
        this.c[3] = (int)((l2 %= 7225L) / 85L + 33L);
        this.c[4] = (int)(l2 % 85L + 33L);
        if (this.bIndex >= this.b.length && this.c[0] == 33 && this.c[1] == 33 && this.c[2] == 33 && this.c[3] == 33 && this.c[4] == 33) {
            this.writeChar(122);
        } else {
            for (int i3 = 0; i3 < this.bIndex + 1; ++i3) {
                this.writeChar(this.c[i3]);
            }
        }
    }

    private void writeEOD() throws IOException {
        if (this.characters <= 1) {
            this.characters = 80;
            this.writeNewLine();
        }
        this.characters -= 2;
        super.write(126);
        super.write(62);
    }

    private void writeChar(int n2) throws IOException {
        if (this.characters == 0) {
            this.characters = 80;
            this.writeNewLine();
        }
        --this.characters;
        super.write(n2);
    }

    private void writeNewLine() throws IOException {
        for (int i2 = 0; i2 < this.newline.length(); ++i2) {
            super.write(this.newline.charAt(i2));
        }
    }
}

