/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SoundEnvelope;

public class SoundInfo {
    private boolean syncStop;
    private boolean syncNoMultiple;
    private long inPoint = -1L;
    private long outPoint = -1L;
    private int loop = -1;
    private SoundEnvelope[] envelope;

    public SoundInfo(boolean bl, boolean bl2, long l2, long l3, int n2, SoundEnvelope[] soundEnvelopeArray) {
        this.syncStop = bl;
        this.syncNoMultiple = bl2;
        this.inPoint = l2;
        this.outPoint = l3;
        this.loop = n2;
        this.envelope = soundEnvelopeArray;
    }

    public SoundInfo(SWFInputStream sWFInputStream) throws IOException {
        sWFInputStream.readUBits(2);
        this.syncStop = sWFInputStream.readBitFlag();
        this.syncNoMultiple = sWFInputStream.readBitFlag();
        boolean bl = sWFInputStream.readBitFlag();
        boolean bl2 = sWFInputStream.readBitFlag();
        boolean bl3 = sWFInputStream.readBitFlag();
        boolean bl4 = sWFInputStream.readBitFlag();
        if (bl4) {
            this.inPoint = sWFInputStream.readUnsignedInt();
        }
        if (bl3) {
            this.outPoint = sWFInputStream.readUnsignedInt();
        }
        if (bl2) {
            this.loop = sWFInputStream.readUnsignedShort();
        }
        if (bl) {
            int n2 = sWFInputStream.readUnsignedByte();
            this.envelope = new SoundEnvelope[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.envelope[i2] = new SoundEnvelope(sWFInputStream);
            }
        }
    }

    public void write(SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUBits(0L, 2);
        sWFOutputStream.writeBitFlag(this.syncStop);
        sWFOutputStream.writeBitFlag(this.syncNoMultiple);
        sWFOutputStream.writeBitFlag(this.envelope != null);
        sWFOutputStream.writeBitFlag(this.loop >= 0);
        sWFOutputStream.writeBitFlag(this.outPoint >= 0L);
        sWFOutputStream.writeBitFlag(this.inPoint >= 0L);
        if (this.inPoint >= 0L) {
            sWFOutputStream.writeUnsignedInt(this.inPoint);
        }
        if (this.outPoint >= 0L) {
            sWFOutputStream.writeUnsignedInt(this.outPoint);
        }
        if (this.loop >= 0) {
            sWFOutputStream.writeUnsignedShort(this.loop);
        }
        if (this.envelope != null) {
            sWFOutputStream.writeUnsignedByte(this.envelope.length);
            for (int i2 = 0; i2 < this.envelope.length; ++i2) {
                this.envelope[i2].write(sWFOutputStream);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SoundInfo ");
        stringBuffer.append("syncStop: " + this.syncStop);
        stringBuffer.append(", syncNoMultiple: " + this.syncNoMultiple);
        stringBuffer.append(", in: " + this.inPoint);
        stringBuffer.append(", out: " + this.outPoint);
        stringBuffer.append(", loop: " + this.loop);
        if (this.envelope != null) {
            stringBuffer.append(" [");
            for (int i2 = 0; i2 < this.envelope.length; ++i2) {
                stringBuffer.append(this.envelope[i2]);
                stringBuffer.append(" ");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

