/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.swf.FileAttributes;
import org.freehep.graphicsio.swf.SWFActionSet;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFHeader;
import org.freehep.graphicsio.swf.SWFTagSet;
import org.freehep.graphicsio.swf.ShowFrame;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedOutputStream;

public class SWFOutputStream
extends TaggedOutputStream
implements SWFConstants {
    private Dimension size;
    private float frameRate;
    private int frameCount = 0;
    private boolean compress;
    private static final AffineTransform identityMatrix = new AffineTransform();

    public SWFOutputStream(OutputStream outputStream, Dimension dimension, float f2, boolean bl) throws IOException {
        this(outputStream, 8, dimension, f2, bl);
    }

    public SWFOutputStream(OutputStream outputStream, int n2, Dimension dimension, float f2, boolean bl) throws IOException {
        this(outputStream, new SWFTagSet(n2), new SWFActionSet(n2), dimension, f2, bl);
    }

    public SWFOutputStream(OutputStream outputStream, SWFTagSet sWFTagSet, SWFActionSet sWFActionSet, Dimension dimension, float f2, boolean bl) throws IOException {
        super(outputStream, sWFTagSet, sWFActionSet, true);
        this.size = dimension;
        this.frameRate = f2;
        this.compress = bl;
        this.pushBuffer();
        this.writeTag(new FileAttributes());
    }

    public void close() throws IOException {
        long l2 = this.popBuffer() + SWFHeader.size();
        SWFHeader sWFHeader = new SWFHeader(this.getVersion(), l2, this.size, this.frameRate, this.frameCount, this.compress);
        this.writeHeader(sWFHeader);
        this.append();
        super.close();
    }

    public void writeTag(ShowFrame showFrame) throws IOException {
        ++this.frameCount;
        super.writeTag(showFrame);
    }

    public void writeFixed(double d2) throws IOException {
        this.byteAlign();
        long l2 = (long)d2;
        long l3 = (long)((d2 - (double)l2) * 65536.0);
        long l4 = (l2 & 0xFFFFL) << 16 | l3 & 0xFFFFL;
        this.writeUnsignedInt(l4);
    }

    public void writeFixed8(double d2) throws IOException {
        this.byteAlign();
        int n2 = (int)d2;
        int n3 = (int)((d2 - (double)n2) * 256.0);
        int n4 = (n2 & 0xFF) << 8 | n3 & 0xFF;
        this.writeUnsignedShort(n4);
    }

    public void writeRect(Rectangle2D rectangle2D) throws IOException {
        int n2 = 0;
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(rectangle2D.getMinX() * 20.0), true));
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(rectangle2D.getMaxX() * 20.0), true));
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(rectangle2D.getMinY() * 20.0), true));
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(rectangle2D.getMaxY() * 20.0), true));
        this.writeRect(rectangle2D, n2);
    }

    public void writeRect(Rectangle2D rectangle2D, int n2) throws IOException {
        this.byteAlign();
        this.writeUBits(n2, 5);
        this.writeSBits((int)(rectangle2D.getMinX() * 20.0), n2);
        this.writeSBits((int)(rectangle2D.getMaxX() * 20.0), n2);
        this.writeSBits((int)(rectangle2D.getMinY() * 20.0), n2);
        this.writeSBits((int)(rectangle2D.getMaxY() * 20.0), n2);
    }

    public void writeColor(Color color, boolean bl) throws IOException {
        this.byteAlign();
        this.writeUnsignedByte(color.getRed());
        this.writeUnsignedByte(color.getGreen());
        this.writeUnsignedByte(color.getBlue());
        if (bl) {
            this.writeUnsignedByte(color.getAlpha());
        }
    }

    public void writeMatrix(AffineTransform affineTransform) throws IOException {
        int n2;
        if (affineTransform == null) {
            affineTransform = identityMatrix;
        }
        this.byteAlign();
        if (affineTransform.getScaleX() != 1.0 || affineTransform.getScaleY() != 1.0) {
            this.writeBitFlag(true);
            n2 = 0;
            n2 = Math.max(n2, SWFOutputStream.minBits((float)affineTransform.getScaleX()));
            n2 = Math.max(n2, SWFOutputStream.minBits((float)affineTransform.getScaleY()));
            this.writeUBits(n2, 5);
            this.writeFBits((float)affineTransform.getScaleX(), n2);
            this.writeFBits((float)affineTransform.getScaleY(), n2);
        } else {
            this.writeBitFlag(false);
        }
        if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
            this.writeBitFlag(true);
            n2 = 0;
            n2 = Math.max(n2, SWFOutputStream.minBits((float)affineTransform.getShearY()));
            n2 = Math.max(n2, SWFOutputStream.minBits((float)affineTransform.getShearX()));
            this.writeUBits(n2, 5);
            this.writeFBits((float)affineTransform.getShearY(), n2);
            this.writeFBits((float)affineTransform.getShearX(), n2);
        } else {
            this.writeBitFlag(false);
        }
        n2 = 0;
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(affineTransform.getTranslateX() * 20.0), true));
        n2 = Math.max(n2, SWFOutputStream.minBits((int)(affineTransform.getTranslateY() * 20.0), true));
        this.writeUBits(n2, 5);
        this.writeSBits((int)(affineTransform.getTranslateX() * 20.0), n2);
        this.writeSBits((int)(affineTransform.getTranslateY() * 20.0), n2);
    }

    public void writeString(String string) throws IOException {
        if (this.getVersion() >= 6) {
            this.writeUTF(string);
            this.writeByte(0);
        } else {
            this.writeAsciiZString(string);
        }
    }

    public void writeLanguageCode(int n2) throws IOException {
        this.writeUnsignedByte(n2);
    }

    protected void writeTagHeader(TagHeader tagHeader) throws IOException {
        this.byteAlign();
        int n2 = tagHeader.getTag() << 6;
        if (tagHeader.getLength() >= 63L) {
            this.writeUnsignedShort(n2 |= 0x3F);
            this.writeUnsignedInt(tagHeader.getLength());
        } else {
            n2 = (int)((long)n2 | tagHeader.getLength());
            this.writeUnsignedShort(n2);
        }
    }

    protected void writeActionHeader(ActionHeader actionHeader) throws IOException {
        int n2 = actionHeader.getAction();
        long l2 = actionHeader.getLength();
        this.writeUnsignedByte(n2);
        if ((n2 & 0x80) > 0) {
            this.writeUnsignedShort((int)l2);
        }
    }

    public void writeHeader(SWFHeader sWFHeader) throws IOException {
        sWFHeader.write(this);
    }

    public int getVersion() {
        return ((SWFTagSet)this.tagSet).getVersion();
    }
}

