/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.swf.Gradient;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class FillStyle {
    public static final int SOLID = 0;
    public static final int LINEAR_GRADIENT = 16;
    public static final int RADIAL_GRADIENT = 18;
    public static final int FOCAL_GRADIENT = 19;
    public static final int TILED_BITMAP = 64;
    public static final int CLIPPED_BITMAP = 65;
    public static final int TILED_BITMAP_NOT_SMOOTHED = 66;
    public static final int CLIPPED_BITMAP_NOT_SMOOTHED = 67;
    public static final int SPREAD_MODE_PAD = 0;
    public static final int SPREAD_MODE_REFLECT = 1;
    public static final int SPREAD_MODE_REPEAT = 2;
    public static final int INTERPOLATION_MODE_NORMAL_RGB = 0;
    public static final int INTERPOLATION_MODE_LINEAR_RGB = 1;
    private int type;
    private Color color;
    private Color endColor;
    private AffineTransform matrix;
    private AffineTransform endMatrix;
    private Gradient[] gradient;
    private int spreadMode;
    private int interpolationMode;
    private float focalPoint;
    private int bitmap;

    public FillStyle(Color color) {
        this.type = 0;
        this.color = color;
    }

    public FillStyle(Color color, Color color2) {
        this(color);
        this.endColor = color2;
    }

    public FillStyle(Gradient[] gradientArray, boolean bl, AffineTransform affineTransform) {
        this(gradientArray, 16, 0, 0, 0.0f, affineTransform);
    }

    public FillStyle(Gradient[] gradientArray, int n2, int n3, int n4, float f2, AffineTransform affineTransform) {
        this.type = n2;
        this.gradient = gradientArray;
        this.spreadMode = n3;
        this.interpolationMode = n4;
        this.focalPoint = f2;
        this.matrix = affineTransform;
    }

    public FillStyle(Gradient[] gradientArray, boolean bl, AffineTransform affineTransform, AffineTransform affineTransform2) {
        this(gradientArray, bl, affineTransform);
        this.endMatrix = affineTransform2;
    }

    public FillStyle(int n2, boolean bl, AffineTransform affineTransform) {
        this.type = bl ? 64 : 65;
        this.bitmap = n2;
        this.matrix = affineTransform;
    }

    public FillStyle(int n2, boolean bl, AffineTransform affineTransform, AffineTransform affineTransform2) {
        this(n2, bl, affineTransform);
        this.endMatrix = affineTransform2;
    }

    public FillStyle(SWFInputStream sWFInputStream, boolean bl, boolean bl2) throws IOException {
        this.type = sWFInputStream.readUnsignedByte();
        switch (this.type) {
            case 0: {
                this.color = sWFInputStream.readColor(bl2);
                if (!bl) break;
                this.endColor = sWFInputStream.readColor(bl2);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                this.matrix = sWFInputStream.readMatrix();
                if (bl) {
                    this.endMatrix = sWFInputStream.readMatrix();
                }
                sWFInputStream.byteAlign();
                this.spreadMode = (int)sWFInputStream.readUBits(2);
                this.interpolationMode = (int)sWFInputStream.readUBits(2);
                int n2 = (int)sWFInputStream.readUBits(4);
                this.gradient = new Gradient[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.gradient[i2] = new Gradient(sWFInputStream, bl, bl2);
                }
                if (this.type != 19) break;
                this.focalPoint = sWFInputStream.readFixed8();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.bitmap = sWFInputStream.readUnsignedShort();
                this.matrix = sWFInputStream.readMatrix();
                if (!bl) break;
                this.endMatrix = sWFInputStream.readMatrix();
                break;
            }
            default: {
                System.err.println("FillStyle type " + this.type + " not implemented.");
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void write(SWFOutputStream sWFOutputStream, boolean bl, boolean bl2) throws IOException {
        sWFOutputStream.writeUnsignedByte(this.type);
        switch (this.type) {
            case 0: {
                sWFOutputStream.writeColor(this.color, bl2 || this.endColor != null);
                if (this.endColor == null) break;
                sWFOutputStream.writeColor(this.endColor, true);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                sWFOutputStream.writeMatrix(this.matrix);
                if (bl) {
                    sWFOutputStream.writeMatrix(this.endMatrix);
                }
                sWFOutputStream.byteAlign();
                sWFOutputStream.writeUBits(this.spreadMode, 2);
                sWFOutputStream.writeUBits(this.interpolationMode, 2);
                sWFOutputStream.writeUBits(this.gradient.length, 4);
                for (int i2 = 0; i2 < this.gradient.length; ++i2) {
                    this.gradient[i2].write(sWFOutputStream, bl, bl2);
                }
                if (this.type != 19) break;
                sWFOutputStream.writeFixed8(this.focalPoint);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                sWFOutputStream.writeUnsignedShort(this.bitmap);
                sWFOutputStream.writeMatrix(this.matrix);
                if (!bl) break;
                sWFOutputStream.writeMatrix(this.endMatrix);
                break;
            }
            default: {
                System.err.println("FillStyle type " + this.type + " not implemented.");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("Solid: ");
                stringBuffer.append(this.color);
                if (this.endColor == null) break;
                stringBuffer.append("; " + this.endColor);
                break;
            }
            case 16: 
            case 18: {
                stringBuffer.append("Gradient: ");
                for (int i2 = 0; i2 < this.gradient.length; ++i2) {
                    stringBuffer.append(this.gradient[i2]);
                    stringBuffer.append("; ");
                }
                stringBuffer.append(this.matrix);
                if (this.endMatrix == null) break;
                stringBuffer.append("; " + this.endMatrix);
                break;
            }
            case 64: 
            case 65: {
                stringBuffer.append("BitMap: ");
                stringBuffer.append(this.bitmap);
                stringBuffer.append(", ");
                stringBuffer.append(this.matrix);
                if (this.endMatrix == null) break;
                stringBuffer.append("; " + this.endMatrix);
                break;
            }
            default: {
                stringBuffer.append("Unknown Type:");
                stringBuffer.append(this.type);
            }
        }
        return stringBuffer.toString();
    }
}

