/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont2
extends DefinitionTag
implements SWFConstants {
    private int character;
    private boolean shiftJIS = false;
    private boolean ansi = false;
    private boolean wideOffsets = false;
    private boolean wideCodes = false;
    private boolean italic = false;
    private boolean bold = false;
    private int languageCode;
    private String name;
    private long[] offsets;
    private long codeOffset;
    private SWFShape[] shapes;
    private int[] codes;
    private int ascent;
    private int descent;
    private int leading;
    private short[] advances;
    private Rectangle2D[] bounds;
    private KerningRecord[] kerning = new KerningRecord[0];

    public DefineFont2() {
        super(48, 3);
    }

    public DefineFont2(int n2, boolean bl, boolean bl2, String string, SWFShape[] sWFShapeArray, int[] nArray) {
        this(n2, false, false, bl, bl2, true, true, 1, string, sWFShapeArray, nArray, 0, 0, 0, null, null, null);
    }

    public DefineFont2(int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n3, String string, SWFShape[] sWFShapeArray, int[] nArray, int n4, int n5, int n6, short[] sArray, Rectangle2D[] rectangle2DArray, KerningRecord[] kerningRecordArray) {
        this();
        this.character = n2;
        this.shiftJIS = bl;
        this.ansi = bl2;
        this.italic = bl3;
        this.bold = bl4;
        this.wideOffsets = bl5;
        this.wideCodes = bl6;
        this.languageCode = n3;
        this.name = string;
        this.shapes = sWFShapeArray;
        this.codes = nArray;
        this.ascent = n4;
        this.descent = n5;
        this.leading = n6;
        this.advances = sArray;
        this.bounds = rectangle2DArray;
        this.kerning = kerningRecordArray;
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        int n4;
        DefineFont2 defineFont2 = new DefineFont2();
        defineFont2.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineFont2.character, defineFont2);
        boolean bl = sWFInputStream.readBitFlag();
        defineFont2.shiftJIS = sWFInputStream.readBitFlag();
        sWFInputStream.readBitFlag();
        defineFont2.ansi = sWFInputStream.readBitFlag();
        defineFont2.wideOffsets = sWFInputStream.readBitFlag();
        defineFont2.wideCodes = sWFInputStream.readBitFlag();
        defineFont2.italic = sWFInputStream.readBitFlag();
        defineFont2.bold = sWFInputStream.readBitFlag();
        defineFont2.languageCode = sWFInputStream.readLanguageCode();
        int n5 = sWFInputStream.readUnsignedByte();
        defineFont2.name = sWFInputStream.getVersion() >= 6 ? sWFInputStream.readUTF() : new String(sWFInputStream.readByte(n5));
        int n6 = sWFInputStream.readUnsignedShort();
        defineFont2.offsets = new long[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            defineFont2.offsets[n4] = defineFont2.wideOffsets ? sWFInputStream.readUnsignedInt() : (long)sWFInputStream.readUnsignedShort();
        }
        defineFont2.codeOffset = defineFont2.wideOffsets ? sWFInputStream.readUnsignedInt() : (long)sWFInputStream.readUnsignedShort();
        defineFont2.shapes = new SWFShape[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            defineFont2.shapes[n4] = new SWFShape(sWFInputStream);
        }
        int[] nArray = defineFont2.codes = defineFont2.wideCodes ? sWFInputStream.readUnsignedShort(n6) : sWFInputStream.readUnsignedByte(n6);
        if (bl) {
            defineFont2.ascent = sWFInputStream.readShort();
            defineFont2.descent = sWFInputStream.readShort();
            defineFont2.leading = sWFInputStream.readShort();
            defineFont2.advances = sWFInputStream.readShort(n6);
            defineFont2.bounds = new Rectangle2D[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                defineFont2.bounds[n4] = sWFInputStream.readRect();
            }
            n4 = sWFInputStream.readUnsignedShort();
            defineFont2.kerning = new KerningRecord[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                defineFont2.kerning[i2] = new KerningRecord(sWFInputStream, defineFont2.wideCodes);
            }
        }
        return defineFont2;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        int n3;
        boolean bl = this.ascent != 0 || this.descent != 0 || this.leading != 0 || this.advances != null || this.bounds != null || this.kerning != null;
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeBitFlag(bl);
        sWFOutputStream.writeBitFlag(this.shiftJIS);
        sWFOutputStream.writeUBits(0L, 1);
        sWFOutputStream.writeBitFlag(this.ansi);
        sWFOutputStream.writeBitFlag(this.wideOffsets);
        sWFOutputStream.writeBitFlag(this.wideCodes);
        sWFOutputStream.writeBitFlag(this.italic);
        sWFOutputStream.writeBitFlag(this.bold);
        if (sWFOutputStream.getVersion() >= 6) {
            sWFOutputStream.writeLanguageCode(this.languageCode);
        } else {
            sWFOutputStream.writeUnsignedByte(0);
        }
        sWFOutputStream.writeUnsignedByte(this.name.length());
        if (sWFOutputStream.getVersion() >= 6) {
            sWFOutputStream.writeUTF(this.name);
        } else {
            sWFOutputStream.writeByte(this.name.getBytes());
        }
        sWFOutputStream.pushBuffer();
        int[] nArray = new int[this.shapes.length];
        int n4 = this.wideOffsets ? 4 : 2;
        n4 = (nArray.length + 1) * n4;
        for (n3 = 0; n3 < this.shapes.length; ++n3) {
            nArray[n3] = sWFOutputStream.getBufferLength() + n4;
            this.shapes[n3].write(sWFOutputStream);
            sWFOutputStream.byteAlign();
        }
        this.codeOffset = sWFOutputStream.getBufferLength() + n4;
        sWFOutputStream.popBuffer();
        sWFOutputStream.writeUnsignedShort(nArray.length);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (this.wideOffsets) {
                sWFOutputStream.writeUnsignedInt(nArray[n3]);
                continue;
            }
            sWFOutputStream.writeUnsignedShort(nArray[n3]);
        }
        if (this.wideOffsets) {
            sWFOutputStream.writeUnsignedInt(this.codeOffset);
        } else {
            sWFOutputStream.writeUnsignedShort((int)this.codeOffset);
        }
        sWFOutputStream.append();
        if (this.wideCodes) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                sWFOutputStream.writeUnsignedShort(this.codes[n3]);
            }
        } else {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                sWFOutputStream.writeUnsignedByte(this.codes[n3]);
            }
        }
        if (bl) {
            sWFOutputStream.writeShort(this.ascent);
            sWFOutputStream.writeShort(this.descent);
            sWFOutputStream.writeShort(this.leading);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                sWFOutputStream.writeShort(this.advances[n3]);
            }
            for (n3 = 0; n3 < this.bounds.length; ++n3) {
                sWFOutputStream.writeRect(this.bounds[n3]);
            }
            sWFOutputStream.writeUnsignedShort(this.kerning.length);
            for (n3 = 0; n3 < this.kerning.length; ++n3) {
                this.kerning[n3].write(sWFOutputStream, this.wideCodes);
            }
        }
    }

    public long getId() {
        return this.character;
    }

    public boolean getShiftJIS() {
        return this.shiftJIS;
    }

    public boolean isAnsi() {
        return this.ansi;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean hasWideOffsets() {
        return this.wideOffsets;
    }

    public boolean hasWideCodes() {
        return this.wideCodes;
    }

    public String getName() {
        return this.name;
    }

    public SWFShape[] getShapes() {
        return this.shapes;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public short[] getAdvances() {
        return this.advances;
    }

    public Rectangle2D[] getBounds() {
        return this.bounds;
    }

    public KerningRecord[] getKerning() {
        return this.kerning;
    }

    public void setId(int n2) {
        this.character = n2;
    }

    public void setShiftJIS(boolean bl) {
        this.shiftJIS = bl;
    }

    public void setAnsi(boolean bl) {
        this.ansi = bl;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public void setWideOffsets(boolean bl) {
        this.wideOffsets = bl;
    }

    public void setWideCodes(boolean bl) {
        this.wideCodes = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCodes(int[] nArray) {
        this.codes = nArray;
    }

    public void setShapes(SWFShape[] sWFShapeArray) {
        this.shapes = sWFShapeArray;
    }

    public void setAscent(int n2) {
        this.ascent = n2;
    }

    public void setDescent(int n2) {
        this.descent = n2;
    }

    public void setLeading(int n2) {
        this.leading = n2;
    }

    public void setAdvances(short[] sArray) {
        this.advances = sArray;
    }

    public void setAdvances(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        this.setAdvances(sArray);
    }

    public void setBounds(Rectangle2D[] rectangle2DArray) {
        this.bounds = rectangle2DArray;
    }

    public void setKerning(KerningRecord[] kerningRecordArray) {
        this.kerning = kerningRecordArray;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  name: " + this.name + "\n");
        if (this.shiftJIS) {
            stringBuffer.append("  shiftJIS\n");
        }
        if (this.ansi) {
            stringBuffer.append("  ansi\n");
        }
        if (this.italic) {
            stringBuffer.append("  italic\n");
        }
        if (this.bold) {
            stringBuffer.append("  bold\n");
        }
        if (this.wideOffsets) {
            stringBuffer.append("  wideOffsets\n");
        }
        if (this.wideCodes) {
            stringBuffer.append("  wideCodes\n");
        }
        if (this.languageCode > 0) {
            stringBuffer.append("  languageCode: " + this.languageCode + "\n");
        }
        if (this.ascent != 0) {
            stringBuffer.append("  ascent: " + this.ascent + "\n");
        }
        if (this.descent != 0) {
            stringBuffer.append("  descent: " + this.descent + "\n");
        }
        if (this.leading != 0) {
            stringBuffer.append("  leading: " + this.leading + "\n");
        }
        if (this.advances != null) {
            for (n2 = 0; n2 < this.advances.length; ++n2) {
                stringBuffer.append("  advances[" + n2 + "]: " + this.advances[n2] + "\n");
            }
        }
        if (this.bounds != null) {
            for (n2 = 0; n2 < this.bounds.length; ++n2) {
                stringBuffer.append("  bounds[" + n2 + "]: " + this.bounds[n2] + "\n");
            }
        }
        stringBuffer.append("  glyphCount: " + this.shapes.length + "\n");
        for (n2 = 0; n2 < this.shapes.length; ++n2) {
            stringBuffer.append("  >>> Shape " + n2 + "\n");
            stringBuffer.append(this.shapes[n2] + "\n");
        }
        return stringBuffer.toString();
    }

    public static class KerningRecord {
        private int code1;
        private int code2;
        private int adjustment;

        public KerningRecord(int n2, int n3, int n4) {
            this.code1 = n2;
            this.code2 = n3;
            this.adjustment = n4;
        }

        public KerningRecord(SWFInputStream sWFInputStream, boolean bl) throws IOException {
            this.code1 = bl ? sWFInputStream.readUnsignedShort() : sWFInputStream.readUnsignedByte();
            this.code2 = bl ? sWFInputStream.readUnsignedShort() : sWFInputStream.readUnsignedByte();
            this.adjustment = sWFInputStream.readShort();
        }

        public void write(SWFOutputStream sWFOutputStream, boolean bl) throws IOException {
            if (bl) {
                sWFOutputStream.writeUnsignedShort(this.code1);
            } else {
                sWFOutputStream.writeUnsignedByte(this.code1);
            }
            if (bl) {
                sWFOutputStream.writeUnsignedShort(this.code2);
            } else {
                sWFOutputStream.writeUnsignedByte(this.code2);
            }
            sWFOutputStream.writeShort(this.adjustment);
        }

        public String toString() {
            return "Kerning[" + this.code1 + ", " + this.code2 + ", " + this.adjustment + "]";
        }
    }
}

