/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineEditText
extends DefinitionTag {
    private int character;
    private Rectangle2D bounds;
    private boolean disableEditting;
    private boolean password;
    private boolean multiLine;
    private boolean wordWrap;
    private boolean drawBox;
    private boolean disableSelection;
    private int fontID;
    private int height;
    private Color color;
    private int maxLength = -1;
    private int alignment;
    private int leftMargin;
    private int rightMargin;
    private int indent;
    private int lineSpace;
    private String variable;
    private String initialText;

    public DefineEditText() {
        super(37, 4);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineEditText defineEditText = new DefineEditText();
        defineEditText.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineEditText.character, defineEditText);
        defineEditText.bounds = sWFInputStream.readRect();
        int n4 = sWFInputStream.readUnsignedShort();
        boolean bl = (n4 & 2) > 0;
        defineEditText.disableEditting = (n4 & 8) > 0;
        defineEditText.password = (n4 & 0x10) > 0;
        defineEditText.multiLine = (n4 & 0x20) > 0;
        defineEditText.wordWrap = (n4 & 0x40) > 0;
        boolean bl2 = (n4 & 0x80) > 0;
        defineEditText.drawBox = (n4 & 0x800) > 0;
        defineEditText.disableSelection = (n4 & 0x1000) > 0;
        defineEditText.fontID = sWFInputStream.readUnsignedShort();
        defineEditText.height = sWFInputStream.readUnsignedShort();
        defineEditText.color = sWFInputStream.readColor(true);
        if (bl) {
            defineEditText.maxLength = sWFInputStream.readUnsignedShort();
        }
        defineEditText.alignment = sWFInputStream.readUnsignedByte();
        defineEditText.leftMargin = sWFInputStream.readUnsignedShort();
        defineEditText.rightMargin = sWFInputStream.readUnsignedShort();
        defineEditText.indent = sWFInputStream.readUnsignedShort();
        defineEditText.lineSpace = sWFInputStream.readUnsignedShort();
        defineEditText.variable = sWFInputStream.readString();
        if (bl2) {
            defineEditText.initialText = sWFInputStream.readString();
        }
        return defineEditText;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeRect(this.bounds);
        int n3 = 0;
        if (this.maxLength >= 0) {
            n3 |= 2;
        }
        if (this.disableEditting) {
            n3 |= 8;
        }
        if (this.password) {
            n3 |= 0x10;
        }
        if (this.multiLine) {
            n3 |= 0x20;
        }
        if (this.wordWrap) {
            n3 |= 0x40;
        }
        if (this.initialText != null) {
            n3 |= 0x80;
        }
        if (this.drawBox) {
            n3 |= 0x800;
        }
        if (this.disableSelection) {
            n3 |= 0x1000;
        }
        sWFOutputStream.writeUnsignedShort(n3);
        sWFOutputStream.writeUnsignedShort(this.fontID);
        sWFOutputStream.writeUnsignedShort(this.height);
        sWFOutputStream.writeColor(this.color, true);
        if (this.maxLength >= 0) {
            sWFOutputStream.writeUnsignedShort(this.maxLength);
        }
        sWFOutputStream.writeUnsignedByte(this.alignment);
        sWFOutputStream.writeUnsignedShort(this.leftMargin);
        sWFOutputStream.writeUnsignedShort(this.rightMargin);
        sWFOutputStream.writeUnsignedShort(this.indent);
        sWFOutputStream.writeUnsignedShort(this.lineSpace);
        sWFOutputStream.writeString(this.variable);
        if (this.initialText != null) {
            sWFOutputStream.writeString(this.initialText);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  ...\n");
        return stringBuffer.toString();
    }
}

