/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefineBitsJPEG2;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsJPEG3
extends DefineBitsJPEG2 {
    private byte[] imageBytes;
    private int imageLength;
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    private static final String[] alwaysCompressedFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "GIF".toLowerCase()};

    public DefineBitsJPEG3(int n2, Image image, Properties properties, Color color, ImageObserver imageObserver) {
        this(n2, ImageUtilities.createRenderedImage(image, imageObserver, color), color, properties);
    }

    public DefineBitsJPEG3(int n2, RenderedImage renderedImage, Color color, Properties properties) {
        this();
        this.character = n2;
        this.image = renderedImage;
        this.options = properties;
    }

    public DefineBitsJPEG3() {
        super(35, 3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineBitsJPEG3 defineBitsJPEG3 = new DefineBitsJPEG3();
        defineBitsJPEG3.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineBitsJPEG3.character, defineBitsJPEG3);
        int n4 = (int)sWFInputStream.readUnsignedInt();
        byte[] byArray = sWFInputStream.readByte(n4);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedImage bufferedImage = DefineBitsJPEG3.readImage("JPG".toLowerCase(), byteArrayInputStream);
        if (byteArrayInputStream.available() > 0) {
            System.err.println("DefineBitsJPEG3: not all bytes read: " + byteArrayInputStream.available());
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        InflaterInputStream inflaterInputStream = new InflaterInputStream(sWFInputStream);
        byte[] byArray2 = new byte[n5 * n6];
        inflaterInputStream.read(byArray2);
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                writableRaster.setPixel(n8, n7, new int[]{byArray2[n7 * n5 + n8]});
                ++n8;
            }
            ++n7;
        }
        defineBitsJPEG3.image = bufferedImage;
        return defineBitsJPEG3;
    }

    public static BufferedImage readImage(String string, InputStream inputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string.toLowerCase());
        if (!iterator.hasNext()) {
            throw new IOException(": No reader for format '" + string + "'.");
        }
        ImageReader imageReader = iterator.next();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream, true);
        BufferedImage bufferedImage = imageReader.read(0);
        imageReader.dispose();
        imageInputStream.close();
        return bufferedImage;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeUnsignedInt(this.imageLength);
        sWFOutputStream.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 2;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            byte[] byArray = DefineBitsJPEG3.toByteArray(this.image, "JPG", null, null);
            this.imageLength = byArray.length;
            byte[] byArray2 = DefineBitsJPEG3.toByteArray(this.image, "RAW", "Flate", DefineBitsJPEG3.getRAWProperties(Color.black, "A"));
            this.imageBytes = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, this.imageBytes, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.imageBytes, byArray.length, byArray2.length);
        }
        return this.imageBytes;
    }

    public static UserProperties getRAWProperties(Color color, String string) {
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(RawImageWriteParam.BACKGROUND, color);
        userProperties.setProperty(RawImageWriteParam.CODE, string);
        userProperties.setProperty(RawImageWriteParam.PAD, 1);
        return userProperties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(super.toString()) + "\n");
        stringBuffer.append("  character:   " + this.character + "\n");
        stringBuffer.append("  image:      " + this.image + "\n");
        return stringBuffer.toString();
    }

    public static byte[] toByteArray(RenderedImage renderedImage, String string, String string2, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = byteArrayOutputStream;
        if ("ASCII85".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new ASCII85OutputStream(outputStream);
        }
        if ("Flate".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new FlateOutputStream(outputStream);
        }
        if (properties == null) {
            properties = new Properties();
        }
        DefineBitsJPEG3.writeImage(renderedImage, string.toLowerCase(), properties, outputStream);
        outputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeImage(RenderedImage renderedImage, String string, Properties properties, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = DefineBitsJPEG3.getPreferredImageWriter(string);
        if (imageWriter == null) {
            throw new IOException(": No writer for format '" + string + "'.");
        }
        UserProperties userProperties = new UserProperties(properties);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam instanceof ImageParamConverter) {
            imageWriteParam = ((ImageParamConverter)((Object)imageWriteParam)).getWriteParam(userProperties);
        }
        String string2 = "org.freehep.graphicsio." + string;
        if (imageWriteParam.canWriteCompressed()) {
            if (userProperties.isProperty(String.valueOf(string2) + COMPRESS)) {
                if (userProperties.getProperty(String.valueOf(string2) + COMPRESS_MODE).equals("")) {
                    imageWriteParam.setCompressionMode(1);
                } else {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionType(userProperties.getProperty(String.valueOf(string2) + COMPRESS_MODE));
                    imageWriteParam.setCompressionQuality(userProperties.getPropertyFloat(String.valueOf(string2) + COMPRESS_QUALITY));
                }
            } else if (DefineBitsJPEG3.canWriteUncompressed(string)) {
                imageWriteParam.setCompressionMode(0);
            }
        }
        if (imageWriteParam.canWriteProgressive()) {
            if (userProperties.isProperty(String.valueOf(string2) + PROGRESSIVE)) {
                imageWriteParam.setProgressiveMode(1);
            } else {
                imageWriteParam.setProgressiveMode(0);
            }
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(renderedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static boolean canWriteUncompressed(String string) {
        return !Arrays.asList(alwaysCompressedFormats).contains(string.toLowerCase());
    }

    public static ImageWriter getPreferredImageWriter(String string) {
        return (ImageWriter)DefineBitsJPEG3.getImageWriters(ImageIO.getImageWritersByFormatName(string)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            private int order(Object object) {
                String string = object.getClass().getName();
                if (string.startsWith("org.freehep.")) {
                    return 0;
                }
                if (string.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (string.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object object, Object object2) {
                int n2;
                int n3 = this.order(object);
                return n3 < (n2 = this.order(object2)) ? -1 : (n3 > n2 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        return treeSet;
    }
}

