/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.util.io.BitOutputStream;

public class ColorXform {
    private int rx = 256;
    private int gx = 256;
    private int bx = 256;
    private int ax = 256;
    private int rp = 0;
    private int gp = 0;
    private int bp = 0;
    private int ap = 0;

    public ColorXform(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.rx = n2;
        this.gx = n3;
        this.bx = n4;
        this.ax = n5;
        this.rp = n6;
        this.gp = n7;
        this.bp = n8;
        this.ap = n9;
    }

    public ColorXform(SWFInputStream sWFInputStream, boolean bl) throws IOException {
        sWFInputStream.byteAlign();
        boolean bl2 = sWFInputStream.readBitFlag();
        boolean bl3 = sWFInputStream.readBitFlag();
        int n2 = (int)sWFInputStream.readUBits(4);
        if (bl3) {
            this.rx = (int)sWFInputStream.readSBits(n2);
            this.gx = (int)sWFInputStream.readSBits(n2);
            this.bx = (int)sWFInputStream.readSBits(n2);
            if (bl) {
                this.ax = (int)sWFInputStream.readSBits(n2);
            }
        }
        if (bl2) {
            this.rp = (int)sWFInputStream.readSBits(n2);
            this.gp = (int)sWFInputStream.readSBits(n2);
            this.bp = (int)sWFInputStream.readSBits(n2);
            if (bl) {
                this.ap = (int)sWFInputStream.readSBits(n2);
            }
        }
    }

    public Color transform(Color color) {
        int n2 = (int)Math.max(0.0, Math.min((double)(color.getRed() * this.rx) / 256.0 + (double)this.rp, 255.0));
        int n3 = (int)Math.max(0.0, Math.min((double)(color.getGreen() * this.gx) / 256.0 + (double)this.gp, 255.0));
        int n4 = (int)Math.max(0.0, Math.min((double)(color.getBlue() * this.bx) / 256.0 + (double)this.bp, 255.0));
        int n5 = (int)Math.max(0.0, Math.min((double)(color.getAlpha() * this.ax) / 256.0 + (double)this.ap, 255.0));
        return new Color(n2, n3, n4, n5);
    }

    public void write(SWFOutputStream sWFOutputStream, boolean bl) throws IOException {
        sWFOutputStream.byteAlign();
        boolean bl2 = this.rp != 0 || this.gp != 0 || this.bp != 0 || bl && this.ap != 0;
        boolean bl3 = this.rx != 1 || this.gx != 1 || this.bx != 1 || bl && this.ax != 1;
        int n2 = 0;
        if (bl3) {
            n2 = Math.max(n2, BitOutputStream.minBits(this.rx, true));
            n2 = Math.max(n2, BitOutputStream.minBits(this.gx, true));
            n2 = Math.max(n2, BitOutputStream.minBits(this.bx, true));
            if (bl) {
                n2 = Math.max(n2, BitOutputStream.minBits(this.ax, true));
            }
        }
        if (bl2) {
            n2 = Math.max(n2, BitOutputStream.minBits(this.rp, true));
            n2 = Math.max(n2, BitOutputStream.minBits(this.gp, true));
            n2 = Math.max(n2, BitOutputStream.minBits(this.bp, true));
            if (bl) {
                n2 = Math.max(n2, BitOutputStream.minBits(this.ap, true));
            }
        }
        sWFOutputStream.writeBitFlag(bl2);
        sWFOutputStream.writeBitFlag(bl3);
        sWFOutputStream.writeUBits(n2, 4);
        if (bl3) {
            sWFOutputStream.writeSBits(this.rx, n2);
            sWFOutputStream.writeSBits(this.gx, n2);
            sWFOutputStream.writeSBits(this.bx, n2);
            if (bl) {
                sWFOutputStream.writeSBits(this.ax, n2);
            }
        }
        if (bl2) {
            sWFOutputStream.writeSBits(this.rp, n2);
            sWFOutputStream.writeSBits(this.gp, n2);
            sWFOutputStream.writeSBits(this.bp, n2);
            if (bl) {
                sWFOutputStream.writeSBits(this.ap, n2);
            }
        }
    }

    public String toString() {
        return "CXForm(" + this.rx + ", " + this.gx + ", " + this.bx + ", " + this.ax + " : " + this.rp + ", " + this.gp + ", " + this.bp + ", " + this.ap + ")";
    }
}

