/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.swf.ColorXform;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class ButtonRecord {
    public static final int UP = 1;
    public static final int OVER = 2;
    public static final int DOWN = 4;
    public static final int HIT = 8;
    private boolean hitTest;
    private boolean down;
    private boolean over;
    private boolean up;
    private int id;
    private int depth;
    private AffineTransform matrix;
    private ColorXform cxform;

    public ButtonRecord(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, AffineTransform affineTransform, ColorXform colorXform) {
        this.hitTest = bl;
        this.down = bl2;
        this.over = bl3;
        this.up = bl4;
        this.id = n2;
        this.depth = n3;
        this.matrix = affineTransform;
        this.cxform = colorXform;
    }

    public ButtonRecord(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, AffineTransform affineTransform) {
        this(bl, bl2, bl3, bl4, n2, n3, affineTransform, null);
    }

    public ButtonRecord(SWFInputStream sWFInputStream, boolean bl) throws IOException {
        sWFInputStream.readUBits(4);
        this.hitTest = sWFInputStream.readBitFlag();
        this.down = sWFInputStream.readBitFlag();
        this.over = sWFInputStream.readBitFlag();
        this.up = sWFInputStream.readBitFlag();
        if (this.isEndRecord()) {
            return;
        }
        this.id = sWFInputStream.readUnsignedShort();
        this.depth = sWFInputStream.readUnsignedShort();
        this.matrix = sWFInputStream.readMatrix();
        if (bl) {
            this.cxform = new ColorXform(sWFInputStream, true);
        } else {
            sWFInputStream.readUnsignedByte();
        }
    }

    public void write(SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUBits(0L, 4);
        sWFOutputStream.writeBitFlag(this.hitTest);
        sWFOutputStream.writeBitFlag(this.down);
        sWFOutputStream.writeBitFlag(this.over);
        sWFOutputStream.writeBitFlag(this.up);
        sWFOutputStream.writeUnsignedShort(this.id);
        sWFOutputStream.writeUnsignedShort(this.depth);
        sWFOutputStream.writeMatrix(this.matrix);
        if (this.cxform != null) {
            this.cxform.write(sWFOutputStream, true);
        } else {
            sWFOutputStream.writeUnsignedByte(0);
        }
    }

    public boolean isEndRecord() {
        return !this.hitTest && !this.down && !this.over && !this.up;
    }

    public String toString() {
        return "ButtonRecord char:" + this.id + " depth:" + this.depth + " " + this.matrix + " " + (this.cxform != null ? "" + this.cxform : "");
    }
}

