/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFNameTable
extends TTFTable {
    private int format;
    private int numberOfNameRecords;
    private int stringStorage;
    private String[][] name = new String[4][19];

    public String getTag() {
        return "name";
    }

    public void readTable() throws IOException {
        this.format = this.ttf.readUShort();
        this.numberOfNameRecords = this.ttf.readUShort();
        this.stringStorage = this.ttf.readUShort();
        for (int i2 = 0; i2 < this.numberOfNameRecords; ++i2) {
            int n2 = this.ttf.readUShort();
            int n3 = this.ttf.readUShort();
            int n4 = this.ttf.readUShort();
            int n5 = this.ttf.readUShort();
            int n6 = this.ttf.readUShort();
            int n7 = this.ttf.readUShort();
            this.ttf.pushPos();
            this.ttf.seek(this.stringStorage + n7);
            byte[] byArray = new byte[n6];
            this.ttf.readFully(byArray);
            if (n2 == 0) {
                this.name[n2][n5] = new String(byArray, "UnicodeBig");
            } else if (n2 == 1 && n3 == 0) {
                if (n4 == 0) {
                    this.name[n2][n5] = new String(byArray, "ISO8859-1");
                }
            } else if (n2 == 3 && n3 == 1) {
                if (n4 == 1033) {
                    this.name[n2][n5] = new String(byArray, "UnicodeBig");
                }
            } else {
                System.out.println("Unimplemented PID, EID, LID scheme: " + n2 + ", " + n3 + ", " + n4);
                System.out.println("NID = " + n5);
                this.name[n2][n5] = new String(byArray, "Default");
            }
            this.ttf.popPos();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  format: " + this.format);
        for (int i2 = 0; i2 < this.name.length; ++i2) {
            for (int i3 = 0; i3 < this.name[i2].length; ++i3) {
                if (this.name[i2][i3] == null) continue;
                stringBuffer.append("\n  name[" + i2 + "][" + i3 + "]: " + this.name[i2][i3]);
            }
        }
        return stringBuffer.toString();
    }
}

