/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;

public class ImageExportFileType
extends AbstractExportFileType {
    protected String format;
    protected ImageWriterSpi spi;
    protected ImageWriteParam param;

    protected ImageExportFileType(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            this.format = string;
            this.spi = imageWriter.getOriginatingProvider();
            this.param = imageWriter.getDefaultWriteParam();
            return;
        }
        throw new IllegalArgumentException(this.getClass() + ": Format not valid: " + string);
    }

    public ImageExportFileType(ImageWriterSpi imageWriterSpi) {
        this.format = imageWriterSpi.getFormatNames()[0];
        this.spi = imageWriterSpi;
        try {
            this.param = imageWriterSpi.createWriterInstance().getDefaultWriteParam();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to create Writer instance", iOException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ImageExportFileType) {
            ImageExportFileType imageExportFileType = (ImageExportFileType)object;
            return this.spi.getClass().equals(imageExportFileType.spi.getClass());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.spi.getClass().hashCode();
    }

    public static ImageExportFileType getInstance(String string) {
        if ((string = string.toLowerCase()).equals("GIF".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.gif.GIFExportFileType");
        }
        if (string.equals("PNG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.png.PNGExportFileType");
        }
        if (string.equals("JPG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.jpg.JPGExportFileType");
        }
        if (string.equals("RAW".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.raw.RawExportFileType");
        }
        if (string.equals("BMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.bmp.BMPExportFileType");
        }
        if (string.equals("WBMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.wbmp.WBMPExportFileType");
        }
        return null;
    }

    private static ImageExportFileType exportFileType(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (ImageExportFileType)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public String getDescription() {
        return this.spi.getDescription(Locale.getDefault());
    }

    public String[] getExtensions() {
        return this.spi.getFileSuffixes();
    }

    public String[] getMIMETypes() {
        return this.spi.getMIMETypes();
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties properties) {
        return new JPanel();
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Component component) throws IOException {
        return new ImageGraphics2D(outputStream, component, this.format);
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Dimension dimension) throws IOException {
        return new ImageGraphics2D(outputStream, dimension, this.format);
    }

    public String toString() {
        return super.toString() + " for " + this.format + " using " + this.spi;
    }
}

