/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.graphics2d.TagString;
import org.freehep.graphicsio.MultiPageDocument;

public class HeadFootDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String[] HF_LABELS = new String[]{"Headline", "Footline"};
    private JTextField[][] textField;
    private JCheckBox[] useCheckBox;
    private TagString[][] text;

    public HeadFootDialog() {
        JComponent jComponent;
        JComponent jComponent2;
        this.setTitle("Head- and footlines");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.textField = new JTextField[HF_LABELS.length][];
        this.useCheckBox = new JCheckBox[HF_LABELS.length];
        JPanel jPanel = new JPanel(new GridLayout(HF_LABELS.length * 2, 1));
        for (int i2 = 0; i2 < HF_LABELS.length; ++i2) {
            jComponent2 = new JPanel(new FlowLayout(0));
            this.useCheckBox[i2] = new JCheckBox();
            this.useCheckBox[i2].setSelected(false);
            this.useCheckBox[i2].addItemListener(this);
            jComponent2.add(this.useCheckBox[i2]);
            jComponent2.add(new JLabel(HF_LABELS[i2]));
            jPanel.add(jComponent2);
            jComponent = new JPanel(new FlowLayout());
            this.textField[i2] = new JTextField[3];
            for (int i3 = 0; i3 < this.textField[i2].length; ++i3) {
                this.textField[i2][i3] = new JTextField(10);
                this.textField[i2][i3].setEnabled(false);
                jComponent.add(this.textField[i2][i3]);
            }
            jPanel.add(jComponent);
        }
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jComponent2 = new JButton("Cancel");
        ((AbstractButton)jComponent2).setActionCommand("cancel");
        ((AbstractButton)jComponent2).addActionListener(this);
        jPanel2.add(jComponent2);
        jComponent = new JButton("Ok");
        ((AbstractButton)jComponent).setActionCommand("ok");
        ((AbstractButton)jComponent).addActionListener(this);
        jPanel2.add(jComponent);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        this.text = new TagString[this.useCheckBox.length][];
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            for (int i2 = 0; i2 < this.useCheckBox.length; ++i2) {
                if (this.useCheckBox[i2].isSelected()) {
                    this.text[i2] = new TagString[3];
                    for (int i3 = 0; i3 < this.textField[i2].length; ++i3) {
                        this.text[i2][i3] = new TagString(this.textField[i2][i3].getText());
                    }
                    continue;
                }
                this.text[i2] = null;
            }
            this.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            for (int i4 = 0; i4 < this.useCheckBox.length; ++i4) {
                this.useCheckBox[i4].setSelected(this.text[i4] != null);
                for (int i5 = 0; i5 < this.textField[i4].length; ++i5) {
                    if (this.text[i4] != null) {
                        this.textField[i4][i5].setText(this.text[i4][i5].toString());
                        this.textField[i4][i5].setEnabled(true);
                        continue;
                    }
                    this.textField[i4][i5].setText("");
                    this.textField[i4][i5].setEnabled(false);
                }
            }
            this.setVisible(false);
        }
    }

    public void configure(MultiPageDocument multiPageDocument) {
        if (this.text[0] != null) {
            multiPageDocument.setHeader(new Font("times", 0, 10), this.text[0][0], this.text[0][1], this.text[0][2], 1);
        }
        if (this.text[1] != null) {
            multiPageDocument.setFooter(new Font("times", 0, 10), this.text[1][0], this.text[1][1], this.text[1][2], 1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        for (int i2 = 0; i2 < this.useCheckBox.length; ++i2) {
            if (itemEvent.getSource() != this.useCheckBox[i2]) continue;
            for (int i3 = 0; i3 < this.textField[i2].length; ++i3) {
                this.textField[i2][i3].setEnabled(itemEvent.getStateChange() == 1);
            }
        }
    }

    public static void main(String[] stringArray) {
        HeadFootDialog headFootDialog = new HeadFootDialog();
        headFootDialog.setVisible(true);
    }
}

