/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphicsio.exportchooser.OptionButton;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BackgroundPanel
extends OptionPanel {
    private Color initialBackground;
    private Color background;
    private JColorChooser colorChooser;
    private OptionButton colorButton;
    private String key;

    public BackgroundPanel(Properties properties, String string, boolean bl) {
        this(properties, string, bl, "Background");
    }

    public BackgroundPanel(Properties properties, String string, boolean bl, String string2) {
        super(string2);
        String string3;
        this.key = string + "." + "BackgroundColor";
        UserProperties userProperties = new UserProperties(properties);
        this.initialBackground = userProperties.getPropertyColor(this.key);
        if (this.initialBackground == null) {
            this.initialBackground = Color.WHITE;
        }
        this.background = this.initialBackground;
        OptionCheckBox optionCheckBox = new OptionCheckBox(properties, string + "." + "Background", "Background");
        this.colorChooser = new JColorChooser(this.initialBackground);
        JDialog jDialog = JColorChooser.createDialog(this, "Choose Background Color", true, this.colorChooser, new ChangeColorListener(), null);
        this.colorButton = new OptionButton(properties, string, "Select Color", jDialog);
        optionCheckBox.enables(this.colorButton);
        String string4 = string2 == null ? "0 * [5 0 5 15] r" : "0 * [5 15 5 15] r";
        String string5 = string3 = string2 == null ? "1 * [5 15 5 0] lw" : "1 * [5 15 5 15] lw";
        if (bl) {
            OptionCheckBox optionCheckBox2 = new OptionCheckBox(properties, string + "." + "Transparent", "Transparent");
            this.add(string4, optionCheckBox2);
            this.add(string3, new JLabel());
            optionCheckBox2.disables(optionCheckBox);
        }
        this.add(string4, optionCheckBox);
        this.add(string3, this.colorButton);
        new ChangeColorListener().actionPerformed(null);
    }

    public boolean applyChangedOptions(Properties properties) {
        boolean bl = super.applyChangedOptions(properties);
        if (!this.background.equals(this.initialBackground)) {
            UserProperties.setProperty(properties, this.key, this.background);
            bl = true;
        }
        return bl;
    }

    class ChangeColorListener
    implements ActionListener {
        ChangeColorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BackgroundPanel.this.background = BackgroundPanel.this.colorChooser.getColor();
            BackgroundPanel.this.colorButton.setBackground(BackgroundPanel.this.background);
            BackgroundPanel.this.colorButton.setForeground(PrintColor.invert(BackgroundPanel.this.background));
        }
    }
}

